/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.protobuf.MessageLite;
import java.util.Objects;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.Proto2Codec;
import org.apache.hadoop.ozone.om.helpers.QuotaUtil;
import org.apache.hadoop.ozone.om.helpers.WithParentObjectId;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@JsonIgnoreProperties(value={"metadata", "objectID", "updateID", "parentObjectID", "objectInfo"})
public final class ReconBasicOmKeyInfo
extends WithParentObjectId {
    private final String volumeName;
    private final String bucketName;
    private final String keyName;
    private final long dataSize;
    private final long creationTime;
    private final long modificationTime;
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="path")
    private String path;
    @JsonProperty(value="replicatedSize")
    private final long replicatedSize;
    @JsonProperty(value="replicationInfo")
    private final ReplicationConfig replicationConfig;
    private final boolean isFile;
    private long parentId;

    public static Codec<ReconBasicOmKeyInfo> getCodec() {
        return DelegatedCodec.decodeOnly((Codec)Proto2Codec.get((MessageLite)OzoneManagerProtocolProtos.KeyInfoProtoLight.getDefaultInstance()), ReconBasicOmKeyInfo::getFromProtobuf, ReconBasicOmKeyInfo.class);
    }

    private ReconBasicOmKeyInfo(Builder b) {
        this.volumeName = b.volumeName;
        this.bucketName = b.bucketName;
        this.keyName = b.keyName;
        this.dataSize = b.dataSize;
        this.creationTime = b.creationTime;
        this.modificationTime = b.modificationTime;
        this.replicationConfig = b.replicationConfig;
        this.replicatedSize = QuotaUtil.getReplicatedSize((long)this.getDataSize(), (ReplicationConfig)this.replicationConfig);
        this.isFile = b.isFile;
        this.parentId = b.parentId;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    @JsonProperty(value="creationTime")
    public long getCreationTime() {
        return this.creationTime;
    }

    @JsonProperty(value="modificationTime")
    public long getModificationTime() {
        return this.modificationTime;
    }

    @JsonProperty(value="replicationInfo")
    public ReplicationConfig getReplicationConfig() {
        return this.replicationConfig;
    }

    public boolean isFile() {
        return this.isFile;
    }

    @JsonProperty(value="replicatedSize")
    public long getReplicatedSize() {
        return this.replicatedSize;
    }

    @JsonProperty(value="key")
    public String getKey() {
        if (this.key == null) {
            throw new IllegalStateException("Key must be set to correctly serialize this object.");
        }
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @JsonProperty(value="path")
    public String getPath() {
        if (this.path == null) {
            throw new IllegalStateException("Path must be set to correctly serialize this object.");
        }
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @JsonProperty(value="size")
    public long getSize() {
        return this.dataSize;
    }

    @JsonProperty(value="isKey")
    public boolean getIsKey() {
        return this.isFile();
    }

    public long getParentId() {
        return this.parentId;
    }

    public static ReconBasicOmKeyInfo getFromProtobuf(OzoneManagerProtocolProtos.KeyInfoProtoLight keyInfoProtoLight) {
        if (keyInfoProtoLight == null) {
            return null;
        }
        String keyName = keyInfoProtoLight.getKeyName();
        Builder builder = new Builder().setVolumeName(keyInfoProtoLight.getVolumeName()).setBucketName(keyInfoProtoLight.getBucketName()).setKeyName(keyName).setDataSize(keyInfoProtoLight.getDataSize()).setCreationTime(keyInfoProtoLight.getCreationTime()).setModificationTime(keyInfoProtoLight.getModificationTime()).setReplicationConfig(ReplicationConfig.fromProto((HddsProtos.ReplicationType)keyInfoProtoLight.getType(), (HddsProtos.ReplicationFactor)keyInfoProtoLight.getFactor(), (HddsProtos.ECReplicationConfig)keyInfoProtoLight.getEcReplicationConfig())).setIsFile(!keyName.endsWith("/")).setParentId(keyInfoProtoLight.getParentID());
        return builder.build();
    }

    public OzoneManagerProtocolProtos.KeyInfoProtoLight toProtobuf() {
        throw new UnsupportedOperationException("This method is not supported.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ReconBasicOmKeyInfo basicOmKeyInfo = (ReconBasicOmKeyInfo)((Object)o);
        return this.volumeName.equals(basicOmKeyInfo.volumeName) && this.bucketName.equals(basicOmKeyInfo.bucketName) && this.keyName.equals(basicOmKeyInfo.keyName) && this.dataSize == basicOmKeyInfo.dataSize && this.creationTime == basicOmKeyInfo.creationTime && this.modificationTime == basicOmKeyInfo.modificationTime && this.replicationConfig.equals((Object)basicOmKeyInfo.replicationConfig) && this.isFile == basicOmKeyInfo.isFile;
    }

    public int hashCode() {
        return Objects.hash(this.volumeName, this.bucketName, this.keyName);
    }

    public static class Builder {
        private String volumeName;
        private String bucketName;
        private String keyName;
        private long dataSize;
        private long creationTime;
        private long modificationTime;
        private ReplicationConfig replicationConfig;
        private boolean isFile;
        private long parentId;

        public Builder setVolumeName(String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        public Builder setBucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder setKeyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public Builder setDataSize(long dataSize) {
            this.dataSize = dataSize;
            return this;
        }

        public Builder setCreationTime(long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public Builder setModificationTime(long modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        public Builder setReplicationConfig(ReplicationConfig replicationConfig) {
            this.replicationConfig = replicationConfig;
            return this;
        }

        public Builder setIsFile(boolean isFile) {
            this.isFile = isFile;
            return this;
        }

        public Builder setParentId(long parentId) {
            this.parentId = parentId;
            return this;
        }

        public ReconBasicOmKeyInfo build() {
            return new ReconBasicOmKeyInfo(this);
        }
    }
}

