/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.metrics;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.ozone.recon.schema.generated.tables.daos.ReconTaskStatusDao;

@Singleton
@Metrics(about="Recon Task Status Metrics", context="ozone")
public class ReconTaskStatusMetrics
implements MetricsSource {
    private static final String SOURCE_NAME = ReconTaskStatusMetrics.class.getSimpleName();
    @Inject
    private ReconTaskStatusDao reconTaskStatusDao;
    private static final MetricsInfo RECORD_INFO_LAST_UPDATED_TS = Interns.info((String)"lastUpdatedTimestamp", (String)"Last updated timestamp of corresponding Recon Task");
    private static final MetricsInfo RECORD_INFO_LAST_UPDATED_SEQ = Interns.info((String)"lastUpdatedSeqNumber", (String)"Last updated sequence number of corresponding Recon Task");

    public void register() {
        DefaultMetricsSystem.instance().register(SOURCE_NAME, "Recon Task Metrics", (Object)this);
    }

    public void unregister() {
        DefaultMetricsSystem.instance().unregisterSource(SOURCE_NAME);
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        List rows = this.reconTaskStatusDao.findAll();
        rows.forEach(rts -> {
            MetricsRecordBuilder builder = collector.addRecord(SOURCE_NAME);
            builder.add(new MetricsTag(Interns.info((String)"type", (String)"Recon Task type"), rts.getTaskName()));
            builder.addGauge(RECORD_INFO_LAST_UPDATED_TS, rts.getLastUpdatedTimestamp().longValue());
            builder.addCounter(RECORD_INFO_LAST_UPDATED_SEQ, rts.getLastUpdatedSeqNumber().longValue());
            builder.endRecord();
        });
    }
}

