/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.recon.ReconResponseUtils;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.api.AdminOnly;
import org.apache.hadoop.ozone.recon.api.ServiceNotReadyException;
import org.apache.hadoop.ozone.recon.api.handlers.BucketHandler;
import org.apache.hadoop.ozone.recon.api.handlers.EntityHandler;
import org.apache.hadoop.ozone.recon.api.types.KeyEntityInfo;
import org.apache.hadoop.ozone.recon.api.types.KeyEntityInfoProtoWrapper;
import org.apache.hadoop.ozone.recon.api.types.KeyInsightInfoResponse;
import org.apache.hadoop.ozone.recon.api.types.ListKeysResponse;
import org.apache.hadoop.ozone.recon.api.types.NSSummary;
import org.apache.hadoop.ozone.recon.api.types.ParamInfo;
import org.apache.hadoop.ozone.recon.api.types.ResponseStatus;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.impl.ReconNamespaceSummaryManagerImpl;
import org.apache.hadoop.ozone.recon.tasks.OmTableInsightTask;
import org.apache.ozone.recon.schema.generated.tables.daos.GlobalStatsDao;
import org.apache.ozone.recon.schema.generated.tables.pojos.GlobalStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/keys")
@Produces(value={"application/json"})
@AdminOnly
public class OMDBInsightEndpoint {
    private final ReconOMMetadataManager omMetadataManager;
    private static final Logger LOG = LoggerFactory.getLogger(OMDBInsightEndpoint.class);
    private final GlobalStatsDao globalStatsDao;
    private ReconNamespaceSummaryManagerImpl reconNamespaceSummaryManager;
    private final OzoneStorageContainerManager reconSCM;

    @Inject
    public OMDBInsightEndpoint(OzoneStorageContainerManager reconSCM, ReconOMMetadataManager omMetadataManager, GlobalStatsDao globalStatsDao, ReconNamespaceSummaryManagerImpl reconNamespaceSummaryManager) {
        this.omMetadataManager = omMetadataManager;
        this.globalStatsDao = globalStatsDao;
        this.reconNamespaceSummaryManager = reconNamespaceSummaryManager;
        this.reconSCM = reconSCM;
    }

    @GET
    @Path(value="/open")
    public Response getOpenKeyInfo(@DefaultValue(value="1000") @QueryParam(value="limit") int limit, @DefaultValue(value="") @QueryParam(value="prevKey") String prevKey, @DefaultValue(value="") @QueryParam(value="startPrefix") String startPrefix, @DefaultValue(value="false") @QueryParam(value="includeFso") boolean includeFso, @DefaultValue(value="false") @QueryParam(value="includeNonFso") boolean includeNonFso) {
        KeyInsightInfoResponse openKeyInsightInfo = new KeyInsightInfoResponse();
        try {
            long replicatedTotal = 0L;
            long unreplicatedTotal = 0L;
            boolean skipPrevKeyDone = false;
            boolean keysFound = false;
            String lastKey = null;
            Map<Object, Object> obsKeys = Collections.emptyMap();
            Map<Object, Object> fsoKeys = Collections.emptyMap();
            if (StringUtils.isNotBlank((CharSequence)startPrefix) && !this.validateStartPrefix(startPrefix)) {
                return ReconResponseUtils.createBadRequestResponse("Invalid startPrefix: Path must be at the bucket level or deeper.");
            }
            if (includeNonFso) {
                Table openKeyTable = this.omMetadataManager.getOpenKeyTable(BucketLayout.LEGACY);
                obsKeys = ReconUtils.extractKeysFromTable(openKeyTable, startPrefix, limit, prevKey);
                for (Map.Entry<Object, Object> entry : obsKeys.entrySet()) {
                    keysFound = true;
                    skipPrevKeyDone = true;
                    KeyEntityInfo keyEntityInfo = this.createKeyEntityInfoFromOmKeyInfo((String)entry.getKey(), (OmKeyInfo)entry.getValue());
                    openKeyInsightInfo.getNonFSOKeyInfoList().add(keyEntityInfo);
                    replicatedTotal += ((OmKeyInfo)entry.getValue()).getReplicatedSize();
                    unreplicatedTotal += ((OmKeyInfo)entry.getValue()).getDataSize();
                    lastKey = (String)entry.getKey();
                }
            }
            if (includeFso) {
                String effectivePrevKey = skipPrevKeyDone ? "" : prevKey;
                int effectiveLimit = limit == -1 ? limit : limit - obsKeys.size();
                fsoKeys = this.searchOpenKeysInFSO(startPrefix, effectiveLimit, effectivePrevKey);
                for (Map.Entry<Object, Object> entry : fsoKeys.entrySet()) {
                    keysFound = true;
                    KeyEntityInfo keyEntityInfo = this.createKeyEntityInfoFromOmKeyInfo((String)entry.getKey(), (OmKeyInfo)entry.getValue());
                    openKeyInsightInfo.getFsoKeyInfoList().add(keyEntityInfo);
                    replicatedTotal += ((OmKeyInfo)entry.getValue()).getReplicatedSize();
                    unreplicatedTotal += ((OmKeyInfo)entry.getValue()).getDataSize();
                    lastKey = (String)entry.getKey();
                }
            }
            if (!keysFound) {
                return ReconResponseUtils.noMatchedKeysResponse(startPrefix);
            }
            openKeyInsightInfo.setReplicatedDataSize(replicatedTotal);
            openKeyInsightInfo.setUnreplicatedDataSize(unreplicatedTotal);
            openKeyInsightInfo.setLastKey(lastKey);
            return Response.ok((Object)openKeyInsightInfo).build();
        }
        catch (IOException e) {
            return ReconResponseUtils.createInternalServerErrorResponse("Error searching open keys in OM DB: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            return ReconResponseUtils.createBadRequestResponse("Invalid argument: " + e.getMessage());
        }
    }

    public Map<String, OmKeyInfo> searchOpenKeysInFSO(String startPrefix, int limit, String prevKey) throws IOException, IllegalArgumentException {
        LinkedHashMap<String, OmKeyInfo> matchedKeys = new LinkedHashMap<String, OmKeyInfo>();
        String startPrefixObjectPath = ReconUtils.convertToObjectPathForOpenKeySearch(startPrefix, this.omMetadataManager, this.reconNamespaceSummaryManager, this.reconSCM);
        String[] names = EntityHandler.parseRequestPath(startPrefixObjectPath);
        Table openFileTable = this.omMetadataManager.getOpenKeyTable(BucketLayout.FILE_SYSTEM_OPTIMIZED);
        if (names.length > 2 && startPrefixObjectPath.endsWith("/")) {
            long parentId = Long.parseLong(names[names.length - 1]);
            NSSummary parentSummary = this.reconNamespaceSummaryManager.getNSSummary(parentId);
            if (parentSummary == null) {
                return matchedKeys;
            }
            ArrayList<String> subPaths = new ArrayList<String>();
            subPaths.add(startPrefixObjectPath);
            ReconUtils.gatherSubPaths(parentId, subPaths, Long.parseLong(names[0]), Long.parseLong(names[1]), this.reconNamespaceSummaryManager);
            for (String subPath : subPaths) {
                matchedKeys.putAll(ReconUtils.extractKeysFromTable(openFileTable, subPath, limit - matchedKeys.size(), prevKey));
                if (matchedKeys.size() < limit) continue;
                break;
            }
            return matchedKeys;
        }
        matchedKeys.putAll(ReconUtils.extractKeysFromTable(openFileTable, startPrefixObjectPath, limit, prevKey));
        return matchedKeys;
    }

    @GET
    @Path(value="/open/summary")
    public Response getOpenKeySummary() {
        HashMap<String, Long> keysSummary = new HashMap<String, Long>();
        this.createKeysSummaryForOpenKey(keysSummary);
        return Response.ok(keysSummary).build();
    }

    private void createKeysSummaryForOpenKey(Map<String, Long> keysSummary) {
        Long replicatedSizeOpenKey = this.getValueFromId((GlobalStats)this.globalStatsDao.findById(OmTableInsightTask.getReplicatedSizeKeyFromTable("openKeyTable")));
        Long replicatedSizeOpenFile = this.getValueFromId((GlobalStats)this.globalStatsDao.findById(OmTableInsightTask.getReplicatedSizeKeyFromTable("openFileTable")));
        Long unreplicatedSizeOpenKey = this.getValueFromId((GlobalStats)this.globalStatsDao.findById(OmTableInsightTask.getUnReplicatedSizeKeyFromTable("openKeyTable")));
        Long unreplicatedSizeOpenFile = this.getValueFromId((GlobalStats)this.globalStatsDao.findById(OmTableInsightTask.getUnReplicatedSizeKeyFromTable("openFileTable")));
        Long openKeyCountForKeyTable = this.getValueFromId((GlobalStats)this.globalStatsDao.findById(OmTableInsightTask.getTableCountKeyFromTable("openKeyTable")));
        Long openKeyCountForFileTable = this.getValueFromId((GlobalStats)this.globalStatsDao.findById(OmTableInsightTask.getTableCountKeyFromTable("openFileTable")));
        keysSummary.put("totalOpenKeys", openKeyCountForKeyTable + openKeyCountForFileTable);
        keysSummary.put("totalReplicatedDataSize", replicatedSizeOpenKey + replicatedSizeOpenFile);
        keysSummary.put("totalUnreplicatedDataSize", unreplicatedSizeOpenKey + unreplicatedSizeOpenFile);
    }

    private Long getValueFromId(GlobalStats record) {
        return record != null ? record.getValue() : 0L;
    }

    @GET
    @Path(value="/deletePending/summary")
    public Response getDeletedKeySummary() {
        HashMap<String, Long> keysSummary = new HashMap<String, Long>();
        this.createKeysSummaryForDeletedKey(keysSummary);
        return Response.ok(keysSummary).build();
    }

    @GET
    @Path(value="/deletePending")
    public Response getDeletedKeyInfo(@DefaultValue(value="1000") @QueryParam(value="limit") int limit, @DefaultValue(value="") @QueryParam(value="prevKey") String prevKey, @DefaultValue(value="") @QueryParam(value="startPrefix") String startPrefix) {
        KeyInsightInfoResponse deletedKeyInsightInfo = new KeyInsightInfoResponse();
        boolean keysFound = false;
        try {
            if (StringUtils.isNotBlank((CharSequence)startPrefix) && !this.validateStartPrefix(startPrefix)) {
                return ReconResponseUtils.createBadRequestResponse("Invalid startPrefix: Path must be at the bucket level or deeper.");
            }
            keysFound = this.getPendingForDeletionKeyInfo(limit, prevKey, startPrefix, deletedKeyInsightInfo);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Invalid startPrefix provided: {}", (Object)startPrefix, (Object)e);
            return ReconResponseUtils.createBadRequestResponse("Invalid startPrefix: " + e.getMessage());
        }
        catch (IOException e) {
            LOG.error("I/O error while searching deleted keys in OM DB", (Throwable)e);
            return ReconResponseUtils.createInternalServerErrorResponse("Error searching deleted keys in OM DB: " + e.getMessage());
        }
        catch (Exception e) {
            LOG.error("Unexpected error occurred while searching deleted keys", (Throwable)e);
            return ReconResponseUtils.createInternalServerErrorResponse("Unexpected error: " + e.getMessage());
        }
        if (!keysFound) {
            return ReconResponseUtils.noMatchedKeysResponse("");
        }
        return Response.ok((Object)deletedKeyInsightInfo).build();
    }

    private boolean getPendingForDeletionKeyInfo(int limit, String prevKey, String startPrefix, KeyInsightInfoResponse deletedKeyInsightInfo) throws IOException {
        long replicatedTotal = 0L;
        long unreplicatedTotal = 0L;
        boolean keysFound = false;
        String lastKey = null;
        Table deletedTable = this.omMetadataManager.getDeletedTable();
        Map deletedKeys = ReconUtils.extractKeysFromTable(deletedTable, startPrefix, limit, prevKey);
        for (Map.Entry entry : deletedKeys.entrySet()) {
            keysFound = true;
            RepeatedOmKeyInfo repeatedOmKeyInfo = (RepeatedOmKeyInfo)entry.getValue();
            OmKeyInfo keyInfo = (OmKeyInfo)repeatedOmKeyInfo.getOmKeyInfoList().get(0);
            KeyEntityInfo keyEntityInfo = this.createKeyEntityInfoFromOmKeyInfo(entry.getKey(), keyInfo);
            deletedKeyInsightInfo.getRepeatedOmKeyInfoList().add(repeatedOmKeyInfo);
            replicatedTotal += keyInfo.getReplicatedSize();
            unreplicatedTotal += keyInfo.getDataSize();
            lastKey = entry.getKey();
        }
        deletedKeyInsightInfo.setReplicatedDataSize(replicatedTotal);
        deletedKeyInsightInfo.setUnreplicatedDataSize(unreplicatedTotal);
        deletedKeyInsightInfo.setLastKey(lastKey);
        return keysFound;
    }

    private void createKeysSummaryForDeletedKey(Map<String, Long> keysSummary) {
        Long replicatedSizeDeleted = this.getValueFromId((GlobalStats)this.globalStatsDao.findById(OmTableInsightTask.getReplicatedSizeKeyFromTable("deletedTable")));
        Long unreplicatedSizeDeleted = this.getValueFromId((GlobalStats)this.globalStatsDao.findById(OmTableInsightTask.getUnReplicatedSizeKeyFromTable("deletedTable")));
        Long deletedKeyCount = this.getValueFromId((GlobalStats)this.globalStatsDao.findById(OmTableInsightTask.getTableCountKeyFromTable("deletedTable")));
        keysSummary.put("totalDeletedKeys", deletedKeyCount);
        keysSummary.put("totalReplicatedDataSize", replicatedSizeDeleted);
        keysSummary.put("totalUnreplicatedDataSize", unreplicatedSizeDeleted);
    }

    private void getPendingForDeletionDirInfo(int limit, String prevKey, KeyInsightInfoResponse pendingForDeletionKeyInfo) {
        List<KeyEntityInfo> deletedDirInfoList = pendingForDeletionKeyInfo.getDeletedDirInfoList();
        Table deletedDirTable = this.omMetadataManager.getDeletedDirTable();
        try (TableIterator keyIter = deletedDirTable.iterator();){
            boolean skipPrevKey = false;
            String seekKey = prevKey;
            String lastKey = "";
            if (StringUtils.isNotBlank((CharSequence)prevKey)) {
                skipPrevKey = true;
                Table.KeyValue seekKeyValue = (Table.KeyValue)keyIter.seek((Object)seekKey);
                if (seekKeyValue == null || StringUtils.isNotBlank((CharSequence)prevKey) && !((String)seekKeyValue.getKey()).equals(prevKey)) {
                    return;
                }
            }
            while (keyIter.hasNext()) {
                String key;
                Table.KeyValue kv = (Table.KeyValue)keyIter.next();
                lastKey = key = (String)kv.getKey();
                OmKeyInfo omKeyInfo = (OmKeyInfo)kv.getValue();
                if (skipPrevKey && key.equals(prevKey)) continue;
                KeyEntityInfo keyEntityInfo = new KeyEntityInfo();
                keyEntityInfo.setIsKey(omKeyInfo.isFile());
                keyEntityInfo.setKey(omKeyInfo.getFileName());
                keyEntityInfo.setPath(this.createPath(omKeyInfo));
                keyEntityInfo.setInStateSince(omKeyInfo.getCreationTime());
                keyEntityInfo.setSize(this.fetchSizeForDeletedDirectory(omKeyInfo.getObjectID()));
                keyEntityInfo.setReplicatedSize(omKeyInfo.getReplicatedSize());
                keyEntityInfo.setReplicationConfig(omKeyInfo.getReplicationConfig());
                pendingForDeletionKeyInfo.setUnreplicatedDataSize(pendingForDeletionKeyInfo.getUnreplicatedDataSize() + keyEntityInfo.getSize());
                pendingForDeletionKeyInfo.setReplicatedDataSize(pendingForDeletionKeyInfo.getReplicatedDataSize() + keyEntityInfo.getReplicatedSize());
                deletedDirInfoList.add(keyEntityInfo);
                if (deletedDirInfoList.size() != limit) continue;
                break;
            }
            pendingForDeletionKeyInfo.setLastKey(lastKey);
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected long fetchSizeForDeletedDirectory(long objectId) throws IOException {
        NSSummary nsSummary = this.reconNamespaceSummaryManager.getNSSummary(objectId);
        if (nsSummary == null) {
            return 0L;
        }
        long totalSize = nsSummary.getSizeOfFiles();
        for (long childId : nsSummary.getChildDir()) {
            totalSize += this.fetchSizeForDeletedDirectory(childId);
        }
        return totalSize;
    }

    @GET
    @Path(value="/deletePending/dirs")
    public Response getDeletedDirInfo(@DefaultValue(value="1000") @QueryParam(value="limit") int limit, @DefaultValue(value="") @QueryParam(value="prevKey") String prevKey) {
        KeyInsightInfoResponse deletedDirInsightInfo = new KeyInsightInfoResponse();
        this.getPendingForDeletionDirInfo(limit, prevKey, deletedDirInsightInfo);
        return Response.ok((Object)deletedDirInsightInfo).build();
    }

    @GET
    @Path(value="/deletePending/dirs/summary")
    public Response getDeletedDirectorySummary() {
        HashMap<String, Long> dirSummary = new HashMap<String, Long>();
        this.createSummaryForDeletedDirectories(dirSummary);
        return Response.ok(dirSummary).build();
    }

    @GET
    @Path(value="/listKeys")
    public Response listKeys(@QueryParam(value="replicationType") String replicationType, @QueryParam(value="creationDate") String creationDate, @DefaultValue(value="0") @QueryParam(value="keySize") long keySize, @DefaultValue(value="/") @QueryParam(value="startPrefix") String startPrefix, @DefaultValue(value="") @QueryParam(value="prevKey") String prevKey, @DefaultValue(value="1000") @QueryParam(value="limit") int limit) {
        List<KeyEntityInfoProtoWrapper> keyInfoList;
        if (startPrefix == null || startPrefix.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        String[] names = startPrefix.split("/");
        if (names.length < 3) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        ListKeysResponse listKeysResponse = new ListKeysResponse();
        if (!ReconUtils.isInitializationComplete(this.omMetadataManager)) {
            listKeysResponse.setStatus(ResponseStatus.INITIALIZING);
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)listKeysResponse).build();
        }
        ParamInfo paramInfo = new ParamInfo(replicationType, creationDate, keySize, startPrefix, prevKey, limit, false, "");
        Response response = this.getListKeysResponse(paramInfo);
        if (response.getStatus() != Response.Status.OK.getStatusCode() && response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
            return response;
        }
        if (response.getEntity() instanceof ListKeysResponse) {
            listKeysResponse = (ListKeysResponse)response.getEntity();
        }
        if (!(keyInfoList = listKeysResponse.getKeys()).isEmpty()) {
            listKeysResponse.setLastKey(keyInfoList.get(keyInfoList.size() - 1).getKey());
        }
        return Response.ok((Object)listKeysResponse).build();
    }

    private Response getListKeysResponse(ParamInfo paramInfo) {
        ListKeysResponse listKeysResponse = new ListKeysResponse();
        try {
            paramInfo.setLimit(Math.max(0, paramInfo.getLimit()));
            listKeysResponse.setPath(paramInfo.getStartPrefix());
            long replicatedTotal = 0L;
            long unreplicatedTotal = 0L;
            Table<String, KeyEntityInfoProtoWrapper> keyTable = this.omMetadataManager.getKeyTableLite(BucketLayout.LEGACY);
            this.retrieveKeysFromTable(keyTable, paramInfo, listKeysResponse.getKeys());
            this.searchKeysInFSO(paramInfo, listKeysResponse.getKeys());
            if (listKeysResponse.getKeys().isEmpty()) {
                return ReconResponseUtils.noMatchedKeysResponse(paramInfo.getStartPrefix());
            }
            for (KeyEntityInfoProtoWrapper keyEntityInfo : listKeysResponse.getKeys()) {
                replicatedTotal += keyEntityInfo.getReplicatedSize();
                unreplicatedTotal += keyEntityInfo.getSize();
            }
            listKeysResponse.setReplicatedDataSize(replicatedTotal);
            listKeysResponse.setUnReplicatedDataSize(unreplicatedTotal);
            return Response.ok((Object)listKeysResponse).build();
        }
        catch (RuntimeException e) {
            if (e instanceof ServiceNotReadyException) {
                listKeysResponse.setStatus(ResponseStatus.INITIALIZING);
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)listKeysResponse).build();
            }
            LOG.error("Error generating listKeys response", (Throwable)e);
            return ReconResponseUtils.createInternalServerErrorResponse("Unexpected runtime error while searching keys in OM DB: " + e.getMessage());
        }
        catch (Exception e) {
            LOG.error("Error generating listKeys response", (Throwable)e);
            return ReconResponseUtils.createInternalServerErrorResponse("Error listing keys from OM DB: " + e.getMessage());
        }
    }

    public void searchKeysInFSO(ParamInfo paramInfo, List<KeyEntityInfoProtoWrapper> results) throws IOException {
        String startPrefixObjectPath = this.convertStartPrefixPathToObjectIdPath(paramInfo.getStartPrefix());
        String[] names = EntityHandler.parseRequestPath(startPrefixObjectPath);
        Table<String, KeyEntityInfoProtoWrapper> fileTable = this.omMetadataManager.getKeyTableLite(BucketLayout.FILE_SYSTEM_OPTIMIZED);
        if (names.length > 2) {
            long parentId = Long.parseLong(names[names.length - 1]);
            NSSummary parentSummary = this.reconNamespaceSummaryManager.getNSSummary(parentId);
            if (parentSummary == null) {
                return;
            }
            ArrayList<String> subPaths = new ArrayList<String>();
            subPaths.add(startPrefixObjectPath);
            ReconUtils.gatherSubPaths(parentId, subPaths, Long.parseLong(names[0]), Long.parseLong(names[1]), this.reconNamespaceSummaryManager);
            for (String subPath : subPaths) {
                paramInfo.setStartPrefix(subPath);
                this.retrieveKeysFromTable(fileTable, paramInfo, results);
                if (results.size() < paramInfo.getLimit()) continue;
                break;
            }
            return;
        }
        paramInfo.setStartPrefix(startPrefixObjectPath);
        this.retrieveKeysFromTable(fileTable, paramInfo, results);
    }

    public String convertStartPrefixPathToObjectIdPath(String startPrefixPath) throws IOException {
        String[] names = EntityHandler.parseRequestPath(EntityHandler.normalizePath(startPrefixPath, BucketLayout.FILE_SYSTEM_OPTIMIZED));
        if (names.length == 0) {
            return startPrefixPath;
        }
        String volumeName = names[0];
        ReconUtils.validateNames(volumeName);
        String volumeKey = this.omMetadataManager.getVolumeKey(volumeName);
        long volumeId = ((OmVolumeArgs)this.omMetadataManager.getVolumeTable().getSkipCache((Object)volumeKey)).getObjectID();
        if (names.length == 1) {
            return ReconUtils.constructObjectPathWithPrefix(volumeId);
        }
        String bucketName = names[1];
        ReconUtils.validateNames(bucketName);
        String bucketKey = this.omMetadataManager.getBucketKey(volumeName, bucketName);
        OmBucketInfo bucketInfo = (OmBucketInfo)this.omMetadataManager.getBucketTable().getSkipCache((Object)bucketKey);
        long bucketId = bucketInfo.getObjectID();
        if (names.length == 2) {
            return ReconUtils.constructObjectPathWithPrefix(volumeId, bucketId);
        }
        BucketHandler handler = BucketHandler.getBucketHandler(this.reconNamespaceSummaryManager, this.omMetadataManager, this.reconSCM, bucketInfo);
        long dirObjectId = -1L;
        try {
            OmDirectoryInfo dirInfo = handler.getDirInfo(names);
            if (null == dirInfo) {
                throw new IllegalArgumentException("Not valid path");
            }
            dirObjectId = dirInfo.getObjectID();
        }
        catch (Exception ioe) {
            throw new IllegalArgumentException("Not valid path: " + ioe);
        }
        return ReconUtils.constructObjectPathWithPrefix(volumeId, bucketId, dirObjectId);
    }

    private void retrieveKeysFromTable(Table<String, KeyEntityInfoProtoWrapper> table, ParamInfo paramInfo, List<KeyEntityInfoProtoWrapper> results) throws IOException {
        boolean skipPrevKey = false;
        String seekKey = paramInfo.getPrevKey();
        try (TableIterator keyIter = table.iterator();){
            if (!paramInfo.isSkipPrevKeyDone() && StringUtils.isNotBlank((CharSequence)seekKey)) {
                skipPrevKey = true;
                Table.KeyValue seekKeyValue = (Table.KeyValue)keyIter.seek((Object)seekKey);
                if (seekKeyValue == null || !((String)seekKeyValue.getKey()).equals(paramInfo.getPrevKey())) {
                    return;
                }
            } else {
                keyIter.seek((Object)paramInfo.getStartPrefix());
            }
            long prevParentID = -1L;
            StringBuilder keyPrefix = null;
            int keyPrefixLength = 0;
            while (keyIter.hasNext()) {
                Table.KeyValue entry = (Table.KeyValue)keyIter.next();
                String dbKey = (String)entry.getKey();
                if (!dbKey.startsWith(paramInfo.getStartPrefix())) {
                } else {
                    if (skipPrevKey && dbKey.equals(paramInfo.getPrevKey())) {
                        paramInfo.setSkipPrevKeyDone(true);
                        continue;
                    }
                    if (!this.applyFilters((Table.KeyValue<String, KeyEntityInfoProtoWrapper>)entry, paramInfo)) continue;
                    KeyEntityInfoProtoWrapper keyEntityInfo = (KeyEntityInfoProtoWrapper)entry.getValue();
                    keyEntityInfo.setKey(dbKey);
                    if (keyEntityInfo.getParentId() == 0L) {
                        prevParentID = -1L;
                        keyEntityInfo.setPath(ReconUtils.constructFullPath(keyEntityInfo.getKeyName(), keyEntityInfo.getParentId(), keyEntityInfo.getVolumeName(), keyEntityInfo.getBucketName(), this.reconNamespaceSummaryManager, this.omMetadataManager));
                    } else {
                        if (prevParentID != keyEntityInfo.getParentId()) {
                            prevParentID = keyEntityInfo.getParentId();
                            keyPrefix = ReconUtils.constructFullPathPrefix(keyEntityInfo.getParentId(), keyEntityInfo.getVolumeName(), keyEntityInfo.getBucketName(), this.reconNamespaceSummaryManager, this.omMetadataManager);
                            keyPrefixLength = keyPrefix.length();
                        }
                        keyPrefix.setLength(keyPrefixLength);
                        keyPrefix.append(keyEntityInfo.getKeyName());
                        keyEntityInfo.setPath(keyPrefix.toString());
                    }
                    results.add(keyEntityInfo);
                    paramInfo.setLastKey(dbKey);
                    if (results.size() < paramInfo.getLimit()) continue;
                }
                break;
            }
        }
        catch (IOException exception) {
            LOG.error("Error retrieving keys from table for path: {}", (Object)paramInfo.getStartPrefix(), (Object)exception);
            throw exception;
        }
    }

    private boolean applyFilters(Table.KeyValue<String, KeyEntityInfoProtoWrapper> entry, ParamInfo paramInfo) throws IOException {
        LOG.debug("Applying filters on : {}", entry.getKey());
        if (!StringUtils.isEmpty((CharSequence)paramInfo.getCreationDate()) && ((KeyEntityInfoProtoWrapper)entry.getValue()).getCreationTime() < paramInfo.getCreationDateEpoch()) {
            return false;
        }
        if (!StringUtils.isEmpty((CharSequence)paramInfo.getReplicationType()) && !((KeyEntityInfoProtoWrapper)entry.getValue()).getReplicationConfig().getReplicationType().name().equals(paramInfo.getReplicationType())) {
            return false;
        }
        return ((KeyEntityInfoProtoWrapper)entry.getValue()).getSize() >= paramInfo.getKeySize();
    }

    private KeyEntityInfo createKeyEntityInfoFromOmKeyInfo(String dbKey, OmKeyInfo keyInfo) throws IOException {
        KeyEntityInfo keyEntityInfo = new KeyEntityInfo();
        keyEntityInfo.setKey(dbKey);
        keyEntityInfo.setIsKey(keyInfo.isFile());
        keyEntityInfo.setPath(ReconUtils.constructFullPath(keyInfo, this.reconNamespaceSummaryManager, this.omMetadataManager));
        keyEntityInfo.setSize(keyInfo.getDataSize());
        keyEntityInfo.setCreationTime(keyInfo.getCreationTime());
        keyEntityInfo.setModificationTime(keyInfo.getModificationTime());
        keyEntityInfo.setReplicatedSize(keyInfo.getReplicatedSize());
        keyEntityInfo.setReplicationConfig(keyInfo.getReplicationConfig());
        return keyEntityInfo;
    }

    private void createSummaryForDeletedDirectories(Map<String, Long> dirSummary) {
        Long deletedDirCount = this.getValueFromId((GlobalStats)this.globalStatsDao.findById(OmTableInsightTask.getTableCountKeyFromTable("deletedDirectoryTable")));
        dirSummary.put("totalDeletedDirectories", deletedDirCount);
    }

    private boolean validateStartPrefix(String startPrefix) {
        String[] pathComponents = (startPrefix = startPrefix.startsWith("/") ? startPrefix : "/" + startPrefix).split("/");
        return pathComponents.length >= 3 && !pathComponents[2].isEmpty();
    }

    private String createPath(OmKeyInfo omKeyInfo) {
        return omKeyInfo.getVolumeName() + "/" + omKeyInfo.getBucketName() + "/" + omKeyInfo.getKeyName();
    }

    @VisibleForTesting
    public GlobalStatsDao getDao() {
        return this.globalStatsDao;
    }

    @VisibleForTesting
    public Table<Long, NSSummary> getNsSummaryTable() {
        return this.reconNamespaceSummaryManager.getNSSummaryTable();
    }
}

