/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.DatanodeVersion;
import org.apache.hadoop.hdds.conf.ConfigurationTarget;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.MiniOzoneCluster;
import org.apache.hadoop.ozone.container.common.DatanodeLayoutStorage;
import org.apache.hadoop.ozone.container.replication.ReplicationServer;
import org.apache.ozone.test.GenericTestUtils;

public class UniformDatanodesFactory
implements MiniOzoneCluster.DatanodeFactory {
    private final AtomicInteger nodesCreated = new AtomicInteger();
    private final int numDataVolumes;
    private final String reservedSpace;
    private final Integer layoutVersion;
    private final DatanodeVersion initialVersion;
    private final DatanodeVersion currentVersion;

    protected UniformDatanodesFactory(Builder builder) {
        this.numDataVolumes = builder.numDataVolumes;
        this.layoutVersion = builder.layoutVersion;
        this.reservedSpace = builder.reservedSpace;
        this.currentVersion = builder.currentVersion;
        this.initialVersion = builder.initialVersion != null ? builder.initialVersion : builder.currentVersion;
    }

    public OzoneConfiguration apply(OzoneConfiguration conf) throws IOException {
        int i = this.nodesCreated.incrementAndGet();
        OzoneConfiguration dnConf = new OzoneConfiguration((Configuration)conf);
        this.configureDatanodePorts((ConfigurationTarget)dnConf);
        Path baseDir = Paths.get(Objects.requireNonNull(conf.get("ozone.metadata.dirs")), "datanode-" + i);
        Path metaDir = baseDir.resolve("ozone-metadata");
        Files.createDirectories(metaDir, new FileAttribute[0]);
        dnConf.set("ozone.metadata.dirs", metaDir.toString());
        ArrayList<String> dataDirs = new ArrayList<String>();
        ArrayList<String> reservedSpaceList = new ArrayList<String>();
        for (int j = 0; j < this.numDataVolumes; ++j) {
            Path dir = baseDir.resolve("data-" + j);
            Files.createDirectories(dir, new FileAttribute[0]);
            dataDirs.add(dir.toString());
            if (this.reservedSpace == null) continue;
            reservedSpaceList.add(dir + ":" + this.reservedSpace);
        }
        String reservedSpaceString = String.join((CharSequence)",", reservedSpaceList);
        String listOfDirs = String.join((CharSequence)",", dataDirs);
        dnConf.set("hdds.datanode.dir", listOfDirs);
        dnConf.set("hdds.datanode.dir.du.reserved", reservedSpaceString);
        Path ratisDir = baseDir.resolve("ratis");
        Files.createDirectories(ratisDir, new FileAttribute[0]);
        dnConf.set("hdds.container.ratis.datanode.storage.dir", ratisDir.toString());
        if (this.layoutVersion != null) {
            DatanodeLayoutStorage layoutStorage = new DatanodeLayoutStorage(dnConf, UUID.randomUUID().toString(), this.layoutVersion.intValue());
            layoutStorage.initialize();
        }
        if (this.initialVersion != null) {
            dnConf.setInt("testing.hdds.datanode.version.initial", this.initialVersion.toProtoValue());
        }
        if (this.currentVersion != null) {
            dnConf.setInt("testing.hdds.datanode.version.current", this.currentVersion.toProtoValue());
        }
        dnConf.set("hdds.raft.server.rpc.first-election.timeout", "1s");
        dnConf.set("hdds.heartbeat.initial-interval", "500ms");
        dnConf.set("hdds.heartbeat.recon.initial-interval", "500ms");
        return dnConf;
    }

    private void configureDatanodePorts(ConfigurationTarget conf) {
        conf.set("hdds.datanode.http-address", GenericTestUtils.PortAllocator.anyHostWithFreePort());
        conf.set("hdds.datanode.client.address", GenericTestUtils.PortAllocator.anyHostWithFreePort());
        conf.setInt("hdds.container.ipc.port", GenericTestUtils.PortAllocator.getFreePort());
        conf.setInt("hdds.container.ratis.ipc.port", GenericTestUtils.PortAllocator.getFreePort());
        conf.setInt("hdds.container.ratis.admin.port", GenericTestUtils.PortAllocator.getFreePort());
        conf.setInt("hdds.container.ratis.server.port", GenericTestUtils.PortAllocator.getFreePort());
        conf.setInt("hdds.container.ratis.datastream.port", GenericTestUtils.PortAllocator.getFreePort());
        conf.setFromObject((Object)new ReplicationServer.ReplicationConfig().setPort(GenericTestUtils.PortAllocator.getFreePort()));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private int numDataVolumes = 1;
        private String reservedSpace;
        private Integer layoutVersion;
        private DatanodeVersion initialVersion;
        private DatanodeVersion currentVersion;

        public Builder setNumDataVolumes(int n) {
            this.numDataVolumes = n;
            return this;
        }

        public Builder setReservedSpace(String reservedSpace) {
            this.reservedSpace = reservedSpace;
            return this;
        }

        public Builder setLayoutVersion(int layoutVersion) {
            this.layoutVersion = layoutVersion;
            return this;
        }

        public Builder setInitialVersion(DatanodeVersion version) {
            this.initialVersion = version;
            return this;
        }

        public Builder setCurrentVersion(DatanodeVersion version) {
            this.currentVersion = version;
            return this;
        }

        public UniformDatanodesFactory build() {
            return new UniformDatanodesFactory(this);
        }
    }
}

