/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.client.RatisReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.HddsTestUtils;
import org.apache.hadoop.hdds.scm.ha.SCMHANodeDetails;
import org.apache.hadoop.hdds.scm.ha.SCMNodeDetails;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServerImpl;
import org.apache.hadoop.hdds.scm.node.NodeStatus;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.proxy.SCMClientConfig;
import org.apache.hadoop.hdds.scm.proxy.SCMContainerLocationFailoverProxyProvider;
import org.apache.hadoop.hdds.scm.safemode.HealthyPipelineSafeModeRule;
import org.apache.hadoop.hdds.scm.safemode.SafeModeRuleFactory;
import org.apache.hadoop.hdds.scm.server.SCMConfigurator;
import org.apache.hadoop.hdds.scm.server.SCMStorageConfig;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.security.symmetric.SecretKeyClient;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.hdds.utils.db.CodecBuffer;
import org.apache.hadoop.hdds.utils.db.CodecTestUtil;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksObjectMetrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.ozone.HddsDatanodeService;
import org.apache.hadoop.ozone.MiniOzoneCluster;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientFactory;
import org.apache.hadoop.ozone.common.Storage;
import org.apache.hadoop.ozone.container.common.utils.ContainerCache;
import org.apache.hadoop.ozone.container.common.utils.DatanodeStoreCache;
import org.apache.hadoop.ozone.om.OMStorage;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.ozone.test.GenericTestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MiniOzoneClusterImpl
implements MiniOzoneCluster {
    private static final Logger LOG = LoggerFactory.getLogger(MiniOzoneClusterImpl.class);
    private static final String[] NO_ARGS = new String[0];
    private static final String SCM_SUBDIR_NAME = "scm";
    private static final String OM_SUBDIR_NAME = "om";
    private static final String OZONE_METADATA_SUBDIR_NAME = "ozone-metadata";
    private static final String RATIS_SUBDIR_NAME = "ratis";
    private static final String DATA_SUBDIR_NAME = "data";
    private OzoneConfiguration conf;
    private final SCMConfigurator scmConfigurator;
    private StorageContainerManager scm;
    private OzoneManager ozoneManager;
    private final List<HddsDatanodeService> hddsDatanodes;
    private final List<MiniOzoneCluster.Service> services;
    private int waitForClusterToBeReadyTimeout = 120000;
    private CertificateClient caClient;
    private final Set<AutoCloseable> clients = ConcurrentHashMap.newKeySet();
    private SecretKeyClient secretKeyClient;

    private MiniOzoneClusterImpl(OzoneConfiguration conf, SCMConfigurator scmConfigurator, OzoneManager ozoneManager, StorageContainerManager scm, List<HddsDatanodeService> hddsDatanodes, List<MiniOzoneCluster.Service> services) {
        this.conf = conf;
        this.ozoneManager = ozoneManager;
        this.scm = scm;
        this.hddsDatanodes = hddsDatanodes;
        this.scmConfigurator = scmConfigurator;
        this.services = services;
    }

    MiniOzoneClusterImpl(OzoneConfiguration conf, SCMConfigurator scmConfigurator, List<HddsDatanodeService> hddsDatanodes, List<MiniOzoneCluster.Service> services) {
        this.scmConfigurator = scmConfigurator;
        this.conf = conf;
        this.hddsDatanodes = hddsDatanodes;
        this.services = services;
    }

    public SCMConfigurator getSCMConfigurator() {
        return this.scmConfigurator;
    }

    @Override
    public OzoneConfiguration getConf() {
        return this.conf;
    }

    protected void setConf(OzoneConfiguration newConf) {
        this.conf = newConf;
    }

    public void waitForSCMToBeReady() throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor(() -> ((StorageContainerManager)this.scm).checkLeader(), (int)1000, (int)this.waitForClusterToBeReadyTimeout);
    }

    public StorageContainerManager getActiveSCM() {
        return this.scm;
    }

    @Override
    public void waitForClusterToBeReady() throws TimeoutException, InterruptedException {
        this.waitForSCMToBeReady();
        GenericTestUtils.waitFor(() -> {
            StorageContainerManager activeScm = this.getActiveSCM();
            int healthy = activeScm.getNodeCount(HddsProtos.NodeState.HEALTHY);
            boolean isNodeReady = healthy == this.hddsDatanodes.size();
            boolean exitSafeMode = !activeScm.isInSafeMode();
            boolean checkScmLeader = activeScm.checkLeader();
            LOG.info("{}. Got {} of {} DN Heartbeats.", new Object[]{isNodeReady ? "Nodes are ready" : "Waiting for nodes to be ready", healthy, this.hddsDatanodes.size()});
            LOG.info(exitSafeMode ? "Cluster exits safe mode" : "Waiting for cluster to exit safe mode");
            LOG.info(checkScmLeader ? "SCM became leader" : "SCM has not become leader");
            return isNodeReady && exitSafeMode && checkScmLeader;
        }, (int)1000, (int)this.waitForClusterToBeReadyTimeout);
    }

    @Override
    public void waitForPipelineTobeReady(HddsProtos.ReplicationFactor factor, int timeoutInMs) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor(() -> {
            int openPipelineCount = this.scm.getPipelineManager().getPipelines((ReplicationConfig)RatisReplicationConfig.getInstance((HddsProtos.ReplicationFactor)factor), Pipeline.PipelineState.OPEN).size();
            return openPipelineCount >= 1;
        }, (int)1000, (int)timeoutInMs);
    }

    @Override
    public void setWaitForClusterToBeReadyTimeout(int timeoutInMs) {
        this.waitForClusterToBeReadyTimeout = timeoutInMs;
    }

    @Override
    public void waitTobeOutOfSafeMode() throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor(() -> {
            if (!this.scm.isInSafeMode()) {
                return true;
            }
            LOG.info("Waiting for cluster to be ready. No datanodes found");
            return false;
        }, (int)100, (int)45000);
    }

    @Override
    public StorageContainerManager getStorageContainerManager() {
        return this.scm;
    }

    @Override
    public OzoneManager getOzoneManager() {
        return this.ozoneManager;
    }

    @Override
    public List<HddsDatanodeService> getHddsDatanodes() {
        return this.hddsDatanodes;
    }

    @Override
    public HddsDatanodeService getHddsDatanode(DatanodeDetails dn) throws IOException {
        for (HddsDatanodeService service : this.hddsDatanodes) {
            if (!service.getDatanodeDetails().equals((Object)dn)) continue;
            return service;
        }
        throw new IOException("Not able to find datanode with datanode Id " + dn.getUuid());
    }

    @Override
    public int getHddsDatanodeIndex(DatanodeDetails dn) throws IOException {
        for (HddsDatanodeService service : this.hddsDatanodes) {
            if (!service.getDatanodeDetails().equals((Object)dn)) continue;
            return this.hddsDatanodes.indexOf(service);
        }
        throw new IOException("Not able to find datanode with datanode Id " + dn.getUuid());
    }

    @Override
    public OzoneClient newClient() throws IOException {
        OzoneClient client = this.createClient();
        this.clients.add((AutoCloseable)client);
        return client;
    }

    protected OzoneClient createClient() throws IOException {
        return OzoneClientFactory.getRpcClient((ConfigurationSource)this.conf);
    }

    @Override
    public StorageContainerLocationProtocolClientSideTranslatorPB getStorageContainerLocationClient() throws IOException {
        SCMContainerLocationFailoverProxyProvider proxyProvider = new SCMContainerLocationFailoverProxyProvider((ConfigurationSource)this.conf, null);
        return new StorageContainerLocationProtocolClientSideTranslatorPB(proxyProvider);
    }

    @Override
    public void restartStorageContainerManager(boolean waitForDatanode) throws TimeoutException, InterruptedException, IOException, AuthenticationException {
        LOG.info("Restarting SCM in cluster " + this.getClass());
        this.scm.stop();
        this.scm.join();
        this.scm = HddsTestUtils.getScmSimple((OzoneConfiguration)this.conf, (SCMConfigurator)this.scmConfigurator);
        this.scm.start();
        if (waitForDatanode) {
            this.waitForClusterToBeReady();
        }
    }

    @Override
    public void restartOzoneManager() throws IOException {
        MiniOzoneClusterImpl.stopOM(this.ozoneManager);
        this.ozoneManager.restart();
    }

    private void waitForHddsDatanodeToStop(DatanodeDetails dn) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor(() -> {
            NodeStatus status;
            try {
                status = this.getStorageContainerManager().getScmNodeManager().getNodeStatus(dn);
            }
            catch (NodeNotFoundException e) {
                return true;
            }
            if (status.equals((Object)NodeStatus.inServiceHealthy())) {
                LOG.info("Waiting on datanode to be marked stale.");
                return false;
            }
            return true;
        }, (int)1000, (int)this.waitForClusterToBeReadyTimeout);
    }

    @Override
    public void restartHddsDatanode(int i, boolean waitForDatanode) throws InterruptedException, TimeoutException {
        HddsDatanodeService datanodeService = this.hddsDatanodes.remove(i);
        MiniOzoneClusterImpl.stopDatanode(datanodeService);
        OzoneConfiguration config = datanodeService.getConf();
        if (waitForDatanode) {
            this.waitForHddsDatanodeToStop(datanodeService.getDatanodeDetails());
        }
        HddsDatanodeService service = new HddsDatanodeService(NO_ARGS);
        service.setConfiguration(config);
        this.hddsDatanodes.add(i, service);
        this.startHddsDatanode(service);
        if (waitForDatanode) {
            this.waitForClusterToBeReady();
        }
    }

    @Override
    public void restartHddsDatanode(DatanodeDetails dn, boolean waitForDatanode) throws InterruptedException, TimeoutException, IOException {
        this.restartHddsDatanode(this.getHddsDatanodeIndex(dn), waitForDatanode);
    }

    @Override
    public void shutdownHddsDatanode(int i) {
        MiniOzoneClusterImpl.stopDatanode(this.hddsDatanodes.get(i));
    }

    @Override
    public void shutdownHddsDatanode(DatanodeDetails dn) throws IOException {
        this.shutdownHddsDatanode(this.getHddsDatanodeIndex(dn));
    }

    @Override
    public String getClusterId() {
        return this.scm.getClientProtocolServer().getScmInfo().getClusterId();
    }

    @Override
    public void shutdown() {
        try {
            LOG.info("Shutting down the Mini Ozone Cluster");
            CodecTestUtil.gc();
            IOUtils.closeQuietly(this.clients);
            File baseDir = new File(this.getBaseDir());
            this.stop();
            FileUtils.deleteDirectory((File)baseDir);
            ContainerCache.getInstance((ConfigurationSource)this.conf).shutdownCache();
            DefaultMetricsSystem.shutdown();
            ManagedRocksObjectMetrics.INSTANCE.assertNoLeaks();
        }
        catch (Exception e) {
            LOG.error("Exception while shutting down the cluster.", (Throwable)e);
        }
    }

    @Override
    public void stop() {
        LOG.info("Stopping the Mini Ozone Cluster");
        MiniOzoneClusterImpl.stopOM(this.ozoneManager);
        MiniOzoneClusterImpl.stopDatanodes(this.hddsDatanodes);
        MiniOzoneClusterImpl.stopSCM(this.scm);
        MiniOzoneClusterImpl.stopServices(this.services);
    }

    private void startHddsDatanode(HddsDatanodeService datanode) {
        try {
            datanode.setCertificateClient(this.getCAClient());
        }
        catch (IOException e) {
            LOG.error("Exception while setting certificate client to DataNode.", (Throwable)e);
        }
        datanode.setSecretKeyClient(this.secretKeyClient);
        datanode.start();
    }

    @Override
    public void startHddsDatanodes() {
        this.hddsDatanodes.forEach(this::startHddsDatanode);
    }

    @Override
    public void shutdownHddsDatanodes() {
        this.hddsDatanodes.forEach(datanode -> {
            try {
                this.shutdownHddsDatanode(datanode.getDatanodeDetails());
            }
            catch (IOException e) {
                LOG.error("Exception while trying to shutdown datanodes:", (Throwable)e);
            }
        });
    }

    public void startServices() throws Exception {
        for (MiniOzoneCluster.Service service : this.services) {
            service.start(this.getConf());
        }
    }

    private CertificateClient getCAClient() {
        return this.caClient;
    }

    private void setCAClient(CertificateClient client) {
        this.caClient = client;
    }

    private void setSecretKeyClient(SecretKeyClient client) {
        this.secretKeyClient = client;
    }

    private static void stopDatanodes(Collection<HddsDatanodeService> hddsDatanodes) {
        if (!hddsDatanodes.isEmpty()) {
            LOG.info("Stopping the HddsDatanodes");
            hddsDatanodes.parallelStream().forEach(MiniOzoneClusterImpl::stopDatanode);
        }
    }

    private static void stopDatanode(HddsDatanodeService dn) {
        if (dn != null) {
            dn.stop();
            dn.join();
        }
    }

    private static void stopSCM(StorageContainerManager scm) {
        if (scm != null) {
            LOG.info("Stopping the StorageContainerManager");
            scm.stop();
            scm.join();
        }
    }

    protected static void stopOM(OzoneManager om) {
        if (om != null && om.stop()) {
            om.join();
        }
    }

    private static void stopServices(List<MiniOzoneCluster.Service> services) {
        ArrayList<MiniOzoneCluster.Service> reverse = new ArrayList<MiniOzoneCluster.Service>(services);
        Collections.reverse(reverse);
        for (MiniOzoneCluster.Service service : reverse) {
            try {
                service.stop();
                LOG.info("Stopped {}", (Object)service);
            }
            catch (Exception e) {
                LOG.error("Error stopping {}", (Object)service, (Object)e);
            }
        }
    }

    static {
        CodecBuffer.enableLeakDetection();
    }

    public static class Builder
    extends MiniOzoneCluster.Builder {
        public Builder(OzoneConfiguration conf) {
            super(conf);
        }

        @Override
        public MiniOzoneCluster build() throws IOException {
            DefaultMetricsSystem.setMiniClusterMode((boolean)true);
            DatanodeStoreCache.setMiniClusterMode();
            this.initializeConfiguration();
            StorageContainerManager scm = null;
            OzoneManager om = null;
            List<Object> hddsDatanodes = Collections.emptyList();
            try {
                scm = this.createAndStartSingleSCM();
                om = this.createAndStartSingleOM();
                hddsDatanodes = this.createHddsDatanodes();
                MiniOzoneClusterImpl cluster = new MiniOzoneClusterImpl(this.conf, this.scmConfigurator, om, scm, hddsDatanodes, this.getServices());
                cluster.startServices();
                cluster.setCAClient(this.certClient);
                cluster.setSecretKeyClient(this.secretKeyClient);
                if (this.startDataNodes) {
                    cluster.startHddsDatanodes();
                }
                this.prepareForNextBuild();
                return cluster;
            }
            catch (Exception ex) {
                MiniOzoneClusterImpl.stopOM(om);
                MiniOzoneClusterImpl.stopServices(this.getServices());
                if (this.startDataNodes) {
                    MiniOzoneClusterImpl.stopDatanodes(hddsDatanodes);
                }
                MiniOzoneClusterImpl.stopSCM(scm);
                this.removeConfiguration();
                LOG.warn("Unable to build MiniOzoneCluster", (Throwable)ex);
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new IOException("Unable to build MiniOzoneCluster. ", ex);
            }
        }

        protected void setClients(OzoneManager om) throws IOException {
            if (this.certClient != null) {
                om.setCertClient(this.certClient);
            }
            if (this.secretKeyClient != null) {
                om.setSecretKeyClient(this.secretKeyClient);
            }
        }

        protected void initializeConfiguration() throws IOException {
            Path metaDir = Paths.get(this.path, MiniOzoneClusterImpl.OZONE_METADATA_SUBDIR_NAME);
            Files.createDirectories(metaDir, new FileAttribute[0]);
            this.conf.set("ozone.metadata.dirs", metaDir.toString());
            this.conf.setTimeDuration("ozone.om.ratis.minimum.timeout", 1L, TimeUnit.SECONDS);
            SCMClientConfig scmClientConfig = (SCMClientConfig)this.conf.getObject(SCMClientConfig.class);
            scmClientConfig.setMaxRetryTimeout(30000L);
            this.conf.setFromObject((Object)scmClientConfig);
            this.conf.setInt("hdds.scm.safemode.min.datanode", this.numOfDatanodes >= 3 ? 3 : 1);
        }

        void removeConfiguration() {
            FileUtils.deleteQuietly((File)new File(this.path));
        }

        protected StorageContainerManager createAndStartSingleSCM() throws AuthenticationException, IOException {
            StorageContainerManager scm = this.createSCM();
            scm.start();
            this.configureScmDatanodeAddress(Collections.singletonList(scm));
            return scm;
        }

        protected StorageContainerManager createSCM() throws IOException, AuthenticationException {
            this.configureSCM(false);
            SCMStorageConfig scmStore = new SCMStorageConfig(this.conf);
            this.initializeScmStorage(scmStore);
            StorageContainerManager scm = HddsTestUtils.getScmSimple((OzoneConfiguration)this.conf, (SCMConfigurator)this.scmConfigurator);
            HealthyPipelineSafeModeRule rule = (HealthyPipelineSafeModeRule)SafeModeRuleFactory.getInstance().getSafeModeRule(HealthyPipelineSafeModeRule.class);
            if (rule != null) {
                rule.setHealthyPipelineThresholdCount(this.numOfDatanodes / 3);
            }
            return scm;
        }

        protected void initializeScmStorage(SCMStorageConfig scmStore) throws IOException {
            if (scmStore.getState() == Storage.StorageState.INITIALIZED) {
                return;
            }
            scmStore.setClusterId(this.clusterId);
            scmStore.setScmId(this.scmId);
            scmStore.initialize();
            scmStore.setSCMHAFlag(true);
            scmStore.persistCurrentState();
            SCMRatisServerImpl.initialize((String)this.clusterId, (String)this.scmId, (SCMNodeDetails)SCMHANodeDetails.loadSCMHAConfig((OzoneConfiguration)this.conf, (SCMStorageConfig)scmStore).getLocalNodeDetails(), (OzoneConfiguration)this.conf);
        }

        void initializeOmStorage(OMStorage omStorage) throws IOException {
            if (omStorage.getState() == Storage.StorageState.INITIALIZED) {
                return;
            }
            omStorage.setClusterId(this.clusterId);
            omStorage.setOmId(this.omId);
            if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)this.conf)) {
                OzoneManager.initializeSecurity((OzoneConfiguration)this.conf, (OMStorage)omStorage, (String)this.scmId);
            }
            omStorage.initialize();
        }

        protected OzoneManager createAndStartSingleOM() throws AuthenticationException, IOException {
            OzoneManager om = this.createOM();
            this.setClients(om);
            om.start();
            return om;
        }

        protected OzoneManager createOM() throws IOException, AuthenticationException {
            this.configureOM(false);
            OMStorage omStore = new OMStorage(this.conf);
            this.initializeOmStorage(omStore);
            return OzoneManager.createOm((OzoneConfiguration)this.conf);
        }

        private String getSCMAddresses(List<StorageContainerManager> scms) {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<StorageContainerManager> iter = scms.iterator();
            while (iter.hasNext()) {
                StorageContainerManager scm = iter.next();
                stringBuilder.append(scm.getDatanodeRpcAddress().getHostString()).append(':').append(scm.getDatanodeRpcAddress().getPort());
                if (!iter.hasNext()) continue;
                stringBuilder.append(',');
            }
            return stringBuilder.toString();
        }

        protected void configureScmDatanodeAddress(List<StorageContainerManager> scms) {
            this.conf.setStrings("ozone.scm.names", new String[]{this.getSCMAddresses(scms)});
        }

        protected List<HddsDatanodeService> createHddsDatanodes() throws IOException {
            ArrayList<HddsDatanodeService> hddsDatanodes = new ArrayList<HddsDatanodeService>();
            for (int i = 0; i < this.numOfDatanodes; ++i) {
                OzoneConfiguration dnConf = (OzoneConfiguration)this.dnFactory.apply(this.conf);
                HddsDatanodeService datanode = new HddsDatanodeService(NO_ARGS);
                datanode.setConfiguration(dnConf);
                hddsDatanodes.add(datanode);
            }
            return hddsDatanodes;
        }

        protected void configureSCM(boolean isHA) throws IOException {
            this.conf.set("ozone.scm.client.address", GenericTestUtils.PortAllocator.localhostWithFreePort());
            this.conf.set("ozone.scm.block.client.address", GenericTestUtils.PortAllocator.localhostWithFreePort());
            this.conf.set("ozone.scm.datanode.address", GenericTestUtils.PortAllocator.localhostWithFreePort());
            this.conf.set("ozone.scm.http-address", GenericTestUtils.PortAllocator.localhostWithFreePort());
            this.conf.set("hdds.scm.wait.time.after.safemode.exit", "3s");
            this.conf.setInt("ozone.scm.ratis.port", GenericTestUtils.PortAllocator.getFreePort());
            this.conf.setInt("ozone.scm.grpc.port", GenericTestUtils.PortAllocator.getFreePort());
            this.conf.setIfUnset("ozone.scm.ha.raft.server.rpc.first-election.timeout", "1s");
            Path scmMetaDir = Paths.get(this.path, MiniOzoneClusterImpl.SCM_SUBDIR_NAME);
            Files.createDirectories(scmMetaDir.resolve(MiniOzoneClusterImpl.DATA_SUBDIR_NAME), new FileAttribute[0]);
            if (!isHA) {
                this.conf.setIfUnset("ozone.scm.ha.ratis.storage.dir", scmMetaDir.resolve(MiniOzoneClusterImpl.RATIS_SUBDIR_NAME).toString());
                this.conf.setIfUnset("ozone.scm.ha.ratis.snapshot.dir", scmMetaDir.resolve(MiniOzoneClusterImpl.OZONE_METADATA_SUBDIR_NAME).resolve("snapshot").toString());
                this.conf.setIfUnset("ozone.scm.db.dirs", scmMetaDir.resolve(MiniOzoneClusterImpl.DATA_SUBDIR_NAME).toString());
                this.conf.setIfUnset("ozone.http.basedir", scmMetaDir.resolve(MiniOzoneClusterImpl.OZONE_METADATA_SUBDIR_NAME) + "/webserver");
            }
        }

        private void configureOM(boolean isHA) throws IOException {
            this.conf.set("ozone.om.address", GenericTestUtils.PortAllocator.localhostWithFreePort());
            this.conf.set("ozone.om.http-address", GenericTestUtils.PortAllocator.localhostWithFreePort());
            this.conf.set("ozone.om.https-address", GenericTestUtils.PortAllocator.localhostWithFreePort());
            this.conf.setInt("ozone.om.ratis.port", GenericTestUtils.PortAllocator.getFreePort());
            Path omMetaDir = Paths.get(this.path, MiniOzoneClusterImpl.OM_SUBDIR_NAME);
            Files.createDirectories(omMetaDir.resolve(MiniOzoneClusterImpl.DATA_SUBDIR_NAME), new FileAttribute[0]);
            if (!isHA) {
                this.conf.setIfUnset("ozone.om.ratis.storage.dir", omMetaDir.resolve(MiniOzoneClusterImpl.RATIS_SUBDIR_NAME).toString());
                this.conf.setIfUnset("ozone.om.ratis.snapshot.dir", omMetaDir.resolve(MiniOzoneClusterImpl.OZONE_METADATA_SUBDIR_NAME).resolve("snapshot").toString());
                this.conf.setIfUnset("ozone.om.db.dirs", omMetaDir.resolve(MiniOzoneClusterImpl.DATA_SUBDIR_NAME).toString());
                this.conf.setIfUnset("ozone.om.snapshot.diff.db.dir", omMetaDir.resolve(MiniOzoneClusterImpl.OZONE_METADATA_SUBDIR_NAME).toString());
                this.conf.setIfUnset("ozone.http.basedir", omMetaDir.resolve(MiniOzoneClusterImpl.OZONE_METADATA_SUBDIR_NAME) + "/webserver");
            }
        }
    }
}

