/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.upgrade;

import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.upgrade.OMFinalizeUpgradeResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalization;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMFinalizeUpgradeRequest
extends OMClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMFinalizeUpgradeRequest.class);

    public OMFinalizeUpgradeRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        LOG.trace("Request: {}", (Object)this.getOmRequest());
        AuditLogger auditLogger = ozoneManager.getAuditLogger();
        OzoneManagerProtocolProtos.UserInfo userInfo = this.getOmRequest().getUserInfo();
        OzoneManagerProtocolProtos.OMResponse.Builder responseBuilder = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        responseBuilder.setCmdType(OzoneManagerProtocolProtos.Type.FinalizeUpgrade);
        OMFinalizeUpgradeResponse response = null;
        IOException exception = null;
        try {
            UserGroupInformation ugi;
            if (ozoneManager.getAclsEnabled() && !ozoneManager.isAdmin(ugi = this.createUGIForApi())) {
                throw new OMException("Access denied for user " + ugi + ". " + "Superuser privilege is required to finalize upgrade.", OMException.ResultCodes.ACCESS_DENIED);
            }
            OzoneManagerProtocolProtos.FinalizeUpgradeRequest request = this.getOmRequest().getFinalizeUpgradeRequest();
            String upgradeClientID = request.getUpgradeClientId();
            UpgradeFinalization.StatusAndMessages omStatus = ozoneManager.finalizeUpgrade(upgradeClientID);
            HddsProtos.UpgradeFinalizationStatus.Status protoStatus = HddsProtos.UpgradeFinalizationStatus.Status.valueOf((String)omStatus.status().name());
            HddsProtos.UpgradeFinalizationStatus responseStatus = HddsProtos.UpgradeFinalizationStatus.newBuilder().setStatus(protoStatus).build();
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            int lV = ozoneManager.getVersionManager().getMetadataLayoutVersion();
            omMetadataManager.getMetaTable().addCacheEntry(new CacheKey((Object)"#LAYOUTVERSION"), CacheValue.get((long)context.getIndex(), (Object)String.valueOf(lV)));
            OzoneManagerProtocolProtos.FinalizeUpgradeResponse omResponse = OzoneManagerProtocolProtos.FinalizeUpgradeResponse.newBuilder().setStatus(responseStatus).build();
            responseBuilder.setFinalizeUpgradeResponse(omResponse);
            response = new OMFinalizeUpgradeResponse(responseBuilder.build(), ozoneManager.getVersionManager().getMetadataLayoutVersion());
            LOG.trace("Returning response: {}", (Object)response);
        }
        catch (IOException e) {
            exception = e;
            response = new OMFinalizeUpgradeResponse(this.createErrorOMResponse(responseBuilder, e), -1);
        }
        this.markForAudit(auditLogger, this.buildAuditMessage(OMAction.UPGRADE_FINALIZE, new HashMap<String, String>(), exception, userInfo));
        return response;
    }
}

