/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.tenant;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OMMultiTenantManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.OmDBAccessIdInfo;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.tenant.OMTenantRevokeAdminResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.DisallowedUntilLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeature;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMTenantRevokeAdminRequest
extends OMClientRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMTenantRevokeAdminRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMTenantRevokeAdminRequest.class);
    }

    public OMTenantRevokeAdminRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    @DisallowedUntilLayoutVersion(value=OMLayoutFeature.MULTITENANCY_SCHEMA)
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2);
        OMLayoutFeatureAspect.aspectOf().checkLayoutFeature(joinPoint);
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(joinPoint);
        }
        OzoneManagerProtocolProtos.OMRequest omRequest = super.preExecute(ozoneManager);
        OzoneManagerProtocolProtos.TenantRevokeAdminRequest request = omRequest.getTenantRevokeAdminRequest();
        String accessId = request.getAccessId();
        String tenantId = request.getTenantId();
        OMMultiTenantManager multiTenantManager = ozoneManager.getMultiTenantManager();
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            Optional<String> optionalTenantId = multiTenantManager.getTenantForAccessID(accessId);
            if (!optionalTenantId.isPresent()) {
                throw new OMException("accessId '" + accessId + "' is not assigned to " + "any tenant", OMException.ResultCodes.TENANT_NOT_FOUND);
            }
            tenantId = optionalTenantId.get();
            assert (!StringUtils.isEmpty((CharSequence)tenantId));
        }
        multiTenantManager.checkTenantExistence(tenantId);
        multiTenantManager.checkTenantAdmin(tenantId, true);
        OmDBAccessIdInfo accessIdInfo = (OmDBAccessIdInfo)ozoneManager.getMetadataManager().getTenantAccessIdTable().get((Object)accessId);
        if (accessIdInfo == null) {
            throw new OMException("accessId '" + accessId + "' not found.", OMException.ResultCodes.ACCESS_ID_NOT_FOUND);
        }
        if (!accessIdInfo.getTenantId().equals(tenantId)) {
            throw new OMException("accessId '" + accessId + "' must be assigned to tenant '" + tenantId + "' first.", OMException.ResultCodes.INVALID_TENANT_ID);
        }
        multiTenantManager.getAuthorizerLock().tryWriteLockInOMRequest();
        try {
            multiTenantManager.getAuthorizerOp().revokeTenantAdmin(accessId);
        }
        catch (Exception e) {
            multiTenantManager.getAuthorizerLock().unlockWriteInOMRequest();
            throw e;
        }
        OzoneManagerProtocolProtos.OMRequest.Builder omRequestBuilder = omRequest.toBuilder().setTenantRevokeAdminRequest(OzoneManagerProtocolProtos.TenantRevokeAdminRequest.newBuilder().setTenantId(tenantId).setAccessId(request.getAccessId()).build());
        return omRequestBuilder.build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        Exception exception;
        String tenantId;
        String accessId;
        HashMap<String, String> auditMap;
        OMTenantRevokeAdminResponse omClientResponse;
        OMMetrics omMetrics;
        block15: {
            OMMultiTenantManager multiTenantManager = ozoneManager.getMultiTenantManager();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumTenantRevokeAdmins();
            omClientResponse = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            auditMap = new HashMap<String, String>();
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            OzoneManagerProtocolProtos.TenantRevokeAdminRequest request = this.getOmRequest().getTenantRevokeAdminRequest();
            accessId = request.getAccessId();
            tenantId = request.getTenantId();
            boolean acquiredVolumeLock = false;
            exception = null;
            String volumeName = null;
            try {
                try {
                    volumeName = ozoneManager.getMultiTenantManager().getTenantVolumeName(tenantId);
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.VOLUME_LOCK, new String[]{volumeName}));
                    acquiredVolumeLock = this.getOmLockDetails().isLockAcquired();
                    OmDBAccessIdInfo dbAccessIdInfo = (OmDBAccessIdInfo)omMetadataManager.getTenantAccessIdTable().get((Object)accessId);
                    if (dbAccessIdInfo == null) {
                        throw new OMException("OmDBAccessIdInfo entry is missing for accessId '" + accessId + "'", OMException.ResultCodes.METADATA_ERROR);
                    }
                    assert (dbAccessIdInfo.getTenantId().equals(tenantId));
                    OmDBAccessIdInfo newOmDBAccessIdInfo = new OmDBAccessIdInfo.Builder().setTenantId(dbAccessIdInfo.getTenantId()).setUserPrincipal(dbAccessIdInfo.getUserPrincipal()).setIsAdmin(false).setIsDelegatedAdmin(false).build();
                    omMetadataManager.getTenantAccessIdTable().addCacheEntry(new CacheKey((Object)accessId), CacheValue.get((long)context.getIndex(), (Object)newOmDBAccessIdInfo));
                    multiTenantManager.getCacheOp().revokeTenantAdmin(accessId);
                    omResponse.setTenantRevokeAdminResponse(OzoneManagerProtocolProtos.TenantRevokeAdminResponse.newBuilder().build());
                    omClientResponse = new OMTenantRevokeAdminResponse(omResponse.build(), accessId, newOmDBAccessIdInfo);
                }
                catch (IOException | InvalidPathException ex) {
                    exception = ex;
                    omClientResponse = new OMTenantRevokeAdminResponse(this.createErrorOMResponse(omResponse, exception));
                    if (acquiredVolumeLock) {
                        Preconditions.checkNotNull((Object)volumeName);
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.VOLUME_LOCK, new String[]{volumeName}));
                    }
                    multiTenantManager.getAuthorizerLock().unlockWriteInOMRequest();
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (acquiredVolumeLock) {
                    Preconditions.checkNotNull((Object)volumeName);
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.VOLUME_LOCK, new String[]{volumeName}));
                }
                multiTenantManager.getAuthorizerLock().unlockWriteInOMRequest();
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquiredVolumeLock) {
                Preconditions.checkNotNull((Object)volumeName);
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.VOLUME_LOCK, new String[]{volumeName}));
            }
            multiTenantManager.getAuthorizerLock().unlockWriteInOMRequest();
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        auditMap.put("tenant", tenantId);
        this.markForAudit(ozoneManager.getAuditLogger(), this.buildAuditMessage(OMAction.TENANT_REVOKE_ADMIN, auditMap, exception, this.getOmRequest().getUserInfo()));
        if (exception == null) {
            LOG.info("Revoked admin of accessId '{}' from tenant '{}'", (Object)accessId, (Object)tenantId);
        } else {
            LOG.error("Failed to revoke admin of accessId '{}' from tenant '{}': {}", new Object[]{accessId, tenantId, exception.getMessage()});
            omMetrics.incNumTenantRevokeAdminFails();
        }
        return omClientResponse;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMTenantRevokeAdminRequest.java", OMTenantRevokeAdminRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.s3.tenant.OMTenantRevokeAdminRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 71);
    }
}

