/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.TransactionInfo;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.AuditLoggerType;
import org.apache.hadoop.ozone.audit.OMSystemAction;
import org.apache.hadoop.ozone.om.DeletingServiceMetrics;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyPurgeResponse;
import org.apache.hadoop.ozone.om.snapshot.SnapshotUtils;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.ratis.server.protocol.TermIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeyPurgeRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMKeyPurgeRequest.class);
    private static final AuditLogger AUDIT = new AuditLogger(AuditLoggerType.OMSYSTEMLOGGER);
    private static final String AUDIT_PARAM_KEYS_DELETED = "keysDeleted";
    private static final String AUDIT_PARAM_RENAMED_KEYS_PURGED = "renamedKeysPurged";
    private static final String AUDIT_PARAMS_DELETED_KEYS_LIST = "deletedKeysList";
    private static final String AUDIT_PARAMS_RENAMED_KEYS_LIST = "renamedKeysList";
    private static final String AUDIT_PARAM_SNAPSHOT_ID = "snapshotId";

    public OMKeyPurgeRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        SnapshotInfo fromSnapshotInfo;
        OzoneManagerProtocolProtos.PurgeKeysRequest purgeKeysRequest = this.getOmRequest().getPurgeKeysRequest();
        List bucketDeletedKeysList = purgeKeysRequest.getDeletedKeysList();
        List keysToUpdateList = purgeKeysRequest.getKeysToUpdateList();
        String fromSnapshot = purgeKeysRequest.hasSnapshotTableKey() ? purgeKeysRequest.getSnapshotTableKey() : null;
        OmMetadataManagerImpl omMetadataManager = (OmMetadataManagerImpl)ozoneManager.getMetadataManager();
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        try {
            SnapshotInfo snapshotInfo = fromSnapshotInfo = fromSnapshot != null ? SnapshotUtils.getSnapshotInfo(ozoneManager, fromSnapshot) : null;
            if (purgeKeysRequest.hasExpectedPreviousSnapshotID()) {
                UUID expectedPreviousSnapshotId = purgeKeysRequest.getExpectedPreviousSnapshotID().hasUuid() ? HddsUtils.fromProtobuf((HddsProtos.UUID)purgeKeysRequest.getExpectedPreviousSnapshotID().getUuid()) : null;
                SnapshotUtils.validatePreviousSnapshotId(fromSnapshotInfo, omMetadataManager.getSnapshotChainManager(), expectedPreviousSnapshotId);
            }
        }
        catch (IOException e) {
            LOG.error("Error occurred while performing OmKeyPurge. ", (Throwable)e);
            if (LOG.isDebugEnabled()) {
                AUDIT.logWriteFailure(ozoneManager.buildAuditMessageForFailure(OMSystemAction.KEY_DELETION, null, e));
            }
            return new OMKeyPurgeResponse(this.createErrorOMResponse(omResponse, e));
        }
        ArrayList<String> keysToBePurgedList = new ArrayList<String>();
        int numKeysDeleted = 0;
        ArrayList<String> renamedKeysToBePurged = new ArrayList<String>(purgeKeysRequest.getRenamedKeysList());
        for (OzoneManagerProtocolProtos.DeletedKeys bucketWithDeleteKeys : bucketDeletedKeysList) {
            List keysList = bucketWithDeleteKeys.getKeysList();
            keysToBePurgedList.addAll(keysList);
            numKeysDeleted += keysList.size();
        }
        DeletingServiceMetrics deletingServiceMetrics = ozoneManager.getDeletionMetrics();
        deletingServiceMetrics.incrNumKeysPurged(numKeysDeleted);
        deletingServiceMetrics.incrNumRenameEntriesPurged(renamedKeysToBePurged.size());
        if (keysToBePurgedList.isEmpty() && renamedKeysToBePurged.isEmpty()) {
            OMException oe = new OMException("No keys found to be purged or renamed in the request.", OMException.ResultCodes.KEY_DELETION_ERROR);
            AUDIT.logWriteFailure(ozoneManager.buildAuditMessageForFailure(OMSystemAction.KEY_DELETION, null, oe));
            return new OMKeyPurgeResponse(this.createErrorOMResponse(omResponse, (Exception)((Object)oe)));
        }
        try {
            TransactionInfo transactionInfo = TransactionInfo.valueOf((TermIndex)context.getTermIndex());
            if (fromSnapshotInfo != null) {
                fromSnapshotInfo.setLastTransactionInfo(transactionInfo.toByteString());
                omMetadataManager.getSnapshotInfoTable().addCacheEntry(new CacheKey((Object)fromSnapshotInfo.getTableKey()), CacheValue.get((long)context.getIndex(), (Object)fromSnapshotInfo));
            } else {
                deletingServiceMetrics.setLastAOSTransactionInfo(transactionInfo);
            }
            List<OmBucketInfo> bucketInfoList = this.updateBucketSize(purgeKeysRequest.getBucketPurgeKeysSizeList(), omMetadataManager);
            if (LOG.isDebugEnabled()) {
                LinkedHashMap<String, String> auditParams = new LinkedHashMap<String, String>();
                if (fromSnapshotInfo != null) {
                    auditParams.put(AUDIT_PARAM_SNAPSHOT_ID, fromSnapshotInfo.getSnapshotId().toString());
                }
                auditParams.put(AUDIT_PARAM_KEYS_DELETED, String.valueOf(numKeysDeleted));
                auditParams.put(AUDIT_PARAM_RENAMED_KEYS_PURGED, String.valueOf(renamedKeysToBePurged.size()));
                if (!keysToBePurgedList.isEmpty()) {
                    auditParams.put(AUDIT_PARAMS_DELETED_KEYS_LIST, String.join((CharSequence)",", keysToBePurgedList));
                }
                if (!renamedKeysToBePurged.isEmpty()) {
                    auditParams.put(AUDIT_PARAMS_RENAMED_KEYS_LIST, String.join((CharSequence)",", renamedKeysToBePurged));
                }
                AUDIT.logWriteSuccess(ozoneManager.buildAuditMessageForSuccess(OMSystemAction.KEY_DELETION, auditParams));
            }
            return new OMKeyPurgeResponse(omResponse.build(), keysToBePurgedList, renamedKeysToBePurged, fromSnapshotInfo, keysToUpdateList, bucketInfoList);
        }
        catch (IOException e) {
            AUDIT.logWriteFailure(ozoneManager.buildAuditMessageForFailure(OMSystemAction.KEY_DELETION, null, e));
            return new OMKeyPurgeResponse(this.createErrorOMResponse(omResponse, e));
        }
    }

    private List<OmBucketInfo> updateBucketSize(List<OzoneManagerProtocolProtos.BucketPurgeKeysSize> bucketPurgeKeysSizeList, OMMetadataManager omMetadataManager) throws OMException {
        HashMap<String, Map> bucketPurgeKeysSizes = new HashMap<String, Map>();
        ArrayList bucketKeyList = new ArrayList();
        for (OzoneManagerProtocolProtos.BucketPurgeKeysSize bucketPurgeKey : bucketPurgeKeysSizeList) {
            String volumeName = bucketPurgeKey.getBucketNameInfo().getVolumeName();
            String bucketName = bucketPurgeKey.getBucketNameInfo().getBucketName();
            bucketPurgeKeysSizes.computeIfAbsent(volumeName, k -> new HashMap()).computeIfAbsent(bucketName, k -> {
                bucketKeyList.add(new String[]{volumeName, bucketName});
                return new ArrayList();
            }).add(bucketPurgeKey);
        }
        this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLocks((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, bucketKeyList));
        boolean acquiredLock = this.getOmLockDetails().isLockAcquired();
        if (!acquiredLock) {
            throw new OMException("Failed to acquire bucket lock for purging keys.", OMException.ResultCodes.KEY_DELETION_ERROR);
        }
        ArrayList<OmBucketInfo> bucketInfoList = new ArrayList<OmBucketInfo>();
        try {
            for (Map.Entry volEntry : bucketPurgeKeysSizes.entrySet()) {
                String volumeName = (String)volEntry.getKey();
                for (Map.Entry bucketEntry : ((Map)volEntry.getValue()).entrySet()) {
                    String bucketName = (String)bucketEntry.getKey();
                    OmBucketInfo omBucketInfo = OMKeyPurgeRequest.getBucketInfo(omMetadataManager, volumeName, bucketName);
                    if (omBucketInfo == null) continue;
                    boolean bucketUpdated = false;
                    for (OzoneManagerProtocolProtos.BucketPurgeKeysSize bucketPurgeKeysSize : (List)bucketEntry.getValue()) {
                        OzoneManagerProtocolProtos.BucketNameInfo bucketNameInfo = bucketPurgeKeysSize.getBucketNameInfo();
                        if (bucketNameInfo.getBucketId() != omBucketInfo.getObjectID()) continue;
                        omBucketInfo.purgeSnapshotUsedBytes(bucketPurgeKeysSize.getPurgedBytes());
                        omBucketInfo.purgeSnapshotUsedNamespace(bucketPurgeKeysSize.getPurgedNamespace());
                        bucketUpdated = true;
                    }
                    if (!bucketUpdated) continue;
                    bucketInfoList.add(omBucketInfo.copyObject());
                }
            }
            ArrayList<OmBucketInfo> arrayList = bucketInfoList;
            return arrayList;
        }
        finally {
            this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLocks((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, bucketKeyList));
        }
    }
}

