/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.service;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskQueue;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OmSnapshot;
import org.apache.hadoop.ozone.om.OmSnapshotManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.service.AbstractKeyDeletingService;
import org.apache.hadoop.ozone.om.snapshot.ReferenceCounted;
import org.apache.hadoop.ozone.om.snapshot.SnapshotUtils;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryDeletingService
extends AbstractKeyDeletingService {
    public static final Logger LOG = LoggerFactory.getLogger(DirectoryDeletingService.class);
    private final int dirDeletingCorePoolSize;
    private int ratisByteLimit;
    private final AtomicBoolean suspended;
    private AtomicBoolean isRunningOnAOS;
    private final DeletedDirSupplier deletedDirSupplier;
    private AtomicInteger taskCount = new AtomicInteger(0);

    public DirectoryDeletingService(long interval, TimeUnit unit, long serviceTimeout, OzoneManager ozoneManager, OzoneConfiguration configuration, int dirDeletingServiceCorePoolSize) {
        super(DirectoryDeletingService.class.getSimpleName(), interval, unit, dirDeletingServiceCorePoolSize, serviceTimeout, ozoneManager, null);
        int limit = (int)configuration.getStorageSize("ozone.om.ratis.log.appender.queue.byte-limit", "32MB", StorageUnit.BYTES);
        this.ratisByteLimit = (int)((double)limit * 0.9);
        this.suspended = new AtomicBoolean(false);
        this.isRunningOnAOS = new AtomicBoolean(false);
        this.dirDeletingCorePoolSize = dirDeletingServiceCorePoolSize;
        this.deletedDirSupplier = new DeletedDirSupplier();
        this.taskCount.set(0);
    }

    private boolean shouldRun() {
        if (this.getOzoneManager() == null) {
            return true;
        }
        return this.getOzoneManager().isLeaderReady() && !this.suspended.get();
    }

    public boolean isRunningOnAOS() {
        return this.isRunningOnAOS.get();
    }

    public AtomicInteger getTaskCount() {
        return this.taskCount;
    }

    @VisibleForTesting
    public void suspend() {
        this.suspended.set(true);
    }

    @VisibleForTesting
    public void resume() {
        this.suspended.set(false);
    }

    public void setRatisByteLimit(int ratisByteLimit) {
        this.ratisByteLimit = ratisByteLimit;
    }

    public BackgroundTaskQueue getTasks() {
        BackgroundTaskQueue queue = new BackgroundTaskQueue();
        if (this.taskCount.get() > 0) {
            LOG.info("{} Directory deleting task(s) already in progress.", (Object)this.taskCount.get());
            return queue;
        }
        try {
            this.deletedDirSupplier.reInitItr();
        }
        catch (IOException ex) {
            LOG.error("Unable to get the iterator.", (Throwable)ex);
            return queue;
        }
        this.taskCount.set(this.dirDeletingCorePoolSize);
        int i = 0;
        while (i < this.dirDeletingCorePoolSize) {
            queue.add((BackgroundTask)new DirDeletingTask(this));
            ++i;
        }
        return queue;
    }

    public void shutdown() {
        super.shutdown();
        this.deletedDirSupplier.closeItr();
    }

    public Table.KeyValue<String, OmKeyInfo> getPendingDeletedDirInfo() throws IOException {
        return this.deletedDirSupplier.get();
    }

    private final class DeletedDirSupplier {
        private TableIterator<String, ? extends Table.KeyValue<String, OmKeyInfo>> deleteTableIterator;

        private DeletedDirSupplier() {
        }

        private synchronized Table.KeyValue<String, OmKeyInfo> get() throws IOException {
            if (this.deleteTableIterator.hasNext()) {
                return (Table.KeyValue)this.deleteTableIterator.next();
            }
            return null;
        }

        private synchronized void closeItr() {
            IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.deleteTableIterator});
            this.deleteTableIterator = null;
        }

        private synchronized void reInitItr() throws IOException {
            this.closeItr();
            this.deleteTableIterator = DirectoryDeletingService.this.getOzoneManager().getMetadataManager().getDeletedDirTable().iterator();
        }
    }

    private final class DirDeletingTask
    implements BackgroundTask {
        private final DirectoryDeletingService directoryDeletingService;

        private DirDeletingTask(DirectoryDeletingService service) {
            this.directoryDeletingService = service;
        }

        public int getPriority() {
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BackgroundTaskResult call() {
            block11: {
                try {
                    if (!DirectoryDeletingService.this.shouldRun()) break block11;
                    DirectoryDeletingService.this.isRunningOnAOS.set(true);
                    long rnCnt = DirectoryDeletingService.this.getRunCount().incrementAndGet();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Running DirectoryDeletingService. {}", (Object)rnCnt);
                    }
                    long dirNum = 0L;
                    long subDirNum = 0L;
                    long subFileNum = 0L;
                    long remainingBufLimit = DirectoryDeletingService.this.ratisByteLimit;
                    int consumedSize = 0;
                    ArrayList<OzoneManagerProtocolProtos.PurgePathRequest> purgePathRequestList = new ArrayList<OzoneManagerProtocolProtos.PurgePathRequest>();
                    ArrayList<Pair<String, OmKeyInfo>> allSubDirList = new ArrayList<Pair<String, OmKeyInfo>>();
                    try {
                        UUID expectedPreviousSnapshotId = ((OmMetadataManagerImpl)DirectoryDeletingService.this.getOzoneManager().getMetadataManager()).getSnapshotChainManager().getLatestGlobalSnapshotId();
                        long startTime = Time.monotonicNow();
                        while (remainingBufLimit > 0L) {
                            Table.KeyValue<String, OmKeyInfo> pendingDeletedDirInfo = DirectoryDeletingService.this.getPendingDeletedDirInfo();
                            if (pendingDeletedDirInfo == null) break;
                            if (this.previousSnapshotHasDir(pendingDeletedDirInfo)) continue;
                            OzoneManagerProtocolProtos.PurgePathRequest request = DirectoryDeletingService.this.prepareDeleteDirRequest((OmKeyInfo)pendingDeletedDirInfo.getValue(), (String)pendingDeletedDirInfo.getKey(), allSubDirList, DirectoryDeletingService.this.getOzoneManager().getKeyManager(), remainingBufLimit);
                            remainingBufLimit -= (long)(consumedSize += request.getSerializedSize());
                            purgePathRequestList.add(request);
                            if (request.getDeletedDir() != null && !request.getDeletedDir().isEmpty()) {
                                ++dirNum;
                            }
                            subDirNum += (long)request.getMarkDeletedSubDirsCount();
                            subFileNum += (long)request.getDeletedSubFilesCount();
                        }
                        DirectoryDeletingService.this.optimizeDirDeletesAndSubmitRequest(dirNum, subDirNum, subFileNum, allSubDirList, purgePathRequestList, null, startTime, remainingBufLimit, DirectoryDeletingService.this.getOzoneManager().getKeyManager(), expectedPreviousSnapshotId, rnCnt);
                    }
                    catch (IOException e) {
                        LOG.error("Error while running delete directories and files background task. Will retry at next run.", (Throwable)e);
                    }
                    DirectoryDeletingService.this.isRunningOnAOS.set(false);
                    DirectoryDeletingService directoryDeletingService = this.directoryDeletingService;
                    synchronized (directoryDeletingService) {
                        ((Object)((Object)this.directoryDeletingService)).notify();
                    }
                }
                finally {
                    DirectoryDeletingService.this.taskCount.getAndDecrement();
                }
            }
            return BackgroundTaskResult.EmptyTaskResult.newResult();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean previousSnapshotHasDir(Table.KeyValue<String, OmKeyInfo> pendingDeletedDirInfo) throws IOException {
            String key = (String)pendingDeletedDirInfo.getKey();
            OmKeyInfo deletedDirInfo = (OmKeyInfo)pendingDeletedDirInfo.getValue();
            OmSnapshotManager omSnapshotManager = DirectoryDeletingService.this.getOzoneManager().getOmSnapshotManager();
            OmMetadataManagerImpl metadataManager = (OmMetadataManagerImpl)DirectoryDeletingService.this.getOzoneManager().getMetadataManager();
            SnapshotInfo previousSnapshotInfo = SnapshotUtils.getLatestSnapshotInfo(deletedDirInfo.getVolumeName(), deletedDirInfo.getBucketName(), DirectoryDeletingService.this.getOzoneManager(), metadataManager.getSnapshotChainManager());
            if (previousSnapshotInfo == null) {
                return false;
            }
            if (previousSnapshotInfo.getSnapshotStatus() != SnapshotInfo.SnapshotStatus.SNAPSHOT_ACTIVE) return true;
            if (!OmSnapshotManager.areSnapshotChangesFlushedToDB(DirectoryDeletingService.this.getOzoneManager().getMetadataManager(), previousSnapshotInfo)) {
                return true;
            }
            Throwable throwable = null;
            Object var8_9 = null;
            try (ReferenceCounted<OmSnapshot> rcLatestSnapshot = omSnapshotManager.getSnapshot(deletedDirInfo.getVolumeName(), deletedDirInfo.getBucketName(), previousSnapshotInfo.getName());){
                boolean bl;
                if (rcLatestSnapshot == null) return false;
                String dbRenameKey = metadataManager.getRenameKey(deletedDirInfo.getVolumeName(), deletedDirInfo.getBucketName(), deletedDirInfo.getObjectID());
                Table prevDirTable = rcLatestSnapshot.get().getMetadataManager().getDirectoryTable();
                Table prevDeletedDirTable = rcLatestSnapshot.get().getMetadataManager().getDeletedDirTable();
                OmKeyInfo prevDeletedDirInfo = (OmKeyInfo)prevDeletedDirTable.get((Object)key);
                if (prevDeletedDirInfo != null) {
                    return true;
                }
                String prevDirTableDBKey = (String)metadataManager.getSnapshotRenamedTable().get((Object)dbRenameKey);
                String prevDbKey = prevDirTableDBKey == null ? metadataManager.getOzoneDeletePathDirKey(key) : prevDirTableDBKey;
                OmDirectoryInfo prevDirInfo = (OmDirectoryInfo)prevDirTable.get((Object)prevDbKey);
                SnapshotInfo newPreviousSnapshotInfo = SnapshotUtils.getLatestSnapshotInfo(deletedDirInfo.getVolumeName(), deletedDirInfo.getBucketName(), DirectoryDeletingService.this.getOzoneManager(), metadataManager.getSnapshotChainManager());
                if (Objects.equals(Optional.ofNullable(newPreviousSnapshotInfo).map(SnapshotInfo::getSnapshotId), Optional.ofNullable(previousSnapshotInfo).map(SnapshotInfo::getSnapshotId)) && (prevDirInfo == null || prevDirInfo.getObjectID() != deletedDirInfo.getObjectID())) {
                    bl = false;
                    return bl;
                }
                bl = true;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
    }
}

