/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.tenant;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"tenantStateTable", "volumeTable"})
public class OMTenantDeleteResponse
extends OMClientResponse {
    private String volumeName;
    private OmVolumeArgs omVolumeArgs;
    private String tenantId;

    public OMTenantDeleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull String volumeName, @Nullable OmVolumeArgs omVolumeArgs, @Nonnull String tenantId) {
        super(omResponse);
        this.volumeName = volumeName;
        this.omVolumeArgs = omVolumeArgs;
        this.tenantId = tenantId;
    }

    public OMTenantDeleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    protected void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        omMetadataManager.getTenantStateTable().deleteWithBatch(batchOperation, (Object)this.tenantId);
        if (!this.volumeName.isEmpty()) {
            Preconditions.checkNotNull((Object)this.omVolumeArgs);
            Preconditions.checkState((boolean)this.omVolumeArgs.getVolume().equals(this.volumeName));
            String dbVolumeKey = omMetadataManager.getVolumeKey(this.volumeName);
            omMetadataManager.getVolumeTable().putWithBatch(batchOperation, (Object)dbVolumeKey, (Object)this.omVolumeArgs);
        }
    }
}

