/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.tenant;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.Collections;
import java.util.HashMap;
import java.util.TreeSet;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OMMultiTenantManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.OmDBAccessIdInfo;
import org.apache.hadoop.ozone.om.helpers.OmDBUserPrincipalInfo;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.tenant.OMTenantAssignUserAccessIdResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.DisallowedUntilLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeature;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMTenantAssignUserAccessIdRequest
extends OMClientRequest {
    public static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMTenantAssignUserAccessIdRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMTenantAssignUserAccessIdRequest.class);
    }

    public OMTenantAssignUserAccessIdRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    @DisallowedUntilLayoutVersion(value=OMLayoutFeature.MULTITENANCY_SCHEMA)
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2);
        OMLayoutFeatureAspect.aspectOf().checkLayoutFeature(joinPoint);
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(joinPoint);
        }
        OzoneManagerProtocolProtos.OMRequest omRequest = super.preExecute(ozoneManager);
        OzoneManagerProtocolProtos.TenantAssignUserAccessIdRequest request = omRequest.getTenantAssignUserAccessIdRequest();
        String tenantId = request.getTenantId();
        OMMultiTenantManager multiTenantManager = ozoneManager.getMultiTenantManager();
        multiTenantManager.checkTenantAdmin(tenantId, false);
        String userPrincipal = request.getUserPrincipal();
        String accessId = request.getAccessId();
        if (accessId.length() >= 100) {
            throw new OMException("accessId length exceeds the maximum length allowed", OMException.ResultCodes.INVALID_ACCESS_ID);
        }
        if (userPrincipal.contains("$")) {
            throw new OMException("Invalid tenant username '" + userPrincipal + "'. Tenant username shouldn't contain delimiter.", OMException.ResultCodes.INVALID_TENANT_USERNAME);
        }
        if (tenantId.contains("$")) {
            throw new OMException("Invalid tenant name '" + tenantId + "'. Tenant name shouldn't contain delimiter.", OMException.ResultCodes.INVALID_TENANT_ID);
        }
        String expectedAccessId = OMMultiTenantManager.getDefaultAccessId(tenantId, userPrincipal);
        if (!accessId.equals(expectedAccessId)) {
            throw new OMException("Invalid accessId '" + accessId + "'. " + "Specifying a custom access ID disallowed. " + "Expected accessId to be assigned is '" + expectedAccessId + "'", OMException.ResultCodes.INVALID_ACCESS_ID);
        }
        multiTenantManager.checkTenantExistence(tenantId);
        multiTenantManager.getAuthorizerLock().tryWriteLockInOMRequest();
        try {
            multiTenantManager.getAuthorizerOp().assignUserToTenant(userPrincipal, tenantId, accessId);
        }
        catch (Exception e) {
            multiTenantManager.getAuthorizerLock().unlockWriteInOMRequest();
            throw e;
        }
        String s3Secret = DigestUtils.sha256Hex((byte[])OmUtils.getSHADigest());
        OzoneManagerProtocolProtos.UpdateGetS3SecretRequest updateGetS3SecretRequest = OzoneManagerProtocolProtos.UpdateGetS3SecretRequest.newBuilder().setKerberosID(accessId).setAwsSecret(s3Secret).build();
        OzoneManagerProtocolProtos.OMRequest.Builder omRequestBuilder = omRequest.toBuilder().setUpdateGetS3SecretRequest(updateGetS3SecretRequest);
        return omRequestBuilder.build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        Exception exception;
        String userPrincipal;
        String tenantId;
        HashMap<String, String> auditMap;
        String accessId;
        OMClientResponse omClientResponse;
        OMMetrics omMetrics;
        block20: {
            long transactionLogIndex = context.getIndex();
            OMMultiTenantManager multiTenantManager = ozoneManager.getMultiTenantManager();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumTenantAssignUsers();
            omClientResponse = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            OzoneManagerProtocolProtos.UpdateGetS3SecretRequest updateGetS3SecretRequest = this.getOmRequest().getUpdateGetS3SecretRequest();
            accessId = updateGetS3SecretRequest.getKerberosID();
            String awsSecret = updateGetS3SecretRequest.getAwsSecret();
            boolean acquiredVolumeLock = false;
            auditMap = new HashMap<String, String>();
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            OzoneManagerProtocolProtos.TenantAssignUserAccessIdRequest request = this.getOmRequest().getTenantAssignUserAccessIdRequest();
            tenantId = request.getTenantId();
            userPrincipal = request.getUserPrincipal();
            Preconditions.checkState((boolean)accessId.equals(request.getAccessId()));
            exception = null;
            String volumeName = null;
            try {
                try {
                    volumeName = ozoneManager.getMultiTenantManager().getTenantVolumeName(tenantId);
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName}));
                    acquiredVolumeLock = this.getOmLockDetails().isLockAcquired();
                    if (!omMetadataManager.getTenantStateTable().isExist((Object)tenantId)) {
                        LOG.error("tenant {} doesn't exist", (Object)tenantId);
                        throw new OMException("tenant '" + tenantId + "' doesn't exist", OMException.ResultCodes.TENANT_NOT_FOUND);
                    }
                    if (omMetadataManager.getTenantAccessIdTable().isExist((Object)accessId)) {
                        LOG.error("accessId {} already exists", (Object)accessId);
                        throw new OMException("accessId '" + accessId + "' already exists!", OMException.ResultCodes.TENANT_USER_ACCESS_ID_ALREADY_EXISTS);
                    }
                    OmDBUserPrincipalInfo principalInfo = (OmDBUserPrincipalInfo)omMetadataManager.getPrincipalToAccessIdsTable().getIfExist((Object)userPrincipal);
                    if (principalInfo != null) {
                        for (String existingAccId : principalInfo.getAccessIds()) {
                            OmDBAccessIdInfo accessIdInfo = (OmDBAccessIdInfo)omMetadataManager.getTenantAccessIdTable().get((Object)existingAccId);
                            if (accessIdInfo == null) {
                                LOG.error("Metadata error: accessIdInfo is null for accessId '{}'. Ignoring.", (Object)existingAccId);
                                throw new OMException("accessIdInfo is null", OMException.ResultCodes.INVALID_ACCESS_ID);
                            }
                            if (!tenantId.equals(accessIdInfo.getTenantId())) continue;
                            throw new OMException("The same user is not allowed to be assigned to the same tenant more than once. User '" + userPrincipal + "' is already assigned to tenant '" + tenantId + "' with " + "accessId '" + existingAccId + "'.", OMException.ResultCodes.TENANT_USER_ACCESS_ID_ALREADY_EXISTS);
                        }
                    }
                    S3SecretValue s3SecretValue = S3SecretValue.of((String)accessId, (String)awsSecret, (long)transactionLogIndex);
                    OmDBAccessIdInfo omDBAccessIdInfo = new OmDBAccessIdInfo.Builder().setTenantId(tenantId).setUserPrincipal(userPrincipal).setIsAdmin(false).setIsDelegatedAdmin(false).build();
                    omMetadataManager.getTenantAccessIdTable().addCacheEntry(new CacheKey((Object)accessId), CacheValue.get((long)transactionLogIndex, (Object)omDBAccessIdInfo));
                    if (principalInfo == null) {
                        principalInfo = new OmDBUserPrincipalInfo.Builder().setAccessIds(new TreeSet<String>(Collections.singleton(accessId))).build();
                    } else {
                        principalInfo.addAccessId(accessId);
                    }
                    omMetadataManager.getPrincipalToAccessIdsTable().addCacheEntry(new CacheKey((Object)userPrincipal), CacheValue.get((long)transactionLogIndex, (Object)principalInfo));
                    ozoneManager.getS3SecretManager().doUnderLock(accessId, s3SecretManager -> {
                        if (s3SecretManager.hasS3Secret(accessId)) {
                            LOG.error("accessId '{}' already exists in S3SecretTable", (Object)accessId);
                            throw new OMException("accessId '" + accessId + "' already exists in S3SecretTable", OMException.ResultCodes.TENANT_USER_ACCESS_ID_ALREADY_EXISTS);
                        }
                        s3SecretManager.updateCache(accessId, s3SecretValue);
                        return null;
                    });
                    multiTenantManager.getCacheOp().assignUserToTenant(userPrincipal, tenantId, accessId);
                    omResponse.setTenantAssignUserAccessIdResponse(OzoneManagerProtocolProtos.TenantAssignUserAccessIdResponse.newBuilder().setS3Secret(OzoneManagerProtocolProtos.S3Secret.newBuilder().setAwsSecret(awsSecret).setKerberosID(accessId)).build());
                    omClientResponse = new OMTenantAssignUserAccessIdResponse(omResponse.build(), s3SecretValue, userPrincipal, accessId, omDBAccessIdInfo, principalInfo, ozoneManager.getS3SecretManager());
                }
                catch (IOException | InvalidPathException ex) {
                    exception = ex;
                    omResponse.setTenantAssignUserAccessIdResponse(OzoneManagerProtocolProtos.TenantAssignUserAccessIdResponse.newBuilder().build());
                    omClientResponse = new OMTenantAssignUserAccessIdResponse(this.createErrorOMResponse(omResponse, exception));
                    if (acquiredVolumeLock) {
                        Preconditions.checkNotNull((Object)volumeName);
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName}));
                    }
                    multiTenantManager.getAuthorizerLock().unlockWriteInOMRequest();
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (acquiredVolumeLock) {
                    Preconditions.checkNotNull((Object)volumeName);
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName}));
                }
                multiTenantManager.getAuthorizerLock().unlockWriteInOMRequest();
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquiredVolumeLock) {
                Preconditions.checkNotNull((Object)volumeName);
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName}));
            }
            multiTenantManager.getAuthorizerLock().unlockWriteInOMRequest();
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        auditMap.put("tenant", tenantId);
        auditMap.put("user", userPrincipal);
        auditMap.put("accessId", accessId);
        this.markForAudit(ozoneManager.getAuditLogger(), this.buildAuditMessage(OMAction.TENANT_ASSIGN_USER_ACCESSID, auditMap, exception, this.getOmRequest().getUserInfo()));
        if (exception == null) {
            LOG.info("Assigned user '{}' to tenant '{}' with accessId '{}'", new Object[]{userPrincipal, tenantId, accessId});
        } else {
            LOG.error("Failed to assign '{}' to tenant '{}' with accessId '{}': {}", new Object[]{userPrincipal, tenantId, accessId, exception.getMessage()});
            omMetrics.incNumTenantAssignUserFails();
        }
        return omClientResponse;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMTenantAssignUserAccessIdRequest.java", OMTenantAssignUserAccessIdRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.s3.tenant.OMTenantAssignUserAccessIdRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 106);
    }
}

