/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.file;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.file.OMDirectoryCreateRequest;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.file.OMDirectoryCreateResponseWithFSO;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMDirectoryCreateRequestWithFSO
extends OMDirectoryCreateRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMDirectoryCreateRequestWithFSO.class);

    public OMDirectoryCreateRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omRequest, BucketLayout bucketLayout) {
        super(omRequest, bucketLayout);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        OMDirectoryCreateRequest.Result result;
        OMClientResponse omClientResponse;
        Exception exception;
        Map<String, String> auditMap;
        OzoneManagerProtocolProtos.UserInfo userInfo;
        AuditLogger auditLogger;
        OMMetrics omMetrics;
        int numKeysCreated;
        OzoneManagerProtocolProtos.KeyArgs keyArgs;
        OzoneManagerProtocolProtos.CreateDirectoryRequest createDirectoryRequest;
        block15: {
            long trxnLogIndex = context.getIndex();
            createDirectoryRequest = this.getOmRequest().getCreateDirectoryRequest();
            keyArgs = createDirectoryRequest.getKeyArgs();
            String volumeName = keyArgs.getVolumeName();
            String bucketName = keyArgs.getBucketName();
            String keyName = keyArgs.getKeyName();
            numKeysCreated = 0;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            omResponse.setCreateDirectoryResponse(OzoneManagerProtocolProtos.CreateDirectoryResponse.newBuilder());
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumCreateDirectory();
            auditLogger = ozoneManager.getAuditLogger();
            userInfo = this.getOmRequest().getUserInfo();
            auditMap = this.buildKeyArgsAuditMap(keyArgs);
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean acquiredLock = false;
            exception = null;
            omClientResponse = null;
            result = OMDirectoryCreateRequest.Result.FAILURE;
            try {
                try {
                    if (keyName.isEmpty()) {
                        throw new OMException("Directory create failed. Cannot create directory at root of the filesystem", OMException.ResultCodes.CANNOT_CREATE_DIRECTORY_AT_ROOT);
                    }
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    acquiredLock = this.getOmLockDetails().isLockAcquired();
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    Path keyPath = Paths.get(keyName, new String[0]);
                    OMFileRequest.OMPathInfoWithFSO omPathInfo = OMFileRequest.verifyDirectoryKeysInPath(omMetadataManager, volumeName, bucketName, keyName, keyPath);
                    OMFileRequest.OMDirectoryResult omDirectoryResult = omPathInfo.getDirectoryResult();
                    if (omDirectoryResult == OMFileRequest.OMDirectoryResult.FILE_EXISTS || omDirectoryResult == OMFileRequest.OMDirectoryResult.FILE_EXISTS_IN_GIVENPATH) {
                        throw new OMException("Unable to create directory: " + keyName + " in volume/bucket: " + volumeName + "/" + bucketName + " as " + "file:" + omPathInfo.getFileExistsInPath() + " already exists", OMException.ResultCodes.FILE_ALREADY_EXISTS);
                    }
                    if (omDirectoryResult == OMFileRequest.OMDirectoryResult.DIRECTORY_EXISTS_IN_GIVENPATH || omDirectoryResult == OMFileRequest.OMDirectoryResult.NONE) {
                        OmBucketInfo omBucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName);
                        List<OmDirectoryInfo> missingParentInfos = this.getAllMissingParentDirInfo(ozoneManager, keyArgs, omBucketInfo, omPathInfo, trxnLogIndex);
                        long volumeId = omMetadataManager.getVolumeId(volumeName);
                        long bucketId = omMetadataManager.getBucketId(volumeName, bucketName);
                        numKeysCreated = missingParentInfos.size() + 1;
                        this.checkBucketQuotaInNamespace(omBucketInfo, numKeysCreated);
                        omBucketInfo.incrUsedNamespace((long)numKeysCreated);
                        OmDirectoryInfo dirInfo = this.createDirectoryInfoWithACL(omPathInfo.getLeafNodeName(), keyArgs, omPathInfo.getLeafNodeObjectId(), omPathInfo.getLastKnownParentId(), trxnLogIndex, omBucketInfo, omPathInfo, ozoneManager.getConfiguration());
                        OMFileRequest.addDirectoryTableCacheEntries(omMetadataManager, volumeId, bucketId, trxnLogIndex, missingParentInfos, dirInfo);
                        result = OMDirectoryCreateRequest.Result.SUCCESS;
                        omClientResponse = new OMDirectoryCreateResponseWithFSO(omResponse.build(), volumeId, bucketId, dirInfo, missingParentInfos, result, this.getBucketLayout(), omBucketInfo.copyObject());
                    } else {
                        result = OMDirectoryCreateRequest.Result.DIRECTORY_ALREADY_EXISTS;
                        omResponse.setStatus(OzoneManagerProtocolProtos.Status.DIRECTORY_ALREADY_EXISTS);
                        omClientResponse = new OMDirectoryCreateResponseWithFSO(omResponse.build(), result);
                    }
                }
                catch (IOException | InvalidPathException ex) {
                    exception = ex;
                    omClientResponse = new OMDirectoryCreateResponseWithFSO(this.createErrorOMResponse(omResponse, exception), result);
                    if (acquiredLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (acquiredLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquiredLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        this.markForAudit(auditLogger, this.buildAuditMessage(OMAction.CREATE_DIRECTORY, auditMap, exception, userInfo));
        this.logResult(createDirectoryRequest, keyArgs, omMetrics, numKeysCreated, result, exception);
        return omClientResponse;
    }

    private void logResult(OzoneManagerProtocolProtos.CreateDirectoryRequest createDirectoryRequest, OzoneManagerProtocolProtos.KeyArgs keyArgs, OMMetrics omMetrics, int numKeys, OMDirectoryCreateRequest.Result result, Exception exception) {
        String volumeName = keyArgs.getVolumeName();
        String bucketName = keyArgs.getBucketName();
        String keyName = keyArgs.getKeyName();
        switch (result) {
            case SUCCESS: {
                omMetrics.incNumKeys(numKeys);
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Directory created. Volume:{}, Bucket:{}, Key:{}", new Object[]{volumeName, bucketName, keyName});
                break;
            }
            case DIRECTORY_ALREADY_EXISTS: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Directory already exists. Volume:{}, Bucket:{}, Key{}", new Object[]{volumeName, bucketName, keyName, exception});
                break;
            }
            case FAILURE: {
                omMetrics.incNumCreateDirectoryFails();
                LOG.error("Directory creation failed. Volume:{}, Bucket:{}, Key{}. Exception:{}", new Object[]{volumeName, bucketName, keyName, exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMDirectoryCreateRequest: {}", (Object)createDirectoryRequest);
            }
        }
    }
}

