/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.PrefixManager;
import org.apache.hadoop.ozone.om.ResolvedBucket;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmPrefixInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.RequestContext;
import org.apache.hadoop.ozone.util.RadixNode;
import org.apache.hadoop.ozone.util.RadixTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefixManagerImpl
implements PrefixManager {
    private static final Logger LOG = LoggerFactory.getLogger(PrefixManagerImpl.class);
    private static final List<OzoneAcl> EMPTY_ACL_LIST = new ArrayList<OzoneAcl>();
    private final OzoneManager ozoneManager;
    private final OMMetadataManager metadataManager;
    private RadixTree<OmPrefixInfo> prefixTree;
    private final boolean isRatisEnabled;

    public PrefixManagerImpl(OzoneManager ozoneManager, OMMetadataManager metadataManager, boolean isRatisEnabled) {
        this.isRatisEnabled = isRatisEnabled;
        this.ozoneManager = ozoneManager;
        this.metadataManager = metadataManager;
        this.loadPrefixTree();
    }

    private void loadPrefixTree() {
        this.prefixTree = new RadixTree();
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (TableIterator iterator = this.getMetadataManager().getPrefixTable().iterator();){
                iterator.seekToFirst();
                while (iterator.hasNext()) {
                    Table.KeyValue kv = (Table.KeyValue)iterator.next();
                    this.prefixTree.insert((String)kv.getKey(), (Object)((OmPrefixInfo)kv.getValue()));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            LOG.error("Fail to load prefix tree");
        }
    }

    @Override
    public OMMetadataManager getMetadataManager() {
        return this.metadataManager;
    }

    @Override
    public List<OzoneAcl> getAcl(OzoneObj obj) throws IOException {
        String prefixPath;
        block2: {
            List list;
            this.validateOzoneObj(obj);
            OzoneObj resolvedObj = this.getResolvedPrefixObj(obj);
            prefixPath = resolvedObj.getPath();
            this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
            try {
                RadixNode lastNode;
                String longestPrefix = this.prefixTree.getLongestPrefix(prefixPath);
                if (!prefixPath.equals(longestPrefix) || (lastNode = this.prefixTree.getLastNodeInPrefixPath(prefixPath)) == null || lastNode.getValue() == null) break block2;
                list = ((OmPrefixInfo)lastNode.getValue()).getAcls();
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
                throw throwable;
            }
            this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
            return list;
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
        return EMPTY_ACL_LIST;
    }

    @VisibleForTesting
    public OmPrefixInfo getPrefixInfo(OzoneObj obj) throws IOException {
        String prefixPath;
        block2: {
            OmPrefixInfo omPrefixInfo;
            this.validateOzoneObj(obj);
            prefixPath = obj.getPath();
            this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
            try {
                RadixNode lastNode;
                String longestPrefix = this.prefixTree.getLongestPrefix(prefixPath);
                if (!prefixPath.equals(longestPrefix) || (lastNode = this.prefixTree.getLastNodeInPrefixPath(prefixPath)) == null || lastNode.getValue() == null) break block2;
                omPrefixInfo = (OmPrefixInfo)lastNode.getValue();
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
                throw throwable;
            }
            this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
            return omPrefixInfo;
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
        return null;
    }

    @Override
    public boolean checkAccess(OzoneObj ozObject, RequestContext context) throws OMException {
        String prefixPath;
        block5: {
            boolean bl;
            OzoneObj resolvedObj;
            Objects.requireNonNull(ozObject);
            Objects.requireNonNull(context);
            try {
                resolvedObj = this.getResolvedPrefixObj(ozObject);
            }
            catch (IOException e) {
                throw new OMException("Failed to resolveBucketLink:", (Throwable)e, OMException.ResultCodes.INTERNAL_ERROR);
            }
            prefixPath = resolvedObj.getPath();
            this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
            try {
                RadixNode lastNode;
                String longestPrefix = this.prefixTree.getLongestPrefix(prefixPath);
                if (!prefixPath.equals(longestPrefix) || (lastNode = this.prefixTree.getLastNodeInPrefixPath(prefixPath)) == null || lastNode.getValue() == null) break block5;
                boolean hasAccess = OzoneAclUtil.checkAclRights((List)((OmPrefixInfo)lastNode.getValue()).getAcls(), (RequestContext)context);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("user:{} has access rights for ozObj:{} ::{} ", new Object[]{context.getClientUgi(), ozObject, hasAccess});
                }
                bl = hasAccess;
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
                throw throwable;
            }
            this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
            return bl;
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
        return true;
    }

    @Override
    public List<OmPrefixInfo> getLongestPrefixPath(String path) {
        List<OmPrefixInfo> list;
        String prefixPath = this.prefixTree.getLongestPrefix(path);
        this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
        try {
            list = this.getLongestPrefixPathHelper(prefixPath);
        }
        catch (Throwable throwable) {
            this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
            throw throwable;
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.PREFIX_LOCK, new String[]{prefixPath});
        return list;
    }

    private List<OmPrefixInfo> getLongestPrefixPathHelper(String prefixPath) {
        return this.prefixTree.getLongestPrefixPath(prefixPath).stream().map(c -> (OmPrefixInfo)c.getValue()).collect(Collectors.toList());
    }

    public void validateOzoneObj(OzoneObj obj) throws OMException {
        Objects.requireNonNull(obj);
        if (!obj.getResourceType().equals((Object)OzoneObj.ResourceType.PREFIX)) {
            throw new IllegalArgumentException("Unexpected argument passed to PrefixManager. OzoneObj type:" + obj.getResourceType());
        }
        String volume = obj.getVolumeName();
        String bucket = obj.getBucketName();
        String prefixName = obj.getPrefixName();
        if (Strings.isNullOrEmpty((String)volume)) {
            throw new OMException("Volume name is required.", OMException.ResultCodes.VOLUME_NOT_FOUND);
        }
        if (Strings.isNullOrEmpty((String)bucket)) {
            throw new OMException("Bucket name is required.", OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
        if (Strings.isNullOrEmpty((String)prefixName)) {
            throw new OMException("Prefix name is required.", OMException.ResultCodes.PREFIX_NOT_FOUND);
        }
        if (!prefixName.endsWith("/")) {
            throw new OMException("Missing trailing slash '/' in prefix name: " + prefixName, OMException.ResultCodes.INVALID_PATH_IN_ACL_REQUEST);
        }
    }

    public OMPrefixAclOpResult addAcl(OzoneObj ozoneObj, OzoneAcl ozoneAcl, OmPrefixInfo prefixInfo, long transactionLogIndex) throws IOException {
        boolean newPrefix = false;
        if (prefixInfo == null) {
            OmPrefixInfo.Builder prefixInfoBuilder = new OmPrefixInfo.Builder().setName(ozoneObj.getPath());
            if (transactionLogIndex > 0L) {
                prefixInfoBuilder.setObjectID(OmUtils.getObjectIdFromTxId((long)this.metadataManager.getOmEpoch(), (long)transactionLogIndex));
                prefixInfoBuilder.setUpdateID(transactionLogIndex);
            }
            prefixInfo = prefixInfoBuilder.build();
            newPrefix = true;
        }
        boolean changed = prefixInfo.addAcl(ozoneAcl);
        if (newPrefix) {
            this.inheritParentAcl(ozoneObj, prefixInfo);
        }
        this.prefixTree.insert(ozoneObj.getPath(), (Object)prefixInfo);
        if (!this.isRatisEnabled) {
            this.metadataManager.getPrefixTable().put((Object)ozoneObj.getPath(), (Object)prefixInfo);
        }
        return new OMPrefixAclOpResult(prefixInfo, changed);
    }

    public OMPrefixAclOpResult removeAcl(OzoneObj ozoneObj, OzoneAcl ozoneAcl, OmPrefixInfo prefixInfo) throws IOException {
        if (prefixInfo == null) {
            return new OMPrefixAclOpResult(null, false);
        }
        boolean removed = prefixInfo.removeAcl(ozoneAcl);
        if (prefixInfo.getAcls().isEmpty()) {
            this.prefixTree.removePrefixPath(ozoneObj.getPath());
            if (!this.isRatisEnabled) {
                this.metadataManager.getPrefixTable().delete((Object)ozoneObj.getPath());
            }
        } else {
            this.prefixTree.insert(ozoneObj.getPath(), (Object)prefixInfo);
            if (!this.isRatisEnabled) {
                this.metadataManager.getPrefixTable().put((Object)ozoneObj.getPath(), (Object)prefixInfo);
            }
        }
        return new OMPrefixAclOpResult(prefixInfo, removed);
    }

    private void inheritParentAcl(OzoneObj ozoneObj, OmPrefixInfo prefixInfo) throws IOException {
        OmPrefixInfo parentPrefixInfo;
        List aclsToBeSet = prefixInfo.getAcls();
        boolean prefixParentFound = false;
        List<OmPrefixInfo> prefixList = this.getLongestPrefixPathHelper(this.prefixTree.getLongestPrefix(ozoneObj.getPath()));
        if (!prefixList.isEmpty() && (parentPrefixInfo = prefixList.get(prefixList.size() - 1)) != null) {
            prefixParentFound = OzoneAclUtil.inheritDefaultAcls((List)aclsToBeSet, (List)parentPrefixInfo.getAcls(), (OzoneAcl.AclScope)OzoneAcl.AclScope.ACCESS);
        }
        if (!prefixParentFound) {
            String bucketKey = this.metadataManager.getBucketKey(ozoneObj.getVolumeName(), ozoneObj.getBucketName());
            OmBucketInfo bucketInfo = (OmBucketInfo)this.metadataManager.getBucketTable().get((Object)bucketKey);
            if (bucketInfo != null) {
                OzoneAclUtil.inheritDefaultAcls((List)aclsToBeSet, (List)bucketInfo.getAcls(), (OzoneAcl.AclScope)OzoneAcl.AclScope.ACCESS);
            }
        }
    }

    public OMPrefixAclOpResult setAcl(OzoneObj ozoneObj, List<OzoneAcl> ozoneAcls, OmPrefixInfo prefixInfo, long transactionLogIndex) throws IOException {
        boolean newPrefix = false;
        if (prefixInfo == null) {
            OmPrefixInfo.Builder prefixInfoBuilder = new OmPrefixInfo.Builder().setName(ozoneObj.getPath());
            if (transactionLogIndex > 0L) {
                prefixInfoBuilder.setObjectID(OmUtils.getObjectIdFromTxId((long)this.metadataManager.getOmEpoch(), (long)transactionLogIndex));
                prefixInfoBuilder.setUpdateID(transactionLogIndex);
            }
            prefixInfo = prefixInfoBuilder.build();
            newPrefix = true;
        }
        boolean changed = prefixInfo.setAcls(ozoneAcls);
        if (newPrefix) {
            this.inheritParentAcl(ozoneObj, prefixInfo);
        }
        this.prefixTree.insert(ozoneObj.getPath(), (Object)prefixInfo);
        if (!this.isRatisEnabled) {
            this.metadataManager.getPrefixTable().put((Object)ozoneObj.getPath(), (Object)prefixInfo);
        }
        return new OMPrefixAclOpResult(prefixInfo, changed);
    }

    public OzoneObj getResolvedPrefixObj(OzoneObj obj) throws IOException {
        if (StringUtils.isEmpty((CharSequence)obj.getVolumeName()) || StringUtils.isEmpty((CharSequence)obj.getBucketName())) {
            return obj;
        }
        ResolvedBucket resolvedBucket = this.ozoneManager.resolveBucketLink((Pair<String, String>)Pair.of((Object)obj.getVolumeName(), (Object)obj.getBucketName()));
        return resolvedBucket.update(obj);
    }

    public static class OMPrefixAclOpResult {
        private final OmPrefixInfo omPrefixInfo;
        private final boolean operationsResult;

        public OMPrefixAclOpResult(OmPrefixInfo omPrefixInfo, boolean operationsResult) {
            this.omPrefixInfo = omPrefixInfo;
            this.operationsResult = operationsResult;
        }

        public OmPrefixInfo getOmPrefixInfo() {
            return this.omPrefixInfo;
        }

        public boolean isSuccess() {
            return this.operationsResult;
        }
    }
}

