/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OzoneManagerPrepareState {
    public static final long NO_PREPARE_INDEX = -1L;
    private static final Logger LOG = LoggerFactory.getLogger(OzoneManagerPrepareState.class);
    private boolean prepareGateEnabled;
    private long prepareIndex;
    private OzoneManagerProtocolProtos.PrepareStatusResponse.PrepareStatus status;
    private final ConfigurationSource conf;

    public OzoneManagerPrepareState(ConfigurationSource conf) {
        this.conf = conf;
        this.prepareIndex = -1L;
        this.prepareGateEnabled = false;
        this.status = OzoneManagerProtocolProtos.PrepareStatusResponse.PrepareStatus.NOT_PREPARED;
    }

    public OzoneManagerPrepareState(ConfigurationSource conf, long currentIndex) throws IOException {
        this(conf);
        if (this.getPrepareMarkerFile().exists()) {
            this.restorePrepareFromFile(currentIndex);
        }
    }

    public synchronized void enablePrepareGate() {
        this.prepareGateEnabled = true;
        this.prepareIndex = -1L;
        this.status = OzoneManagerProtocolProtos.PrepareStatusResponse.PrepareStatus.PREPARE_GATE_ENABLED;
    }

    public synchronized void cancelPrepare() throws IOException {
        this.prepareIndex = -1L;
        this.prepareGateEnabled = false;
        this.status = OzoneManagerProtocolProtos.PrepareStatusResponse.PrepareStatus.NOT_PREPARED;
        this.deletePrepareMarkerFile();
    }

    public synchronized void finishPrepare(long index) throws IOException {
        this.restorePrepareFromIndex(index, index, true);
    }

    public synchronized void restorePrepareFromIndex(long restoredPrepareIndex, long currentIndex) throws IOException {
        this.restorePrepareFromIndex(restoredPrepareIndex, currentIndex, true);
    }

    private void restorePrepareFromIndex(long restoredPrepareIndex, long currentIndex, boolean writeFile) throws IOException {
        if (restoredPrepareIndex <= currentIndex) {
            this.enablePrepareGate();
            if (writeFile) {
                this.writePrepareMarkerFile(restoredPrepareIndex);
            }
            this.prepareIndex = currentIndex;
            this.status = OzoneManagerProtocolProtos.PrepareStatusResponse.PrepareStatus.PREPARE_COMPLETED;
        } else {
            this.throwPrepareException("Failed to restore OM prepare state, because the existing prepare index %d is larger thanthe current index %d.", restoredPrepareIndex, currentIndex);
        }
    }

    public synchronized void restorePrepareFromFile(long currentIndex) throws IOException {
        long prepareMarkerIndex = -1L;
        File prepareMarkerFile = this.getPrepareMarkerFile();
        if (prepareMarkerFile.exists()) {
            byte[] data = new byte[(int)prepareMarkerFile.length()];
            try {
                Throwable throwable = null;
                Object var8_8 = null;
                try (InputStream stream = Files.newInputStream(prepareMarkerFile.toPath(), new OpenOption[0]);){
                    stream.read(data);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.throwPrepareException(e, "Failed to read prepare marker file %s while restoring OM.", prepareMarkerFile.getAbsolutePath());
            }
            try {
                prepareMarkerIndex = Long.parseLong(new String(data, StandardCharsets.UTF_8));
            }
            catch (NumberFormatException numberFormatException) {
                this.throwPrepareException("Failed to parse log index from prepare marker file %s while restoring OM.", prepareMarkerFile.getAbsolutePath());
            }
        } else {
            this.throwPrepareException("Unable to find prepare marker file to restore from. Expected %s: ", prepareMarkerFile.getAbsolutePath());
        }
        this.restorePrepareFromIndex(prepareMarkerIndex, currentIndex, false);
    }

    private void throwPrepareException(Throwable cause, String format, Object ... args) throws OMException {
        throw new OMException(String.format(format, args), cause, OMException.ResultCodes.PREPARE_FAILED);
    }

    private void throwPrepareException(String format, Object ... args) throws OMException {
        throw new OMException(String.format(format, args), OMException.ResultCodes.PREPARE_FAILED);
    }

    public synchronized boolean requestAllowed(OzoneManagerProtocolProtos.Type requestType) {
        boolean requestAllowed = true;
        if (this.prepareGateEnabled) {
            requestAllowed = requestType == OzoneManagerProtocolProtos.Type.Prepare || requestType == OzoneManagerProtocolProtos.Type.CancelPrepare;
        }
        return requestAllowed;
    }

    public synchronized State getState() {
        return new State(this.prepareIndex, this.status);
    }

    private void writePrepareMarkerFile(long index) throws IOException {
        File markerFile = this.getPrepareMarkerFile();
        File parentDir = markerFile.getParentFile();
        Files.createDirectories(parentDir.toPath(), new FileAttribute[0]);
        Throwable throwable = null;
        Object var6_6 = null;
        try (OutputStream stream = Files.newOutputStream(markerFile.toPath(), new OpenOption[0]);){
            stream.write(Long.toString(index).getBytes(StandardCharsets.UTF_8));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        LOG.info("Prepare marker file written with log index {} to file {}", (Object)index, (Object)markerFile.getAbsolutePath());
    }

    private void deletePrepareMarkerFile() throws IOException {
        File markerFile = this.getPrepareMarkerFile();
        if (markerFile.exists()) {
            Files.delete(markerFile.toPath());
            LOG.info("Deleted prepare marker file: {}", (Object)markerFile.getAbsolutePath());
        } else {
            LOG.debug("Request to delete prepare marker file that does not exist: {}", (Object)markerFile.getAbsolutePath());
        }
    }

    @VisibleForTesting
    public File getPrepareMarkerFile() {
        File markerFileDir = new File(ServerUtils.getOzoneMetaDirPath((ConfigurationSource)this.conf), "current");
        return new File(markerFileDir, "prepareMarker");
    }

    public static class State {
        private final long index;
        private final OzoneManagerProtocolProtos.PrepareStatusResponse.PrepareStatus status;

        public State(long index, OzoneManagerProtocolProtos.PrepareStatusResponse.PrepareStatus status) {
            this.index = index;
            this.status = status;
        }

        public long getIndex() {
            return this.index;
        }

        public OzoneManagerProtocolProtos.PrepareStatusResponse.PrepareStatus getStatus() {
            return this.status;
        }
    }
}

