/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.insight.datanode;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.ozone.insight.BaseInsightPoint;
import org.apache.hadoop.ozone.insight.Component;
import org.apache.hadoop.ozone.insight.InsightPoint;
import org.apache.hadoop.ozone.insight.LoggerSource;
import org.apache.hadoop.ozone.insight.datanode.PipelineComponentUtil;

public class RatisInsight
extends BaseInsightPoint
implements InsightPoint {
    private OzoneConfiguration conf;

    public RatisInsight(OzoneConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public List<LoggerSource> getRelatedLoggers(boolean verbose, Map<String, String> filters) {
        ArrayList<LoggerSource> result = new ArrayList<LoggerSource>();
        try (ScmClient scmClient = this.createScmClient(this.conf);){
            PipelineComponentUtil.withDatanodesFromPipeline(scmClient, PipelineComponentUtil.getPipelineIdFromFilters(filters), dn -> {
                result.add(new LoggerSource((Component)dn, "org.apache.ratis.server.impl", this.defaultLevel(verbose)));
                return null;
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException("Can't enumerate required logs", e);
        }
        return result;
    }

    @Override
    public String getDescription() {
        return "More information about one ratis datanode ring.";
    }

    @Override
    public boolean filterLog(Map<String, String> filters, String logLine) {
        return true;
    }
}

