/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.container.common.impl.StorageLocationReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DatanodeSimulationState {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatanodeSimulationState.class);
    public static final long CONTAINER_SIZE = (long)StorageUnit.GB.toBytes(5.0);
    private int targetContainersCount;
    private DatanodeDetails datanodeDetails;
    private boolean isRegistered = false;
    private long fullContainerReportDurationMs;
    private Map<InetSocketAddress, EndpointState> endpointStates = new HashMap<InetSocketAddress, EndpointState>();
    private Set<String> pipelines = new HashSet<String>();
    private Map<Long, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State> containers = new HashMap<Long, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State>();
    private volatile boolean readOnly = false;

    DatanodeSimulationState(DatanodeDetails datanodeDetails, long fullContainerReportDurationMs, List<InetSocketAddress> allEndpoints, int targetContainersCount) {
        this();
        this.datanodeDetails = datanodeDetails;
        this.fullContainerReportDurationMs = fullContainerReportDurationMs;
        this.initEndpointsState(allEndpoints);
        this.targetContainersCount = targetContainersCount;
    }

    DatanodeSimulationState() {
    }

    void initEndpointsState(List<InetSocketAddress> allEndpoints) {
        for (InetSocketAddress endpoint : allEndpoints) {
            this.endpointStates.put(endpoint, new EndpointState());
        }
    }

    public synchronized void ackHeartbeatResponse(StorageContainerDatanodeProtocolProtos.SCMHeartbeatResponseProto response) {
        block5: for (StorageContainerDatanodeProtocolProtos.SCMCommandProto command : response.getCommandsList()) {
            switch (command.getCommandType()) {
                case createPipelineCommand: {
                    StorageContainerDatanodeProtocolProtos.CreatePipelineCommandProto pipelineCmd = command.getCreatePipelineCommandProto();
                    if (!this.readOnly) {
                        this.pipelines.add(pipelineCmd.getPipelineID().getId());
                        continue block5;
                    }
                    LOGGER.info("Ignored pipeline creation for {}-{}", (Object)pipelineCmd.getType(), (Object)pipelineCmd.getFactor());
                    continue block5;
                }
                case closePipelineCommand: {
                    this.pipelines.remove(command.getClosePipelineCommandProto().getPipelineID().getId());
                    continue block5;
                }
                case closeContainerCommand: {
                    StorageContainerDatanodeProtocolProtos.CloseContainerCommandProto closeContainerCmd = command.getCloseContainerCommandProto();
                    this.closeContainer(closeContainerCmd.getContainerID());
                    continue block5;
                }
            }
            LOGGER.debug("Ignored command: {}", (Object)command.getCommandType());
        }
    }

    public synchronized StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto heartbeatRequest(InetSocketAddress endpoint, StorageContainerDatanodeProtocolProtos.LayoutVersionProto layoutInfo) throws IOException {
        StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.Builder builder = StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.newBuilder().setDatanodeDetails(this.datanodeDetails.getProtoBufMessage()).setDataNodeLayoutVersion(layoutInfo).setNodeReport(this.createNodeReport()).setPipelineReports(this.createPipelineReport());
        this.addContainerReport(endpoint, builder);
        return builder.build();
    }

    private void addContainerReport(InetSocketAddress endpoint, StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.Builder builder) {
        EndpointState state = this.endpointStates.get(endpoint);
        if (state.nextFullContainerReport.compareTo(Instant.now()) <= 0) {
            builder.setContainerReport(this.createFullContainerReport());
            if (state.nextFullContainerReport == Instant.MIN) {
                state.nextFullContainerReport = Instant.now().plusMillis(RandomUtils.secure().randomLong(1L, this.fullContainerReportDurationMs));
            } else {
                state.nextFullContainerReport = Instant.now().plusMillis(this.fullContainerReportDurationMs);
            }
            state.icr.clear();
        } else if (state.icr.getReportCount() > 0) {
            builder.addIncrementalContainerReport(state.icr.build());
            state.icr.clear();
        }
    }

    StorageContainerDatanodeProtocolProtos.ContainerReportsProto createFullContainerReport() {
        StorageContainerDatanodeProtocolProtos.ContainerReportsProto.Builder builder = StorageContainerDatanodeProtocolProtos.ContainerReportsProto.newBuilder();
        for (Map.Entry<Long, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State> entry : this.containers.entrySet()) {
            StorageContainerDatanodeProtocolProtos.ContainerReplicaProto container = StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.newBuilder().setContainerID(entry.getKey().longValue()).setReadCount(10000L).setWriteCount(10000L).setReadBytes(10000000L).setWriteBytes(5000000000L).setKeyCount(10000L).setUsed(5000000000L).setState(entry.getValue()).setBlockCommitSequenceId(1000L).setOriginNodeId(this.datanodeDetails.getUuidString()).setReplicaIndex(0).build();
            builder.addReports(container);
        }
        return builder.build();
    }

    StorageContainerDatanodeProtocolProtos.PipelineReportsProto createPipelineReport() {
        StorageContainerDatanodeProtocolProtos.PipelineReportsProto.Builder builder = StorageContainerDatanodeProtocolProtos.PipelineReportsProto.newBuilder();
        for (String pipelineId : this.pipelines) {
            builder.addPipelineReport(StorageContainerDatanodeProtocolProtos.PipelineReport.newBuilder().setPipelineID(HddsProtos.PipelineID.newBuilder().setId(pipelineId).build()).setIsLeader(true).build());
        }
        return builder.build();
    }

    StorageContainerDatanodeProtocolProtos.NodeReportProto createNodeReport() throws IOException {
        long capacity = (long)this.targetContainersCount * CONTAINER_SIZE;
        long used = this.readOnly ? capacity : CONTAINER_SIZE * (long)this.containers.size();
        StorageLocationReport storageLocationReport = StorageLocationReport.newBuilder().setStorageLocation("/tmp/unreal_storage").setId("simulated-storage-volume").setCapacity(capacity).setScmUsed(used).setRemaining(capacity - used).setStorageType(StorageType.DEFAULT).build();
        StorageLocationReport metaLocationReport = StorageLocationReport.newBuilder().setStorageLocation("/tmp/unreal_metadata").setId("simulated-storage-volume").setCapacity((long)StorageUnit.GB.toBytes(100.0)).setScmUsed((long)StorageUnit.GB.toBytes(50.0)).setRemaining((long)StorageUnit.GB.toBytes(50.0)).setStorageType(StorageType.DEFAULT).build();
        return StorageContainerDatanodeProtocolProtos.NodeReportProto.newBuilder().addStorageReport(storageLocationReport.getProtoBufMessage()).addMetadataStorageReport(metaLocationReport.getMetadataProtoBufMessage()).build();
    }

    public synchronized void newContainer(long containerId) {
        this.containers.put(containerId, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.OPEN);
        for (EndpointState state : this.endpointStates.values()) {
            state.icr.addReport(StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.newBuilder().setContainerID(containerId).setReadCount(10000L).setWriteCount(10000L).setReadBytes(10000000L).setWriteBytes(5000000000L).setKeyCount(10000L).setUsed(CONTAINER_SIZE).setState(StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.OPEN).setBlockCommitSequenceId(1000L).setOriginNodeId(this.datanodeDetails.getUuidString()).setReplicaIndex(0).build());
        }
    }

    public synchronized void closeContainer(Long containerID) {
        if (this.containers.containsKey(containerID)) {
            this.containers.put(containerID, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED);
            for (EndpointState state : this.endpointStates.values()) {
                state.icr.addReport(StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.newBuilder().setContainerID(containerID.longValue()).setReadCount(10000L).setWriteCount(10000L).setReadBytes(10000000L).setWriteBytes(5000000000L).setKeyCount(10000L).setUsed(5000000000L).setState(StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED).setBlockCommitSequenceId(1000L).setOriginNodeId(this.datanodeDetails.getUuidString()).setReplicaIndex(0).build());
            }
        } else {
            LOGGER.error("Unrecognized closeContainerCommand");
        }
    }

    @JsonSerialize(using=DatanodeDetailsSerializer.class)
    @JsonDeserialize(using=DatanodeDeserializer.class)
    public synchronized DatanodeDetails getDatanodeDetails() {
        return this.datanodeDetails;
    }

    public synchronized void setDatanodeDetails(DatanodeDetails datanodeDetails) {
        this.datanodeDetails = datanodeDetails;
    }

    public synchronized Set<String> getPipelines() {
        return this.pipelines;
    }

    public synchronized void setPipelines(Set<String> pipelines) {
        this.pipelines = pipelines;
    }

    public synchronized boolean isRegistered() {
        return this.isRegistered;
    }

    public synchronized void setRegistered(boolean registered) {
        this.isRegistered = registered;
    }

    public synchronized Map<Long, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State> getContainers() {
        return this.containers;
    }

    public synchronized void setContainers(Map<Long, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State> containers) {
        this.containers = containers;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public long getFullContainerReportDurationMs() {
        return this.fullContainerReportDurationMs;
    }

    public void setFullContainerReportDurationMs(long fullContainerReportDurationMs) {
        this.fullContainerReportDurationMs = fullContainerReportDurationMs;
    }

    public int getTargetContainersCount() {
        return this.targetContainersCount;
    }

    public void setTargetContainersCount(int targetContainersCount) {
        this.targetContainersCount = targetContainersCount;
    }

    private static class EndpointState {
        private final StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto.Builder icr = StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto.newBuilder();
        private Instant nextFullContainerReport = Instant.MIN;

        private EndpointState() {
        }
    }

    private static class DatanodeDeserializer
    extends StdDeserializer<DatanodeDetails> {
        protected DatanodeDeserializer() {
            super(DatanodeDetails.class);
        }

        public DatanodeDetails deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            byte[] binaryValue = p.getBinaryValue();
            return DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)HddsProtos.DatanodeDetailsProto.parseFrom((byte[])binaryValue));
        }
    }

    private static class DatanodeDetailsSerializer
    extends StdSerializer<DatanodeDetails> {
        protected DatanodeDetailsSerializer() {
            super(DatanodeDetails.class);
        }

        public void serialize(DatanodeDetails value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeBinary(value.getProtoBufMessage().toByteArray());
        }
    }
}

