/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.pipeline;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.cli.pipeline.FilterPipelineOptions;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import picocli.CommandLine;

@CommandLine.Command(name="close", description={"Close pipeline"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class ClosePipelineSubcommand
extends ScmSubcommand {
    @CommandLine.ArgGroup(multiplicity="1")
    private CloseOptionGroup closeOption;
    @CommandLine.Mixin
    private final FilterPipelineOptions filterOptions = new FilterPipelineOptions();

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        if (!Strings.isNullOrEmpty((String)this.closeOption.pipelineId)) {
            if (this.filterOptions.getReplicationFilter().isPresent()) {
                throw new IllegalArgumentException("Replication filters can only be used with --all");
            }
            scmClient.closePipeline(HddsProtos.PipelineID.newBuilder().setId(this.closeOption.pipelineId).build());
        } else if (this.closeOption.closeAll) {
            Optional<Predicate<? super Pipeline>> replicationFilter = this.filterOptions.getReplicationFilter();
            ArrayList<Pipeline> pipelineList = new ArrayList<Pipeline>();
            Predicate predicate = replicationFilter.orElse(null);
            List pipelines = scmClient.listPipelines();
            if (predicate == null) {
                for (Pipeline pipeline2 : pipelines) {
                    if (pipeline2.getPipelineState() == Pipeline.PipelineState.CLOSED) continue;
                    pipelineList.add(pipeline2);
                }
            } else {
                for (Pipeline pipeline3 : pipelines) {
                    boolean filterPassed = predicate.test(pipeline3);
                    if (pipeline3.getPipelineState() == Pipeline.PipelineState.CLOSED || !filterPassed) continue;
                    pipelineList.add(pipeline3);
                }
            }
            System.out.println("Sending close command for " + pipelineList.size() + " pipelines...");
            pipelineList.forEach(pipeline -> {
                try {
                    scmClient.closePipeline(HddsProtos.PipelineID.newBuilder().setId(pipeline.getId().getId().toString()).build());
                }
                catch (IOException e) {
                    System.err.println("Error closing pipeline: " + pipeline.getId() + ", cause: " + e.getMessage());
                }
            });
        }
    }

    private static class CloseOptionGroup {
        @CommandLine.Parameters(description={"ID of the pipeline to close"})
        private String pipelineId;
        @CommandLine.Option(names={"--all"}, description={"Close all pipelines"})
        private boolean closeAll;

        private CloseOptionGroup() {
        }
    }
}

