/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.container.upgrade;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Date;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.MutableVolumeSet;
import org.apache.hadoop.ozone.container.common.volume.StorageVolume;

public final class UpgradeUtils {
    private UpgradeUtils() {
    }

    public static MutableVolumeSet getHddsVolumes(OzoneConfiguration conf, StorageVolume.VolumeType volumeType, String dnUuid) throws IOException {
        return new MutableVolumeSet(dnUuid, (ConfigurationSource)conf, null, volumeType, null);
    }

    public static DatanodeDetails getDatanodeDetails(OzoneConfiguration conf) throws IOException {
        String idFilePath = HddsServerUtil.getDatanodeIdFilePath((ConfigurationSource)conf);
        Preconditions.checkNotNull((Object)idFilePath);
        File idFile = new File(idFilePath);
        Preconditions.checkState((boolean)idFile.exists(), (Object)("Datanode id file: " + idFilePath + " not exists"));
        return ContainerUtils.readDatanodeDetailsFrom((File)idFile);
    }

    public static File getContainerDBPath(HddsVolume volume) {
        return new File(volume.getDbParentDir(), "container.db");
    }

    public static File getVolumeUpgradeCompleteFile(HddsVolume volume) {
        return new File(volume.getHddsRootDir(), "upgrade.complete");
    }

    public static File getVolumeUpgradeLockFile(HddsVolume volume) {
        return new File(volume.getHddsRootDir(), "upgrade.lock");
    }

    public static boolean createFile(File file) throws IOException {
        Date date = new Date();
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            writer.write(date.toString());
        }
        return file.exists();
    }
}

