/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocol.commands;

import org.apache.hadoop.hdds.scm.command.CommandStatusReportHandler;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.server.events.Event;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventWatcher;
import org.apache.hadoop.ozone.lease.LeaseManager;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetriableDatanodeEventWatcher<T extends CommandStatusReportHandler.CommandStatusEvent>
extends EventWatcher<CommandForDatanode, T> {
    private static final Logger LOG = LoggerFactory.getLogger(RetriableDatanodeEventWatcher.class);

    public RetriableDatanodeEventWatcher(Event<CommandForDatanode> startEvent, Event<T> completionEvent, LeaseManager<Long> leaseManager) {
        super(startEvent, completionEvent, leaseManager);
    }

    protected void onTimeout(EventPublisher publisher, CommandForDatanode payload) {
        LOG.info("RetriableDatanodeCommand type={} with id={} timed out. Retrying.", (Object)payload.getCommand().getType(), (Object)payload.getId());
        publisher.fireEvent(SCMEvents.RETRIABLE_DATANODE_COMMAND, (Object)payload);
    }

    protected void onFinished(EventPublisher publisher, CommandForDatanode payload) {
    }
}

