/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import java.io.IOException;
import org.apache.hadoop.hdds.scm.ha.SCMHADBTransactionBuffer;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServer;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMHATransactionBufferMonitorTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(SCMHATransactionBufferMonitorTask.class);
    private final SCMRatisServer server;
    private final SCMHADBTransactionBuffer transactionBuffer;
    private final long flushInterval;

    public SCMHATransactionBufferMonitorTask(SCMHADBTransactionBuffer transactionBuffer, SCMRatisServer server, long flushInterval) {
        this.flushInterval = flushInterval;
        this.transactionBuffer = transactionBuffer;
        this.server = server;
    }

    @Override
    public void run() {
        if (this.transactionBuffer.shouldFlush(this.flushInterval)) {
            LOG.debug("Running TransactionFlushTask");
            SnapshotInfo lastSnapshot = this.transactionBuffer.getLatestSnapshotRef().getAndSet(null);
            try {
                this.server.triggerSnapshot();
            }
            catch (IOException e) {
                LOG.error("Snapshot request is failed", (Throwable)e);
            }
            finally {
                this.transactionBuffer.getLatestSnapshotRef().compareAndSet(null, lastSnapshot);
            }
        }
    }
}

