/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.UUID;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutVersionManager;
import org.apache.hadoop.ozone.common.Storage;

public class SCMStorageConfig
extends Storage {
    public SCMStorageConfig(OzoneConfiguration conf) throws IOException {
        super(HddsProtos.NodeType.SCM, ServerUtils.getScmDbDir((ConfigurationSource)conf), "scm", SCMStorageConfig.getInitLayoutVersion((OzoneConfiguration)conf, (String)"hdds.scm.init.default.layout.version", HDDSLayoutVersionManager::maxLayoutVersion));
    }

    public SCMStorageConfig(HddsProtos.NodeType type, File root, String sdName) throws IOException {
        super(type, root, sdName, HDDSLayoutVersionManager.maxLayoutVersion());
    }

    public void setScmId(String scmId) throws IOException {
        if (this.getState() == Storage.StorageState.INITIALIZED) {
            throw new IOException("SCM is already initialized.");
        }
        this.getStorageInfo().setProperty("scmUuid", scmId);
    }

    public void setSCMHAFlag(boolean flag) {
        if (!this.isSCMHAEnabled()) {
            this.getStorageInfo().setProperty("scmHA", Boolean.toString(flag));
        }
    }

    public String getScmId() {
        return this.getStorageInfo().getProperty("scmUuid");
    }

    public boolean isSCMHAEnabled() {
        return Boolean.valueOf(this.getStorageInfo().getProperty("scmHA"));
    }

    protected Properties getNodeProperties() {
        String scmId = this.getScmId();
        if (scmId == null) {
            scmId = UUID.randomUUID().toString();
        }
        Properties scmProperties = new Properties();
        scmProperties.setProperty("scmUuid", scmId);
        return scmProperties;
    }

    public void setScmCertSerialId(String certSerialId) throws IOException {
        this.getStorageInfo().setProperty("scmCertSerialId", certSerialId);
    }

    public String getScmCertSerialId() {
        return this.getStorageInfo().getProperty("scmCertSerialId");
    }

    public void setPrimaryScmNodeId(String scmId) throws IOException {
        this.getStorageInfo().setProperty("primaryScmNodeId", scmId);
    }

    public String getPrimaryScmNodeId() {
        return this.getStorageInfo().getProperty("primaryScmNodeId");
    }

    public boolean checkPrimarySCMIdInitialized() {
        return this.getPrimaryScmNodeId() != null;
    }
}

