/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline.leader.choose.algorithms;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateManager;
import org.apache.hadoop.hdds.scm.pipeline.leader.choose.algorithms.LeaderChoosePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinLeaderCountChoosePolicy
extends LeaderChoosePolicy {
    private static final Logger LOG = LoggerFactory.getLogger(MinLeaderCountChoosePolicy.class);

    public MinLeaderCountChoosePolicy(NodeManager nodeManager, PipelineStateManager pipelineStateManager) {
        super(nodeManager, pipelineStateManager);
    }

    @Override
    public DatanodeDetails chooseLeader(List<DatanodeDetails> dns) {
        Map<DatanodeDetails, Integer> suggestedLeaderCount = this.getSuggestedLeaderCount(dns, this.getNodeManager(), this.getPipelineStateManager());
        int minLeaderCount = Integer.MAX_VALUE;
        DatanodeDetails suggestedLeader = null;
        for (Map.Entry<DatanodeDetails, Integer> entry : suggestedLeaderCount.entrySet()) {
            if (entry.getValue() >= minLeaderCount) continue;
            minLeaderCount = entry.getValue();
            suggestedLeader = entry.getKey();
        }
        return suggestedLeader;
    }

    private Map<DatanodeDetails, Integer> getSuggestedLeaderCount(List<DatanodeDetails> dns, NodeManager nodeManager, PipelineStateManager pipelineStateManager) {
        HashMap<DatanodeDetails, Integer> suggestedLeaderCount = new HashMap<DatanodeDetails, Integer>();
        for (DatanodeDetails dn : dns) {
            suggestedLeaderCount.put(dn, 0);
            Set<PipelineID> pipelineIDSet = nodeManager.getPipelines(dn);
            for (PipelineID pipelineID : pipelineIDSet) {
                try {
                    Pipeline pipeline = pipelineStateManager.getPipeline(pipelineID);
                    if (pipeline.isClosed() || !dn.getUuid().equals(pipeline.getSuggestedLeaderId())) continue;
                    suggestedLeaderCount.put(dn, (Integer)suggestedLeaderCount.get(dn) + 1);
                }
                catch (PipelineNotFoundException e) {
                    LOG.debug("Pipeline not found in pipeline state manager : {}", (Object)pipelineID, (Object)e);
                }
            }
        }
        return suggestedLeaderCount;
    }
}

