/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManagerMXBean;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.utils.db.Table;

public interface PipelineManager
extends Closeable,
PipelineManagerMXBean {
    public Pipeline createPipeline(ReplicationConfig var1) throws IOException;

    public Pipeline createPipeline(ReplicationConfig var1, List<DatanodeDetails> var2, List<DatanodeDetails> var3) throws IOException;

    public Pipeline buildECPipeline(ReplicationConfig var1, List<DatanodeDetails> var2, List<DatanodeDetails> var3) throws IOException;

    public void addEcPipeline(Pipeline var1) throws IOException;

    public Pipeline createPipeline(ReplicationConfig var1, List<DatanodeDetails> var2);

    public Pipeline createPipelineForRead(ReplicationConfig var1, Set<ContainerReplica> var2);

    public Pipeline getPipeline(PipelineID var1) throws PipelineNotFoundException;

    public boolean containsPipeline(PipelineID var1);

    public List<Pipeline> getPipelines();

    public List<Pipeline> getPipelines(ReplicationConfig var1);

    public List<Pipeline> getPipelines(ReplicationConfig var1, Pipeline.PipelineState var2);

    public List<Pipeline> getPipelines(ReplicationConfig var1, Pipeline.PipelineState var2, Collection<DatanodeDetails> var3, Collection<PipelineID> var4);

    public int getPipelineCount(ReplicationConfig var1, Pipeline.PipelineState var2);

    public void addContainerToPipeline(PipelineID var1, ContainerID var2) throws IOException;

    public void addContainerToPipelineSCMStart(PipelineID var1, ContainerID var2) throws IOException;

    public void removeContainerFromPipeline(PipelineID var1, ContainerID var2) throws IOException;

    public NavigableSet<ContainerID> getContainersInPipeline(PipelineID var1) throws IOException;

    public int getNumberOfContainers(PipelineID var1) throws IOException;

    public void openPipeline(PipelineID var1) throws IOException;

    @Deprecated
    public void closePipeline(Pipeline var1, boolean var2) throws IOException;

    public void closePipeline(PipelineID var1) throws IOException;

    public void deletePipeline(PipelineID var1) throws IOException;

    public void closeStalePipelines(DatanodeDetails var1);

    public void scrubPipelines() throws IOException;

    public void startPipelineCreator();

    public void triggerPipelineCreation();

    public void incNumBlocksAllocatedMetric(PipelineID var1);

    public int minHealthyVolumeNum(Pipeline var1);

    public int minPipelineLimit(Pipeline var1);

    public void activatePipeline(PipelineID var1) throws IOException;

    public void deactivatePipeline(PipelineID var1) throws IOException;

    default public void waitPipelineReady(PipelineID pipelineID, long timeout) throws IOException {
    }

    default public Pipeline waitOnePipelineReady(Collection<PipelineID> pipelineIDs, long timeout) throws IOException {
        return null;
    }

    public boolean getSafeModeStatus();

    public void reinitialize(Table<PipelineID, Pipeline> var1) throws IOException;

    public void freezePipelineCreation();

    public void resumePipelineCreation();

    public boolean isPipelineCreationFrozen();

    public void acquireReadLock();

    public void releaseReadLock();

    public void acquireWriteLock();

    public void releaseWriteLock();
}

