/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ClassUtils;
import org.apache.hadoop.hdds.utils.db.BooleanCodec;
import org.apache.hadoop.hdds.utils.db.ByteArrayCodec;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.IntegerCodec;
import org.apache.hadoop.hdds.utils.db.LongCodec;
import org.apache.hadoop.hdds.utils.db.StringCodec;

public final class CodecRegistry {
    private final CodecMap valueCodecs;

    public static Builder newBuilder() {
        return new Builder().addCodec(String.class, StringCodec.get()).addCodec(Long.class, LongCodec.get()).addCodec(Integer.class, IntegerCodec.get()).addCodec(byte[].class, ByteArrayCodec.get()).addCodec(Boolean.class, BooleanCodec.get());
    }

    private CodecRegistry(Map<Class<?>, Codec<?>> valueCodecs) {
        this.valueCodecs = new CodecMap(valueCodecs);
    }

    public <T> T asObject(byte[] rawData, Class<T> format) throws IOException {
        if (rawData == null) {
            return null;
        }
        return (T)this.getCodecFromClass(format).fromPersistedFormat(rawData);
    }

    public <T> T copyObject(T object, Class<T> format) {
        if (object == null) {
            return null;
        }
        return (T)this.getCodecFromClass(format).copyObject(object);
    }

    public <T> byte[] asRawData(T object) throws IOException {
        Preconditions.checkNotNull(object, (Object)"Null value shouldn't be persisted in the database");
        Codec codec = this.getCodec(object);
        return codec.toPersistedFormat(object);
    }

    public <SUPER, T extends SUPER> Codec<SUPER> getCodec(T object) {
        Class<?> clazz = object.getClass();
        Codec<?> codec = this.valueCodecs.get(clazz);
        if (codec == null) {
            codec = this.valueCodecs.get(ClassUtils.getAllSuperclasses(clazz));
        }
        if (codec == null) {
            codec = this.valueCodecs.get(ClassUtils.getAllInterfaces(clazz));
        }
        if (codec != null) {
            return codec;
        }
        throw new IllegalStateException("Codec is not registered for type: " + clazz);
    }

    <T> Codec<T> getCodecFromClass(Class<T> clazz) {
        Codec<T> codec = this.valueCodecs.get(clazz);
        if (codec != null) {
            return codec;
        }
        throw new IllegalStateException("Codec is not registered for type: " + clazz);
    }

    public static class Builder {
        private final Map<Class<?>, Codec<?>> codecs = new HashMap();

        public <T> Builder addCodec(Class<T> type, Codec<T> codec) {
            this.codecs.put(type, codec);
            return this;
        }

        public CodecRegistry build() {
            return new CodecRegistry(this.codecs);
        }
    }

    private static final class CodecMap {
        private final Map<Class<?>, Codec<?>> map;

        private CodecMap(Map<Class<?>, Codec<?>> map) {
            this.map = Collections.unmodifiableMap(new HashMap(map));
        }

        <T> Codec<T> get(Class<T> clazz) {
            Objects.requireNonNull(clazz, "clazz == null");
            Codec<?> codec = this.map.get(clazz);
            return codec;
        }

        Codec<?> get(List<Class<?>> classes) {
            for (Class<?> clazz : classes) {
                Codec<?> codec = this.get(clazz);
                if (codec == null) continue;
                return codec;
            }
            return null;
        }
    }
}

