/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db.managed;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.hdds.utils.db.managed.ManagedDBOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedObject;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksObjectUtils;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.DBOptions;
import org.rocksdb.LiveFileMetaData;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedRocksDB
extends ManagedObject<RocksDB> {
    public static final Class<RocksDB> ORIGINAL_CLASS = RocksDB.class;
    public static final int NOT_FOUND = -1;
    static final Logger LOG = LoggerFactory.getLogger(ManagedRocksDB.class);

    ManagedRocksDB(RocksDB original) {
        super(original);
    }

    public static ManagedRocksDB openReadOnly(ManagedDBOptions options, String path, List<ColumnFamilyDescriptor> columnFamilyDescriptors, List<ColumnFamilyHandle> columnFamilyHandles) throws RocksDBException {
        return new ManagedRocksDB(RocksDB.openReadOnly((DBOptions)options, (String)path, columnFamilyDescriptors, columnFamilyHandles));
    }

    public static ManagedRocksDB openReadOnly(String path, List<ColumnFamilyDescriptor> columnFamilyDescriptors, List<ColumnFamilyHandle> columnFamilyHandles) throws RocksDBException {
        return new ManagedRocksDB(RocksDB.openReadOnly((String)path, columnFamilyDescriptors, columnFamilyHandles));
    }

    public static ManagedRocksDB open(DBOptions options, String path, List<ColumnFamilyDescriptor> columnFamilyDescriptors, List<ColumnFamilyHandle> columnFamilyHandles) throws RocksDBException {
        return new ManagedRocksDB(RocksDB.open((DBOptions)options, (String)path, columnFamilyDescriptors, columnFamilyHandles));
    }

    public static ManagedRocksDB open(String path, List<ColumnFamilyDescriptor> columnFamilyDescriptors, List<ColumnFamilyHandle> columnFamilyHandles) throws RocksDBException {
        return new ManagedRocksDB(RocksDB.open((String)path, columnFamilyDescriptors, columnFamilyHandles));
    }

    public void deleteFile(LiveFileMetaData fileToBeDeleted) throws RocksDBException, IOException {
        String sstFileName = fileToBeDeleted.fileName();
        ((RocksDB)this.get()).deleteFile(sstFileName);
        File file = new File(fileToBeDeleted.path(), fileToBeDeleted.fileName());
        ManagedRocksObjectUtils.waitForFileDelete(file, Duration.ofSeconds(60L));
    }

    public static Map<String, LiveFileMetaData> getLiveMetadataForSSTFiles(RocksDB db) {
        return db.getLiveFilesMetaData().stream().collect(Collectors.toMap(liveFileMetaData -> FilenameUtils.getBaseName((String)liveFileMetaData.fileName()), liveFileMetaData -> liveFileMetaData));
    }

    public Map<String, LiveFileMetaData> getLiveMetadataForSSTFiles() {
        return ManagedRocksDB.getLiveMetadataForSSTFiles((RocksDB)this.get());
    }
}

