/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocol.commands;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;

public class ReconcileContainerCommand
extends SCMCommand<StorageContainerDatanodeProtocolProtos.ReconcileContainerCommandProto> {
    private final Set<DatanodeDetails> peerDatanodes;

    public ReconcileContainerCommand(long containerID, Set<DatanodeDetails> peerDatanodes) {
        super(containerID);
        this.peerDatanodes = peerDatanodes;
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.reconcileContainerCommand;
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.ReconcileContainerCommandProto getProto() {
        StorageContainerDatanodeProtocolProtos.ReconcileContainerCommandProto.Builder builder = StorageContainerDatanodeProtocolProtos.ReconcileContainerCommandProto.newBuilder().setContainerID(this.getId());
        for (DatanodeDetails dd : this.peerDatanodes) {
            builder.addPeers(dd.getProtoBufMessage());
        }
        return builder.build();
    }

    public Set<DatanodeDetails> getPeerDatanodes() {
        return this.peerDatanodes;
    }

    public long getContainerID() {
        return this.getId();
    }

    public static ReconcileContainerCommand getFromProtobuf(StorageContainerDatanodeProtocolProtos.ReconcileContainerCommandProto protoMessage) {
        Preconditions.checkNotNull((Object)protoMessage);
        List peers = protoMessage.getPeersList();
        Set<DatanodeDetails> peerNodes = !peers.isEmpty() ? peers.stream().map(DatanodeDetails::getFromProtoBuf).collect(Collectors.toSet()) : Collections.emptySet();
        return new ReconcileContainerCommand(protoMessage.getContainerID(), peerNodes);
    }

    @Override
    public String toString() {
        return this.getType() + ": containerId=" + this.getContainerID() + ", peerNodes=" + this.peerDatanodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReconcileContainerCommand that = (ReconcileContainerCommand)o;
        return this.getContainerID() == that.getContainerID();
    }

    public int hashCode() {
        return Objects.hash(this.getContainerID());
    }
}

