/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.ozone.container.replication.AbstractReplicationTask;
import org.apache.hadoop.ozone.container.replication.ContainerReplicator;
import org.apache.hadoop.ozone.protocol.commands.ReplicateContainerCommand;

public class ReplicationTask
extends AbstractReplicationTask {
    private final ReplicateContainerCommand cmd;
    private final ContainerReplicator replicator;
    private final String debugString;
    private long transferredBytes;

    public ReplicationTask(ReplicateContainerCommand cmd, ContainerReplicator replicator) {
        super(cmd.getContainerID(), cmd.getDeadline(), cmd.getTerm());
        this.setPriority(cmd.getPriority());
        this.cmd = cmd;
        this.replicator = replicator;
        if (cmd.getTargetDatanode() != null) {
            this.setShouldOnlyRunOnInServiceDatanodes(false);
        }
        this.debugString = cmd.toString();
    }

    protected ReplicationTask(long containerId, List<DatanodeDetails> sources, ContainerReplicator replicator) {
        this(ReplicateContainerCommand.fromSources(containerId, sources), replicator);
    }

    @Override
    public String getMetricName() {
        return "ContainerReplications";
    }

    @Override
    public String getMetricDescriptionSegment() {
        return "container replications";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationTask that = (ReplicationTask)o;
        return this.getContainerId() == that.getContainerId() && Objects.equals(this.getTarget(), that.getTarget());
    }

    public int hashCode() {
        return Objects.hash(this.getContainerId(), this.getTarget());
    }

    @Override
    public long getContainerId() {
        return this.cmd.getContainerID();
    }

    public List<DatanodeDetails> getSources() {
        return this.cmd.getSourceDatanodes();
    }

    @Override
    protected Object getCommandForDebug() {
        return this.debugString;
    }

    @Override
    public String toString() {
        String str = super.toString();
        if (this.transferredBytes > 0L) {
            str = str + ", transferred " + this.transferredBytes + " bytes";
        }
        return str;
    }

    public long getTransferredBytes() {
        return this.transferredBytes;
    }

    public void setTransferredBytes(long transferredBytes) {
        this.transferredBytes = transferredBytes;
    }

    DatanodeDetails getTarget() {
        return this.cmd.getTargetDatanode();
    }

    @Override
    public void runTask() {
        this.replicator.replicate(this);
    }
}

