/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.impl;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.hdds.ratis.RatisHelper;
import org.apache.hadoop.ozone.container.keyvalue.impl.KeyValueStreamDataChannel;
import org.apache.ratis.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.ratis.thirdparty.io.netty.buffer.Unpooled;
import org.apache.ratis.util.ReferenceCountedObject;
import org.slf4j.Logger;

class Buffers {
    private final Deque<ReferenceCountedObject<ByteBuffer>> deque = new LinkedList<ReferenceCountedObject<ByteBuffer>>();
    private final int max;
    private int length;

    Buffers(int max) {
        this.max = max;
    }

    private boolean isExtra(int n) {
        return this.length - n >= this.max;
    }

    private boolean hasExtraBuffer() {
        return Optional.ofNullable(this.deque.peek()).map(ReferenceCountedObject::get).filter(b -> this.isExtra(b.remaining())).isPresent();
    }

    Iterable<ReferenceCountedObject<ByteBuffer>> offer(ReferenceCountedObject<ByteBuffer> ref) {
        ByteBuffer buffer = (ByteBuffer)ref.retain();
        KeyValueStreamDataChannel.LOG.debug("offer {}", (Object)buffer);
        boolean offered = this.deque.offer(ref);
        Preconditions.checkState((boolean)offered, (Object)"Failed to offer");
        this.length += buffer.remaining();
        return () -> new Iterator<ReferenceCountedObject<ByteBuffer>>(){

            @Override
            public boolean hasNext() {
                return Buffers.this.hasExtraBuffer();
            }

            @Override
            public ReferenceCountedObject<ByteBuffer> next() {
                ReferenceCountedObject<ByteBuffer> polled = Buffers.this.poll();
                Buffers.this.length -= ((ByteBuffer)polled.get()).remaining();
                Preconditions.checkState((Buffers.this.length >= Buffers.this.max ? 1 : 0) != 0);
                return polled;
            }
        };
    }

    ReferenceCountedObject<ByteBuffer> poll() {
        ReferenceCountedObject<ByteBuffer> polled = Objects.requireNonNull(this.deque.poll());
        RatisHelper.debug((ByteBuffer)((ByteBuffer)polled.get()), (String)"polled", (Logger)KeyValueStreamDataChannel.LOG);
        return polled;
    }

    ReferenceCountedObject<ByteBuf> pollAll() {
        Preconditions.checkState((!this.deque.isEmpty() ? 1 : 0) != 0, (Object)"The deque is empty");
        ByteBuffer[] array = new ByteBuffer[this.deque.size()];
        ArrayList<ReferenceCountedObject<ByteBuffer>> refs = new ArrayList<ReferenceCountedObject<ByteBuffer>>(this.deque.size());
        for (int i = 0; i < array.length; ++i) {
            ReferenceCountedObject<ByteBuffer> ref = this.poll();
            refs.add(ref);
            array[i] = (ByteBuffer)ref.get();
        }
        ByteBuf buf = Unpooled.wrappedBuffer((ByteBuffer[])array).asReadOnly();
        return ReferenceCountedObject.wrap((Object)buf, () -> {}, () -> {
            buf.release();
            refs.forEach(ReferenceCountedObject::release);
        });
    }

    void cleanUpAll() {
        while (!this.deque.isEmpty()) {
            this.poll().release();
        }
    }
}

