/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import org.apache.hadoop.hdds.fs.SpaceUsageSource;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;

@Metrics(about="Ozone Volume Information Metrics", context="ozone")
public class VolumeInfoMetrics
implements MetricsSource {
    private static final String SOURCE_BASENAME = VolumeInfoMetrics.class.getSimpleName();
    private static final MetricsInfo CAPACITY = Interns.info((String)"Capacity", (String)"Capacity");
    private static final MetricsInfo AVAILABLE = Interns.info((String)"Available", (String)"Available Space");
    private static final MetricsInfo USED = Interns.info((String)"Used", (String)"Used Space");
    private static final MetricsInfo RESERVED = Interns.info((String)"Reserved", (String)"Reserved Space");
    private static final MetricsInfo TOTAL_CAPACITY = Interns.info((String)"TotalCapacity", (String)"Total Capacity");
    private final MetricsRegistry registry;
    private final String metricsSourceName;
    private final HddsVolume volume;
    @Metric(value={"Returns the RocksDB compact times of the Volume"})
    private MutableRate dbCompactLatency;
    @Metric(value={"Volume reserved space crosses reserved usages limit"})
    private MutableGaugeInt reservedCrossesLimit;
    @Metric(value={"Volume available space is insufficient"})
    private MutableGaugeInt availableSpaceInsufficient;
    @Metric(value={"Number of times the volume is scanned"})
    private MutableCounterLong numScans;
    @Metric(value={"Number of scans skipped for the volume"})
    private MutableCounterLong numScansSkipped;

    public VolumeInfoMetrics(String identifier, HddsVolume volume) {
        this.volume = volume;
        this.metricsSourceName = SOURCE_BASENAME + '-' + identifier;
        this.registry = new MetricsRegistry(this.metricsSourceName);
        this.init();
    }

    public void init() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.register(this.metricsSourceName, "Volume Info Statistics", (Object)this);
    }

    public void unregister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(this.metricsSourceName);
    }

    @Metric(value={"Metric to return the Storage Type"})
    public String getStorageType() {
        return this.volume.getStorageType().toString();
    }

    @Metric(value={"Returns the Directory name for the volume"})
    public String getStorageDirectory() {
        return this.volume.getStorageDir().toString();
    }

    @Metric(value={"Return the DataNode UID for the respective volume"})
    public String getDatanodeUuid() {
        return this.volume.getDatanodeUuid();
    }

    @Metric(value={"Return the Layout Version for the volume"})
    public int getLayoutVersion() {
        return this.volume.getLayoutVersion();
    }

    @Metric(value={"Returns the Volume State"})
    public String getVolumeState() {
        return this.volume.getStorageState().name();
    }

    @Metric(value={"Returns the Volume Type"})
    public String getVolumeType() {
        return this.volume.getType().name();
    }

    @Metric(value={"Returns the Committed bytes of the Volume"})
    public long getCommitted() {
        return this.volume.getCommittedBytes();
    }

    public void dbCompactTimesNanoSecondsIncr(long time) {
        this.dbCompactLatency.add(time);
    }

    public int getAvailableSpaceInsufficient() {
        return this.availableSpaceInsufficient.value();
    }

    public void setAvailableSpaceInsufficient(boolean isInSufficient) {
        if (isInSufficient) {
            this.availableSpaceInsufficient.set(1);
        } else {
            this.availableSpaceInsufficient.set(0);
        }
    }

    public int getReservedCrossesLimit() {
        return this.reservedCrossesLimit.value();
    }

    public void setReservedCrossesLimit(boolean isLimitCrossed) {
        if (isLimitCrossed) {
            this.reservedCrossesLimit.set(1);
        } else {
            this.reservedCrossesLimit.set(0);
        }
    }

    @Metric(value={"Returns the Container Count of the Volume"})
    public long getContainers() {
        return this.volume.getContainers();
    }

    public long getNumScans() {
        return this.numScans.value();
    }

    public void incNumScans() {
        this.numScans.incr();
    }

    public long getNumScansSkipped() {
        return this.numScansSkipped.value();
    }

    public void incNumScansSkipped() {
        this.numScansSkipped.incr();
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder builder = collector.addRecord(this.metricsSourceName);
        this.registry.snapshot(builder, all);
        this.volume.getVolumeUsage().ifPresent(volumeUsage -> {
            SpaceUsageSource usage = volumeUsage.getCurrentUsage();
            long reserved = volumeUsage.getReservedInBytes();
            builder.addGauge(CAPACITY, usage.getCapacity()).addGauge(AVAILABLE, usage.getAvailable()).addGauge(USED, usage.getUsedSpace()).addGauge(RESERVED, reserved).addGauge(TOTAL_CAPACITY, usage.getCapacity() + reserved);
        });
    }
}

