/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ozoneimpl;

import java.time.Duration;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;
import org.apache.hadoop.hdds.conf.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigGroup(prefix="hdds.container.scrub")
public class ContainerScannerConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerScannerConfiguration.class);
    public static final String HDDS_CONTAINER_SCRUB_ENABLED = "hdds.container.scrub.enabled";
    public static final String HDDS_CONTAINER_SCRUB_DEV_DATA_ENABLED = "hdds.container.scrub.dev.data.enabled";
    public static final String HDDS_CONTAINER_SCRUB_DEV_METADATA_ENABLED = "hdds.container.scrub.dev.metadata.enabled";
    public static final String METADATA_SCAN_INTERVAL_KEY = "hdds.container.scrub.metadata.scan.interval";
    public static final String DATA_SCAN_INTERVAL_KEY = "hdds.container.scrub.data.scan.interval";
    public static final String VOLUME_BYTES_PER_SECOND_KEY = "hdds.container.scrub.volume.bytes.per.second";
    public static final String ON_DEMAND_VOLUME_BYTES_PER_SECOND_KEY = "hdds.container.scrub.on.demand.volume.bytes.per.second";
    public static final String CONTAINER_SCAN_MIN_GAP = "hdds.container.scrub.min.gap";
    static final long CONTAINER_SCAN_MIN_GAP_DEFAULT = Duration.ofMinutes(15L).toMillis();
    public static final long METADATA_SCAN_INTERVAL_DEFAULT = Duration.ofHours(3L).toMillis();
    public static final long DATA_SCAN_INTERVAL_DEFAULT = Duration.ofDays(7L).toMillis();
    public static final long BANDWIDTH_PER_VOLUME_DEFAULT = 0x500000L;
    public static final long ON_DEMAND_BANDWIDTH_PER_VOLUME_DEFAULT = 0x500000L;
    @Config(key="enabled", type=ConfigType.BOOLEAN, defaultValue="true", tags={ConfigTag.STORAGE}, description="Config parameter to enable all container scanners.")
    private boolean enabled = true;
    @Config(key="dev.data.scan.enabled", type=ConfigType.BOOLEAN, defaultValue="true", tags={ConfigTag.STORAGE}, description="Can be used to disable the background container data scanner for developer testing purposes.")
    private boolean dataScanEnabled = true;
    @Config(key="dev.metadata.scan.enabled", type=ConfigType.BOOLEAN, defaultValue="true", tags={ConfigTag.STORAGE}, description="Can be used to disable the background container metadata scanner for developer testing purposes.")
    private boolean metadataScanEnabled = true;
    @Config(key="metadata.scan.interval", type=ConfigType.TIME, defaultValue="3h", tags={ConfigTag.STORAGE}, description="Config parameter define time interval between two metadata scans by container scanner. Unit could be defined with postfix (ns,ms,s,m,h,d).")
    private long metadataScanInterval = METADATA_SCAN_INTERVAL_DEFAULT;
    @Config(key="data.scan.interval", type=ConfigType.TIME, defaultValue="7d", tags={ConfigTag.STORAGE}, description="Minimum time interval between two iterations of container data scanning.  If an iteration takes less time than this, the scanner will wait before starting the next iteration. Unit could be defined with postfix (ns,ms,s,m,h,d).")
    private long dataScanInterval = DATA_SCAN_INTERVAL_DEFAULT;
    @Config(key="volume.bytes.per.second", type=ConfigType.LONG, defaultValue="5242880", tags={ConfigTag.STORAGE}, description="Config parameter to throttle I/O bandwidth used by scanner per volume.")
    private long bandwidthPerVolume = 0x500000L;
    @Config(key="on.demand.volume.bytes.per.second", type=ConfigType.LONG, defaultValue="5242880", tags={ConfigTag.STORAGE}, description="Config parameter to throttle I/O bandwidth used by the demand container scanner per volume.")
    private long onDemandBandwidthPerVolume = 0x500000L;
    @Config(key="min.gap", defaultValue="15m", type=ConfigType.TIME, tags={ConfigTag.DATANODE}, description="The minimum gap between two successive scans of the same container. Unit could be defined with postfix (ns,ms,s,m,h,d).")
    private long containerScanMinGap = CONTAINER_SCAN_MIN_GAP_DEFAULT;

    @PostConstruct
    public void validate() {
        if (this.metadataScanInterval < 0L) {
            LOG.warn("hdds.container.scrub.metadata.scan.interval must be >= 0 and was set to {}. Defaulting to {}", (Object)this.metadataScanInterval, (Object)METADATA_SCAN_INTERVAL_DEFAULT);
            this.metadataScanInterval = METADATA_SCAN_INTERVAL_DEFAULT;
        }
        if (this.dataScanInterval < 0L) {
            LOG.warn("hdds.container.scrub.data.scan.interval must be >= 0 and was set to {}. Defaulting to {}", (Object)this.dataScanInterval, (Object)DATA_SCAN_INTERVAL_DEFAULT);
            this.dataScanInterval = DATA_SCAN_INTERVAL_DEFAULT;
        }
        if (this.containerScanMinGap < 0L) {
            LOG.warn("hdds.container.scrub.min.gap must be >= 0 and was set to {}. Defaulting to {}", (Object)this.containerScanMinGap, (Object)CONTAINER_SCAN_MIN_GAP);
            this.containerScanMinGap = CONTAINER_SCAN_MIN_GAP_DEFAULT;
        }
        if (this.bandwidthPerVolume < 0L) {
            LOG.warn("hdds.container.scrub.volume.bytes.per.second must be >= 0 and was set to {}. Defaulting to {}", (Object)this.bandwidthPerVolume, (Object)0x500000L);
            this.bandwidthPerVolume = 0x500000L;
        }
        if (this.onDemandBandwidthPerVolume < 0L) {
            LOG.warn("hdds.container.scrub.on.demand.volume.bytes.per.second must be >= 0 and was set to {}. Defaulting to {}", (Object)this.onDemandBandwidthPerVolume, (Object)0x500000L);
            this.onDemandBandwidthPerVolume = 0x500000L;
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isDataScanEnabled() {
        return this.dataScanEnabled;
    }

    public boolean isMetadataScanEnabled() {
        return this.metadataScanEnabled;
    }

    public void setMetadataScanInterval(long metadataScanInterval) {
        this.metadataScanInterval = metadataScanInterval;
    }

    public long getMetadataScanInterval() {
        return this.metadataScanInterval;
    }

    public void setDataScanInterval(long dataScanInterval) {
        this.dataScanInterval = dataScanInterval;
    }

    public long getDataScanInterval() {
        return this.dataScanInterval;
    }

    public long getBandwidthPerVolume() {
        return this.bandwidthPerVolume;
    }

    public long getOnDemandBandwidthPerVolume() {
        return this.onDemandBandwidthPerVolume;
    }

    public long getContainerScanMinGap() {
        return this.containerScanMinGap;
    }
}

