/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ozoneimpl;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.ozoneimpl.AbstractBackgroundContainerScanner;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerController;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerMetadataScannerMetrics;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerScannerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundContainerMetadataScanner
extends AbstractBackgroundContainerScanner {
    public static final Logger LOG = LoggerFactory.getLogger(BackgroundContainerMetadataScanner.class);
    private final ContainerMetadataScannerMetrics metrics;
    private final ContainerController controller;
    private final long minScanGap;

    public BackgroundContainerMetadataScanner(ContainerScannerConfiguration conf, ContainerController controller) {
        super("ContainerMetadataScanner", conf.getMetadataScanInterval());
        this.controller = controller;
        this.metrics = ContainerMetadataScannerMetrics.create();
        this.minScanGap = conf.getContainerScanMinGap();
    }

    @Override
    public Iterator<Container<?>> getContainerIterator() {
        return this.controller.getContainers().iterator();
    }

    @Override
    @VisibleForTesting
    public void scanContainer(Container<?> container) throws IOException, InterruptedException {
        Object data = container.getContainerData();
        long containerID = ((ContainerData)data).getContainerID();
        HddsVolume containerVolume = ((ContainerData)data).getVolume();
        if (containerVolume.isFailed()) {
            LOG.debug("Skipping scan of container {}. Its volume {} has failed.", (Object)containerID, (Object)containerVolume);
            return;
        }
        if (!this.shouldScan(container)) {
            return;
        }
        Container.ScanResult result = container.scanMetaData();
        if (!result.isHealthy()) {
            LOG.error("Corruption detected in container [{}]. Marking it UNHEALTHY.", (Object)containerID, (Object)result.getException());
            this.metrics.incNumUnHealthyContainers();
            this.controller.markContainerUnhealthy(containerID, result);
        }
        this.metrics.incNumContainersScanned();
    }

    @Override
    public ContainerMetadataScannerMetrics getMetrics() {
        return this.metrics;
    }

    private boolean shouldScan(Container<?> container) {
        return container.shouldScanMetadata() && !ContainerUtils.recentlyScanned(container, this.minScanGap, LOG);
    }
}

