/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ec.reconstruction;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.symmetric.SecretKeySignerClient;
import org.apache.hadoop.hdds.security.token.ContainerTokenIdentifier;
import org.apache.hadoop.hdds.security.token.ContainerTokenSecretManager;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenIdentifier;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenSecretManager;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;

class TokenHelper {
    private final OzoneBlockTokenSecretManager blockTokenMgr;
    private final ContainerTokenSecretManager containerTokenMgr;
    private final String user;
    private static final Set<HddsProtos.BlockTokenSecretProto.AccessModeProto> MODES = EnumSet.of(HddsProtos.BlockTokenSecretProto.AccessModeProto.READ, HddsProtos.BlockTokenSecretProto.AccessModeProto.WRITE, HddsProtos.BlockTokenSecretProto.AccessModeProto.DELETE);

    TokenHelper(SecurityConfig securityConfig, SecretKeySignerClient secretKeyClient) throws IOException {
        boolean securityEnabled;
        boolean blockTokenEnabled = securityConfig.isBlockTokenEnabled();
        boolean containerTokenEnabled = securityConfig.isContainerTokenEnabled();
        boolean bl = securityEnabled = secretKeyClient != null;
        if (securityEnabled && (blockTokenEnabled || containerTokenEnabled)) {
            this.user = UserGroupInformation.getCurrentUser().getShortUserName();
            long expiryTime = securityConfig.getBlockTokenExpiryDurationMs();
            this.blockTokenMgr = blockTokenEnabled ? new OzoneBlockTokenSecretManager(expiryTime, secretKeyClient) : null;
            this.containerTokenMgr = containerTokenEnabled ? new ContainerTokenSecretManager(expiryTime, secretKeyClient) : null;
        } else {
            this.user = null;
            this.blockTokenMgr = null;
            this.containerTokenMgr = null;
        }
    }

    Token<OzoneBlockTokenIdentifier> getBlockToken(BlockID blockID, long length) {
        return this.blockTokenMgr != null ? this.blockTokenMgr.generateToken(this.user, blockID, MODES, length) : null;
    }

    Token<ContainerTokenIdentifier> getContainerToken(ContainerID containerID) {
        return this.containerTokenMgr != null ? this.containerTokenMgr.generateToken(this.user, containerID) : null;
    }

    static String encode(Token<?> token) throws IOException {
        return token != null ? token.encodeToUrlString() : null;
    }
}

