/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.keys;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.ratis.util.function.CheckedFunction;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public class KeyCodec {
    private static final int BUFFER_LEN = 8192;
    private final KeyFactory keyFactory;

    public KeyCodec(String keyAlgorithm) throws NoSuchAlgorithmException {
        this.keyFactory = KeyFactory.getInstance(keyAlgorithm);
    }

    public byte[] encodePublicKey(PublicKey key) throws IOException {
        return this.encodeKey("PUBLIC KEY", key);
    }

    public byte[] encodePrivateKey(PrivateKey key) throws IOException {
        return this.encodeKey("PRIVATE KEY", key);
    }

    public PrivateKey decodePrivateKey(byte[] encodedKey) throws IOException {
        return (PrivateKey)this.decodeKey(encodedKey, this.keyFactory::generatePrivate);
    }

    public PublicKey decodePublicKey(byte[] encodedKey) throws IOException {
        return (PublicKey)this.decodeKey(encodedKey, ks -> this.keyFactory.generatePublic(new X509EncodedKeySpec(ks.getEncoded())));
    }

    /*
     * Exception decompiling
     */
    private byte[] encodeKey(String keyType, Key key) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T decodeKey(byte[] encodedKey, CheckedFunction<PKCS8EncodedKeySpec, T, InvalidKeySpecException> generator) throws IOException {
        try (PemReader pemReader = new PemReader((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(encodedKey), StandardCharsets.US_ASCII));){
            PemObject keyObject = pemReader.readPemObject();
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(keyObject.getContent());
            Object object = generator.apply((Object)pkcs8EncodedKeySpec);
            return (T)object;
        }
        catch (InvalidKeySpecException e) {
            throw new IOException(e);
        }
    }
}

