/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.cditest.owb;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.ResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Singleton;
import org.apache.webbeans.cditest.CdiTestContainer;
import org.apache.webbeans.cditest.owb.MockHttpSession;
import org.apache.webbeans.cditest.owb.MockServletContext;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.ContextFactory;
import org.apache.webbeans.context.type.ContextTypes;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.util.InjectionExceptionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CdiTestOpenWebBeansContainer
implements CdiTestContainer {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(CdiTestOpenWebBeansContainer.class);
    private ContainerLifecycle lifecycle = null;
    private MockServletContext servletContext = null;
    private MockHttpSession session = null;

    public void bootContainer() throws Exception {
        this.servletContext = new MockServletContext();
        this.session = new MockHttpSession();
        this.lifecycle = (ContainerLifecycle)WebBeansContext.getInstance().getService(ContainerLifecycle.class);
        this.lifecycle.startApplication((Object)this.servletContext);
    }

    public void shutdownContainer() throws Exception {
        if (this.lifecycle != null) {
            this.lifecycle.stopApplication((Object)this.servletContext);
        }
    }

    public void startContexts() throws Exception {
        WebBeansContext webBeansContext = WebBeansContext.getInstance();
        ContextFactory contextFactory = webBeansContext.getContextFactory();
        contextFactory.initSingletonContext((Object)this.servletContext);
        contextFactory.initApplicationContext((Object)this.servletContext);
        contextFactory.initSessionContext((Object)this.session);
        contextFactory.initConversationContext(null);
        contextFactory.initRequestContext(null);
    }

    public void startApplicationScope() throws Exception {
        WebBeansContext webBeansContext = WebBeansContext.getInstance();
        ContextFactory contextFactory = webBeansContext.getContextFactory();
        contextFactory.initApplicationContext((Object)this.servletContext);
    }

    public void startConversationScope() throws Exception {
        WebBeansContext webBeansContext = WebBeansContext.getInstance();
        ContextFactory contextFactory = webBeansContext.getContextFactory();
        contextFactory.initConversationContext(null);
    }

    public void startCustomScope(Class<? extends Annotation> scopeClass) throws Exception {
    }

    public void startRequestScope() throws Exception {
        WebBeansContext webBeansContext = WebBeansContext.getInstance();
        ContextFactory contextFactory = webBeansContext.getContextFactory();
        contextFactory.initRequestContext(null);
    }

    public void startSessionScope() throws Exception {
        WebBeansContext webBeansContext = WebBeansContext.getInstance();
        ContextFactory contextFactory = webBeansContext.getContextFactory();
        contextFactory.initSessionContext((Object)this.session);
    }

    public void stopContexts() throws Exception {
        WebBeansContext webBeansContext = WebBeansContext.getInstance();
        ContextFactory contextFactory = webBeansContext.getContextFactory();
        this.stopSessionScope();
        this.stopConversationScope();
        this.stopRequestScope();
        this.stopApplicationScope();
        Context context = contextFactory.getStandardContext(ContextTypes.SINGLETON);
        if (context != null && context.isActive()) {
            contextFactory.destroySingletonContext((Object)this.servletContext);
        } else if (logger.wblWillLogWarn()) {
            logger.warn("destroy was called for an inactive context (" + Singleton.class.getName() + ")");
        }
    }

    public void stopApplicationScope() throws Exception {
        WebBeansContext webBeansContext = WebBeansContext.getInstance();
        ContextFactory contextFactory = webBeansContext.getContextFactory();
        Context context = contextFactory.getStandardContext(ContextTypes.APPLICATION);
        if (context != null && context.isActive()) {
            contextFactory.destroyApplicationContext((Object)this.servletContext);
        } else if (logger.wblWillLogWarn()) {
            logger.warn("destroy was called for an inactive context (" + ApplicationScoped.class.getName() + ")");
        }
    }

    public void stopConversationScope() throws Exception {
        WebBeansContext webBeansContext = WebBeansContext.getInstance();
        ContextFactory contextFactory = webBeansContext.getContextFactory();
        Context context = contextFactory.getStandardContext(ContextTypes.CONVERSATION);
        if (context != null && context.isActive()) {
            contextFactory.destroyConversationContext();
        } else if (logger.wblWillLogWarn()) {
            logger.warn("destroy was called for an inactive context (" + ConversationScoped.class.getName() + ")");
        }
    }

    public void stopCustomScope(Class<? extends Annotation> scopeClass) throws Exception {
    }

    public void stopRequestScope() throws Exception {
        WebBeansContext webBeansContext = WebBeansContext.getInstance();
        ContextFactory contextFactory = webBeansContext.getContextFactory();
        Context context = contextFactory.getStandardContext(ContextTypes.REQUEST);
        if (context != null && context.isActive()) {
            contextFactory.destroyRequestContext(null);
        } else if (logger.wblWillLogWarn()) {
            logger.warn("destroy was called for an inactive context (" + RequestScoped.class.getName() + ")");
        }
    }

    public void stopSessionScope() throws Exception {
        WebBeansContext webBeansContext = WebBeansContext.getInstance();
        ContextFactory contextFactory = webBeansContext.getContextFactory();
        Context context = contextFactory.getStandardContext(ContextTypes.SESSION);
        if (context != null && context.isActive()) {
            contextFactory.destroySessionContext((Object)this.session);
        } else if (logger.wblWillLogWarn()) {
            logger.warn("destroy was called for an inactive context (" + SessionScoped.class.getName() + ")");
        }
    }

    public BeanManager getBeanManager() {
        return this.lifecycle.getBeanManager();
    }

    public <T> T getInstance(Class<T> type, Annotation ... qualifiers) throws ResolutionException {
        Set beans = this.getBeanManager().getBeans(type, qualifiers);
        if (beans == null || beans.isEmpty()) {
            InjectionExceptionUtils.throwBeanNotFoundException(type, (Annotation[])qualifiers);
        }
        if (beans.size() > 1) {
            InjectionExceptionUtils.throwAmbiguousResolutionException((Set)beans, type, null, (Annotation[])qualifiers);
        }
        Bean bean = (Bean)beans.iterator().next();
        Object instance = this.getBeanManager().getReference(bean, type, this.getBeanManager().createCreationalContext((Contextual)bean));
        return (T)instance;
    }

    public Object getInstance(String name) throws ResolutionException {
        return null;
    }
}

