/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.failover;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.UUID;
import javax.servlet.http.HttpSession;
import org.apache.webbeans.config.OpenWebBeansConfiguration;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.spi.FailOverService;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.web.failover.FailOverBagWrapper;

public class DefaultOwbFailOverService
implements FailOverService {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(DefaultOwbFailOverService.class);
    private static final String OWB_FAILOVER_JVM_ID = UUID.randomUUID().toString() + "_" + String.valueOf(System.currentTimeMillis());
    private static final String OWB_FAILOVER_PROPERTY_NAME = "org.apache.webbeans.web.failover";
    private static final String OWB_FAILOVER_IS_SUPPORT_FAILOVER = "org.apache.webbeans.web.failover.issupportfailover";
    private static final String OWB_FAILOVER_IS_SUPPORT_PASSIVATE = "org.apache.webbeans.web.failover.issupportpassivation";
    boolean isSupportFailOver;
    boolean isSupportPassivation;

    public DefaultOwbFailOverService() {
        String value = OpenWebBeansConfiguration.getInstance().getProperty(OWB_FAILOVER_IS_SUPPORT_FAILOVER);
        if (value != null && value.equalsIgnoreCase("true")) {
            this.isSupportFailOver = true;
        }
        if ((value = OpenWebBeansConfiguration.getInstance().getProperty(OWB_FAILOVER_IS_SUPPORT_PASSIVATE)) != null && value.equalsIgnoreCase("true")) {
            this.isSupportPassivation = true;
        }
        if (this.isSupportFailOver || this.isSupportPassivation) {
            WebBeansUtil.initProxyFactoryClassLoaderProvider();
        }
        if (logger.wblWillLogDebug()) {
            logger.debug("DefaultOwbFailOverService isSupportFailOver: [{0}]", new Object[]{String.valueOf(this.isSupportFailOver)});
            logger.debug("DefaultOwbFailOverService isSupportPassivation: [{0}]", new Object[]{String.valueOf(this.isSupportPassivation)});
        }
    }

    public String getJVMId() {
        return OWB_FAILOVER_JVM_ID;
    }

    public String getFailOverAttributeName() {
        return OWB_FAILOVER_PROPERTY_NAME;
    }

    public void sessionIsIdle(HttpSession session) {
        if (session != null) {
            FailOverBagWrapper bagWrapper = (FailOverBagWrapper)session.getAttribute(this.getFailOverAttributeName());
            if (bagWrapper == null) {
                bagWrapper = new FailOverBagWrapper(session, this);
            } else {
                bagWrapper.updateOwbFailOverBag(session, this);
            }
            session.setAttribute(this.getFailOverAttributeName(), (Object)bagWrapper);
        }
    }

    public void sessionIsInUse(HttpSession session) {
        FailOverBagWrapper bagWrapper;
        if (session != null && (bagWrapper = (FailOverBagWrapper)session.getAttribute(this.getFailOverAttributeName())) != null) {
            bagWrapper.sessionIsInUse();
        }
    }

    public void sessionWillPassivate(HttpSession session) {
        FailOverBagWrapper bagWrapper = new FailOverBagWrapper(session, this);
        session.setAttribute(this.getFailOverAttributeName(), (Object)bagWrapper);
    }

    public void restoreBeans(HttpSession session) {
        FailOverBagWrapper bagWrapper = (FailOverBagWrapper)session.getAttribute(this.getFailOverAttributeName());
        if (bagWrapper != null) {
            logger.debug("DefaultOwbFailOverService restoreBeans for session: [{0}]", new Object[]{session});
            bagWrapper.restore();
            session.removeAttribute(this.getFailOverAttributeName());
        }
    }

    public boolean isSupportFailOver() {
        return this.isSupportFailOver;
    }

    public boolean isSupportPassivation() {
        return this.isSupportPassivation;
    }

    public void enableFailOverSupport(boolean flag) {
        this.isSupportFailOver = flag;
    }

    public void enablePassivationSupport(boolean flag) {
        this.isSupportPassivation = flag;
    }

    private static void verifyTest(FailOverBagWrapper bagWrapper) {
        byte[] bytes = DefaultOwbFailOverService.getBytes(bagWrapper);
        FailOverBagWrapper bagWrapper3 = (FailOverBagWrapper)DefaultOwbFailOverService.getObject(bytes);
        System.out.println(bagWrapper3);
    }

    private static byte[] getBytes(Object obj) {
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        byte[] buf = new byte[]{};
        try {
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            buf = baos.toByteArray();
            oos.close();
            baos.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return buf;
    }

    private static Object getObject(byte[] buf) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(buf);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object obj = ois.readObject();
            ois.close();
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

