/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.context;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ContextException;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.webbeans.config.OpenWebBeansConfiguration;
import org.apache.webbeans.context.AbstractContextsService;
import org.apache.webbeans.context.ApplicationContext;
import org.apache.webbeans.context.ConversationContext;
import org.apache.webbeans.context.DependentContext;
import org.apache.webbeans.context.RequestContext;
import org.apache.webbeans.context.SessionContext;
import org.apache.webbeans.context.SingletonContext;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.el.ELContextStore;
import org.apache.webbeans.web.context.SessionContextManager;

public class WebContextsService
extends AbstractContextsService {
    private static ThreadLocal<RequestContext> requestContext = null;
    private static ThreadLocal<SessionContext> sessionContext = null;
    private static ThreadLocal<ApplicationContext> applicationContext = null;
    private static ThreadLocal<ConversationContext> conversationContext = null;
    private static ThreadLocal<SingletonContext> singletonContext = null;
    private static DependentContext dependentContext;
    private static Map<ServletContext, ApplicationContext> currentApplicationContexts;
    private static Map<ServletContext, SingletonContext> currentSingletonContexts;
    private final SessionContextManager sessionCtxManager = SessionContextManager.getInstance();
    private final ConversationManager conversationManager = ConversationManager.getInstance();
    private boolean supportsConversation = OpenWebBeansConfiguration.getInstance().supportsConversation();

    public void init(Object initializeObject) {
        this.startContext(ApplicationScoped.class, initializeObject);
        this.startContext(Singleton.class, initializeObject);
    }

    public void destroy(Object destroyObject) {
        this.endContext(ApplicationScoped.class, destroyObject);
        this.endContext(Singleton.class, destroyObject);
        currentApplicationContexts.clear();
        currentSingletonContexts.clear();
        requestContext.set(null);
        sessionContext.set(null);
        conversationContext.set(null);
        applicationContext.set(null);
        singletonContext.set(null);
        requestContext.remove();
        sessionContext.remove();
        conversationContext.remove();
        applicationContext.remove();
        singletonContext.remove();
    }

    public void endContext(Class<? extends Annotation> scopeType, Object endParameters) {
        if (this.supportsContext(scopeType)) {
            if (scopeType.equals(RequestScoped.class)) {
                this.destroyRequestContext((ServletRequestEvent)endParameters);
            } else if (scopeType.equals(SessionScoped.class)) {
                this.destroySessionContext((HttpSession)endParameters);
            } else if (scopeType.equals(ApplicationScoped.class)) {
                this.destroyApplicationContext((ServletContext)endParameters);
            } else if (scopeType.equals(ConversationScoped.class)) {
                this.destroyConversationContext();
            } else if (!scopeType.equals(Dependent.class)) {
                this.destroySingletonContext((ServletContext)endParameters);
            }
        }
    }

    public Context getCurrentContext(Class<? extends Annotation> scopeType) {
        if (this.supportsContext(scopeType)) {
            if (scopeType.equals(RequestScoped.class)) {
                return this.getRequestContext();
            }
            if (scopeType.equals(SessionScoped.class)) {
                return this.getSessionContext();
            }
            if (scopeType.equals(ApplicationScoped.class)) {
                return this.getApplicationContext();
            }
            if (scopeType.equals(ConversationScoped.class)) {
                return this.getConversationContext();
            }
            if (scopeType.equals(Dependent.class)) {
                return dependentContext;
            }
            return this.getSingletonContext();
        }
        return null;
    }

    public void startContext(Class<? extends Annotation> scopeType, Object startParameter) throws ContextException {
        if (this.supportsContext(scopeType)) {
            if (scopeType.equals(RequestScoped.class)) {
                this.initRequestContext((ServletRequestEvent)startParameter);
            } else if (scopeType.equals(SessionScoped.class)) {
                this.initSessionContext((HttpSession)startParameter);
            } else if (scopeType.equals(ApplicationScoped.class)) {
                this.initApplicationContext((ServletContext)startParameter);
            } else if (scopeType.equals(ConversationScoped.class)) {
                this.initConversationContext((ConversationContext)startParameter);
            } else if (!scopeType.equals(Dependent.class)) {
                this.initSingletonContext((ServletContext)startParameter);
            }
        }
    }

    public boolean supportsContext(Class<? extends Annotation> scopeType) {
        return scopeType.equals(RequestScoped.class) || scopeType.equals(SessionScoped.class) || scopeType.equals(ApplicationScoped.class) || scopeType.equals(Dependent.class) || scopeType.equals(Singleton.class) || scopeType.equals(ConversationScoped.class) && this.supportsConversation;
    }

    private void initRequestContext(ServletRequestEvent event) {
        HttpServletRequest request;
        RequestContext rq = new RequestContext();
        rq.setActive(true);
        requestContext.set(rq);
        if (event != null && (request = (HttpServletRequest)event.getServletRequest()) != null) {
            HttpSession session = request.getSession(false);
            if (session != null) {
                this.initSessionContext(session);
            }
            this.initApplicationContext(event.getServletContext());
            this.initSingletonContext(event.getServletContext());
        }
    }

    private void destroyRequestContext(ServletRequestEvent request) {
        RequestContext context = this.getRequestContext();
        if (context != null) {
            context.destroy();
        }
        ELContextStore.localContext.set(null);
        ELContextStore.localContext.remove();
        requestContext.set(null);
        requestContext.remove();
        applicationContext.set(null);
        applicationContext.remove();
        singletonContext.set(null);
        singletonContext.remove();
    }

    private void initSessionContext(HttpSession session) {
        String sessionId = session.getId();
        SessionContext currentSessionContext = this.sessionCtxManager.getSessionContextWithSessionId(sessionId);
        if (currentSessionContext == null) {
            currentSessionContext = new SessionContext();
            this.sessionCtxManager.addNewSessionContext(sessionId, currentSessionContext);
        }
        currentSessionContext.setActive(true);
        sessionContext.set(currentSessionContext);
    }

    private void destroySessionContext(HttpSession session) {
        SessionContext context = this.getSessionContext();
        if (context != null) {
            context.destroy();
        }
        sessionContext.set(null);
        sessionContext.remove();
        this.sessionCtxManager.destroySessionContextWithSessionId(session.getId());
    }

    private void initApplicationContext(ServletContext servletContext) {
        if (servletContext != null && currentApplicationContexts.containsKey(servletContext)) {
            applicationContext.set(currentApplicationContexts.get(servletContext));
        } else {
            ApplicationContext currentApplicationContext = new ApplicationContext();
            currentApplicationContext.setActive(true);
            if (servletContext != null) {
                currentApplicationContexts.put(servletContext, currentApplicationContext);
            }
            applicationContext.set(currentApplicationContext);
        }
    }

    private void destroyApplicationContext(ServletContext servletContext) {
        ApplicationContext context = null;
        if (servletContext != null) {
            context = currentApplicationContexts.get(servletContext);
        }
        if (context == null) {
            context = this.getApplicationContext();
        }
        if (context != null) {
            context.destroy();
        }
        if (servletContext != null) {
            currentApplicationContexts.remove(servletContext);
        }
        this.sessionCtxManager.destroyAllSessions();
        this.conversationManager.destroyAllConversations();
    }

    private void initSingletonContext(ServletContext servletContext) {
        if (servletContext != null && currentSingletonContexts.containsKey(servletContext)) {
            singletonContext.set(currentSingletonContexts.get(servletContext));
        } else {
            SingletonContext context = new SingletonContext();
            context.setActive(true);
            if (servletContext != null) {
                currentSingletonContexts.put(servletContext, context);
            }
            singletonContext.set(context);
        }
    }

    private void destroySingletonContext(ServletContext servletContext) {
        SingletonContext context = null;
        if (servletContext != null) {
            context = currentSingletonContexts.get(servletContext);
        }
        if (context == null) {
            context = this.getSingletonContext();
        }
        if (context != null) {
            context.destroy();
        }
        if (servletContext != null) {
            currentSingletonContexts.remove(servletContext);
        }
    }

    private void initConversationContext(ConversationContext context) {
        if (context == null) {
            if (conversationContext.get() == null) {
                ConversationContext newContext = new ConversationContext();
                newContext.setActive(true);
                conversationContext.set(newContext);
            } else {
                conversationContext.get().setActive(true);
            }
        } else {
            context.setActive(true);
            conversationContext.set(context);
        }
    }

    private void destroyConversationContext() {
        ConversationContext context = this.getConversationContext();
        if (context != null) {
            context.destroy();
        }
        conversationContext.set(null);
        conversationContext.remove();
    }

    private RequestContext getRequestContext() {
        return requestContext.get();
    }

    private SessionContext getSessionContext() {
        return sessionContext.get();
    }

    private ApplicationContext getApplicationContext() {
        return applicationContext.get();
    }

    private SingletonContext getSingletonContext() {
        return singletonContext.get();
    }

    private ConversationContext getConversationContext() {
        return conversationContext.get();
    }

    static {
        currentApplicationContexts = new ConcurrentHashMap<ServletContext, ApplicationContext>();
        currentSingletonContexts = new ConcurrentHashMap<ServletContext, SingletonContext>();
        requestContext = new ThreadLocal();
        sessionContext = new ThreadLocal();
        applicationContext = new ThreadLocal();
        conversationContext = new ThreadLocal();
        singletonContext = new ThreadLocal();
        dependentContext = new DependentContext();
        dependentContext.setActive(true);
    }
}

