/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.servlet;

import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.lifecycle.LifecycleFactory;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.util.WebBeansUtil;

public class WebBeansConfigurationListener
implements ServletContextListener,
ServletRequestListener,
HttpSessionListener,
HttpSessionActivationListener {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(WebBeansConfigurationListener.class);
    private ContainerLifecycle lifeCycle = null;

    public void contextInitialized(ServletContextEvent event) {
        this.lifeCycle = LifecycleFactory.getInstance().getLifecycle();
        try {
            this.lifeCycle.startApplication((Object)event);
            event.getServletContext().setAttribute("org.apache.webbeans.application.isOwbApplication", (Object)"true");
        }
        catch (Exception e) {
            logger.error("ERROR_0018", new Object[]{event.getServletContext().getContextPath()});
            WebBeansUtil.throwRuntimeExceptions((Exception)e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.lifeCycle.stopApplication((Object)event);
        this.lifeCycle = null;
        event.getServletContext().setAttribute("org.apache.webbeans.application.isOwbApplication", (Object)"false");
    }

    public void requestDestroyed(ServletRequestEvent event) {
        if (logger.wblWillLogDebug()) {
            logger.debug("Destroying a request : [{0}]", new Object[]{event.getServletRequest().getRemoteAddr()});
        }
        this.lifeCycle.getContextService().endContext(RequestScoped.class, (Object)event);
    }

    public void requestInitialized(ServletRequestEvent event) {
        try {
            HttpServletRequest httpRequest;
            HttpSession currentSession;
            if (logger.wblWillLogDebug()) {
                logger.debug("Starting a new request : [{0}]", new Object[]{event.getServletRequest().getRemoteAddr()});
            }
            this.lifeCycle.getContextService().startContext(RequestScoped.class, (Object)event);
            ServletRequest request = event.getServletRequest();
            if (request instanceof HttpServletRequest && (currentSession = (httpRequest = (HttpServletRequest)request).getSession(false)) == null) {
                try {
                    httpRequest.getSession();
                }
                catch (Exception e) {
                    logger.error("ERROR_0013", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error("ERROR_0019", new Object[]{event.getServletRequest()});
            WebBeansUtil.throwRuntimeExceptions((Exception)e);
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
        try {
            if (logger.wblWillLogDebug()) {
                logger.debug("Starting a session with session id : [{0}]", new Object[]{event.getSession().getId()});
            }
            this.lifeCycle.getContextService().startContext(SessionScoped.class, (Object)event.getSession());
        }
        catch (Exception e) {
            logger.error("ERROR_0020", new Object[]{event.getSession()});
            WebBeansUtil.throwRuntimeExceptions((Exception)e);
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (logger.wblWillLogDebug()) {
            logger.debug("Destroying a session with session id : [{0}]", new Object[]{event.getSession().getId()});
        }
        this.lifeCycle.getContextService().endContext(SessionScoped.class, (Object)event.getSession());
        ConversationManager conversationManager = ConversationManager.getInstance();
        conversationManager.destroyConversationContextWithSessionId(event.getSession().getId());
    }

    public void sessionDidActivate(HttpSessionEvent event) {
    }

    public void sessionWillPassivate(HttpSessionEvent event) {
    }
}

