/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openwebbeans.se;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.inject.se.SeContainer;
import javax.enterprise.inject.se.SeContainerInitializer;
import javax.enterprise.inject.spi.Extension;
import org.apache.openwebbeans.se.CDISeBeanArchiveService;
import org.apache.openwebbeans.se.CDISeLoaderService;
import org.apache.openwebbeans.se.CDISeScannerService;
import org.apache.openwebbeans.se.OWBContainer;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.corespi.DefaultSingletonService;
import org.apache.webbeans.spi.BeanArchiveService;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.LoaderService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.spi.SingletonService;
import org.apache.webbeans.xml.DefaultBeanArchiveInformation;

public class OWBInitializer
extends SeContainerInitializer {
    protected final CDISeScannerService scannerService = new CDISeScannerService();
    protected final Properties properties = new Properties();
    protected final Map<String, Object> services = new HashMap<String, Object>();
    protected final Collection<Extension> extensions = new ArrayList<Extension>();
    protected final DefaultBeanArchiveInformation bai = new DefaultBeanArchiveInformation("cdi-standalone");
    protected ClassLoader loader = Thread.currentThread().getContextClassLoader();

    public OWBInitializer() {
        this.scannerService.loader(this.loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SeContainer initialize() {
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(this.loader);
        try {
            this.services.putIfAbsent(ScannerService.class.getName(), this.getScannerService());
            this.services.putIfAbsent(LoaderService.class.getName(), (Object)new CDISeLoaderService(this.extensions, this.loader));
            this.services.putIfAbsent(BeanArchiveService.class.getName(), (Object)new CDISeBeanArchiveService(this.bai));
            this.addCustomServices(this.services);
            Map<Class, Object> preparedServices = this.services.entrySet().stream().collect(Collectors.toMap(e -> {
                try {
                    return this.loader.loadClass((String)e.getKey());
                }
                catch (ClassNotFoundException e1) {
                    throw new IllegalArgumentException(e1);
                }
            }, Map.Entry::getValue));
            WebBeansContext context = new WebBeansContext(preparedServices, this.properties);
            SingletonService singletonInstance = WebBeansFinder.getSingletonService();
            ((DefaultSingletonService)DefaultSingletonService.class.cast(singletonInstance)).register(this.loader, context);
            SeContainer seContainer = this.newContainer(context);
            return seContainer;
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    protected void addCustomServices(Map<String, Object> services) {
    }

    protected SeContainer newContainer(WebBeansContext context) {
        Object startObj = new Object();
        ((ContainerLifecycle)context.getService(ContainerLifecycle.class)).startApplication(startObj);
        return new OWBContainer(context, startObj);
    }

    protected ScannerService getScannerService() {
        return this.scannerService;
    }

    public SeContainerInitializer addBeanClasses(Class<?> ... classes) {
        this.scannerService.classes(classes);
        return this;
    }

    public SeContainerInitializer addPackages(Package ... packages) {
        return this.addPackages(false, packages);
    }

    public SeContainerInitializer addPackages(boolean scanRecursively, Package ... packages) {
        this.scannerService.packages(scanRecursively, packages);
        return this;
    }

    public SeContainerInitializer addPackages(Class<?> ... packageClasses) {
        return this.addPackages(false, packageClasses);
    }

    public SeContainerInitializer addPackages(boolean scanRecursively, Class<?> ... packageClasses) {
        this.scannerService.packages(scanRecursively, packageClasses);
        return this;
    }

    public SeContainerInitializer enableInterceptors(Class<?> ... interceptorClasses) {
        this.bai.getInterceptors().addAll(Stream.of(interceptorClasses).map(Class::getName).collect(Collectors.toList()));
        return this;
    }

    public SeContainerInitializer enableDecorators(Class<?> ... decoratorClasses) {
        this.bai.getDecorators().addAll(Stream.of(decoratorClasses).map(Class::getName).collect(Collectors.toList()));
        return this;
    }

    public SeContainerInitializer selectAlternatives(Class<?> ... alternativeClasses) {
        this.bai.getAlternativeClasses().addAll(Stream.of(alternativeClasses).map(Class::getName).collect(Collectors.toList()));
        return this;
    }

    public SeContainerInitializer selectAlternativeStereotypes(Class<? extends Annotation> ... alternativeStereotypeClasses) {
        this.bai.getAlternativeStereotypes().addAll(Stream.of(alternativeStereotypeClasses).map(Class::getName).collect(Collectors.toList()));
        return this;
    }

    public SeContainerInitializer addExtensions(Extension ... extensions) {
        this.extensions.addAll(Arrays.asList(extensions));
        return this;
    }

    public SeContainerInitializer addExtensions(Class<? extends Extension> ... extensions) {
        this.extensions.addAll(Stream.of(extensions).map(e -> {
            try {
                return (Extension)e.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException e1) {
                throw new IllegalArgumentException(e1);
            }
            catch (InvocationTargetException e1) {
                throw new IllegalArgumentException(e1.getCause());
            }
        }).collect(Collectors.toList()));
        return this;
    }

    public SeContainerInitializer addProperty(String key, Object value) {
        if (String.class.isInstance(value)) {
            this.properties.put(key, value);
        } else {
            this.services.put(key, value);
        }
        return this;
    }

    public SeContainerInitializer setProperties(Map<String, Object> properties) {
        properties.forEach(this::addProperty);
        return this;
    }

    public SeContainerInitializer disableDiscovery() {
        this.scannerService.disableAutoScanning();
        return this;
    }

    public SeContainerInitializer setClassLoader(ClassLoader classLoader) {
        this.loader = classLoader;
        this.scannerService.loader(this.loader);
        return this;
    }
}

