/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.resource.spi.se;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.xml.ws.WebServiceRef;
import org.apache.webbeans.logger.WebBeansLoggerFacade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneResourceProcessor {
    private static InitialContext context = null;
    private static Logger logger = WebBeansLoggerFacade.getLogger(StandaloneResourceProcessor.class);
    private static StandaloneResourceProcessor processor = new StandaloneResourceProcessor();
    private Map<String, EntityManagerFactory> factoryCache = new ConcurrentHashMap<String, EntityManagerFactory>();

    public static StandaloneResourceProcessor getProcessor() {
        return processor;
    }

    public <X> X getEntityManager(PersistenceContext persistenceContext, Class<X> clazz) {
        EntityManager obj = this.getPersistenceContext(persistenceContext.unitName());
        if (obj == null) {
            logger.log(Level.WARNING, WebBeansLoggerFacade.constructMessage((String)"WARN_0014", (Object[])new Object[]{"@PersistenceContext", persistenceContext.unitName()}));
        }
        return clazz.cast(obj);
    }

    public <X> X getEntityManagerFactory(PersistenceUnit persistenceUnit, Class<X> clazz) {
        EntityManagerFactory factory = this.getPersistenceUnit(persistenceUnit.unitName());
        if (factory == null) {
            logger.log(Level.WARNING, WebBeansLoggerFacade.constructMessage((String)"WARN_0014", (Object[])new Object[]{"@PersistenceUnit", persistenceUnit.unitName()}));
        }
        return clazz.cast(factory);
    }

    public <X> X getResource(Resource resource, Class<X> resourceType) {
        Object obj = null;
        try {
            obj = context.lookup("java:/comp/env/" + resource.name());
            if (obj == null) {
                logger.log(Level.WARNING, WebBeansLoggerFacade.constructMessage((String)"WARN_0014", (Object[])new Object[]{"@Resource", resource.name()}));
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage((String)"ERROR_0001", (Object[])new Object[]{resource}));
        }
        return resourceType.cast(obj);
    }

    public <X> X getWebServiceResource(WebServiceRef resource, Class<X> resourceType) {
        Object obj = null;
        try {
            obj = context.lookup("java:/comp/env/" + resource.name());
            if (obj == null) {
                logger.log(Level.WARNING, WebBeansLoggerFacade.constructMessage((String)"WARN_0014", (Object[])new Object[]{"@WebServiceRef", resource.name()}));
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage((String)"ERROR_0001", (Object[])new Object[]{resource}));
        }
        return resourceType.cast(obj);
    }

    private EntityManagerFactory getPersistenceUnit(String unitName) {
        if (this.factoryCache.get(unitName) != null) {
            return this.factoryCache.get(unitName);
        }
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)unitName);
        this.factoryCache.put(unitName, emf);
        return emf;
    }

    private EntityManager getPersistenceContext(String unitName) {
        EntityManagerFactory emf = this.getPersistenceUnit(unitName);
        EntityManager em = emf.createEntityManager();
        return em;
    }

    public void clear() {
        Set<String> keys = this.factoryCache.keySet();
        for (String key : keys) {
            EntityManagerFactory factory = this.factoryCache.get(key);
            try {
                factory.close();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, WebBeansLoggerFacade.constructMessage((String)"WARN_0006", (Object[])new Object[]{e, key}));
            }
        }
    }

    static {
        try {
            context = new InitialContext();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

