/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openwebbeans.junit5.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.se.SeContainer;
import javax.enterprise.inject.se.SeContainerInitializer;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import org.apache.openwebbeans.junit5.Cdi;
import org.apache.openwebbeans.junit5.internal.CdiParametersResolverExtension;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

public class CdiExtension
extends CdiParametersResolverExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private static SeContainer reusableContainer;
    private SeContainer testInstanceContainer;
    private Collection<CreationalContext<?>> creationalContexts = new ArrayList();
    private AutoCloseable[] onStop;

    public void beforeAll(ExtensionContext extensionContext) {
        Cdi config = AnnotationUtils.findAnnotation((Optional)extensionContext.getElement(), Cdi.class).orElse(null);
        if (config == null) {
            return;
        }
        boolean reusable = config.reusable();
        if (reusable && reusableContainer != null) {
            return;
        }
        if (!reusable && reusableContainer != null) {
            throw new IllegalStateException("You can't mix @Cdi(reusable=true) and @Cdi(reusable=false) in the same suite");
        }
        SeContainerInitializer initializer = SeContainerInitializer.newInstance();
        if (config.disableDiscovery()) {
            initializer.disableDiscovery();
        }
        initializer.setClassLoader(Thread.currentThread().getContextClassLoader());
        initializer.addBeanClasses((Class[])config.classes());
        initializer.enableDecorators((Class[])config.decorators());
        initializer.enableInterceptors((Class[])config.interceptors());
        initializer.selectAlternatives((Class[])config.alternatives());
        initializer.selectAlternativeStereotypes((Class[])config.alternativeStereotypes());
        initializer.addPackages((Package[])Stream.of(config.packages()).map(Class::getPackage).toArray(Package[]::new));
        initializer.addPackages(true, (Package[])Stream.of(config.recursivePackages()).map(Class::getPackage).toArray(Package[]::new));
        Stream.of(config.properties()).forEach(property -> initializer.addProperty(property.name(), (Object)property.value()));
        this.onStop = (AutoCloseable[])Stream.of(config.onStarts()).map(it -> {
            try {
                return (Cdi.OnStart)it.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e.getTargetException());
            }
        }).map(Supplier::get).toArray(AutoCloseable[]::new);
        SeContainer container = initializer.initialize();
        if (reusable) {
            reusableContainer = container;
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.doClose(reusableContainer), this.getClass().getName() + "-shutdown"));
        } else {
            this.testInstanceContainer = container;
        }
    }

    public void afterAll(ExtensionContext extensionContext) {
        if (this.testInstanceContainer != null) {
            this.doClose(this.testInstanceContainer);
            this.testInstanceContainer = null;
        }
    }

    public void beforeEach(ExtensionContext extensionContext) {
        SeContainer container = this.getContainer();
        if (container == null) {
            return;
        }
        extensionContext.getTestInstances().ifPresent(testInstances -> testInstances.getAllInstances().stream().distinct().forEach(instance -> {
            BeanManager manager = container.getBeanManager();
            AnnotatedType annotatedType = manager.createAnnotatedType(instance.getClass());
            InjectionTarget injectionTarget = manager.createInjectionTarget(annotatedType);
            CreationalContext creationalContext = manager.createCreationalContext(null);
            this.creationalContexts.add(creationalContext);
            injectionTarget.inject(instance, creationalContext);
        }));
    }

    @Override
    public void afterEach(ExtensionContext extensionContext) {
        super.afterEach(extensionContext);
        if (!this.creationalContexts.isEmpty()) {
            this.creationalContexts.forEach(CreationalContext::release);
            this.creationalContexts.clear();
        }
    }

    private void doClose(SeContainer container) {
        container.close();
        Stream.of(this.onStop).forEach(it -> {
            try {
                it.close();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }

    private SeContainer getContainer() {
        if (this.testInstanceContainer != null) {
            return this.testInstanceContainer;
        }
        return reusableContainer;
    }
}

