/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.jsf.scopes;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.faces.bean.ViewScoped;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PreDestroyViewMapEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.apache.webbeans.util.JSFUtil;

public class ViewScopedContext
implements Context,
SystemEventListener {
    private static final String COMPONENT_MAP_NAME = "openwebbeans.componentInstanceMap";
    private static final String CREATIONAL_MAP_NAME = "openwebbeans.creationalInstanceMap";
    private boolean isJsfSubscribed = false;

    public <T> T get(Contextual<T> component) {
        Map viewMap;
        ConcurrentHashMap componentInstanceMap;
        this.checkActive();
        if (!this.isJsfSubscribed) {
            FacesContext.getCurrentInstance().getApplication().subscribeToEvent(PreDestroyViewMapEvent.class, (SystemEventListener)this);
            this.isJsfSubscribed = true;
        }
        if ((componentInstanceMap = (ConcurrentHashMap)(viewMap = JSFUtil.getViewRoot().getViewMap()).get(COMPONENT_MAP_NAME)) == null) {
            return null;
        }
        Object instance = componentInstanceMap.get(component);
        return (T)instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Contextual<T> component, CreationalContext<T> creationalContext) {
        Object instance;
        ConcurrentHashMap<Contextual<T>, CreationalContext<T>> creationalContextMap;
        this.checkActive();
        Map viewMap = JSFUtil.getViewRoot().getViewMap(true);
        ConcurrentHashMap componentInstanceMap = (ConcurrentHashMap)viewMap.get(COMPONENT_MAP_NAME);
        if (componentInstanceMap == null) {
            componentInstanceMap = new ConcurrentHashMap();
            viewMap.put(COMPONENT_MAP_NAME, componentInstanceMap);
        }
        if ((creationalContextMap = (ConcurrentHashMap<Contextual<T>, CreationalContext<T>>)viewMap.get(CREATIONAL_MAP_NAME)) == null) {
            creationalContextMap = new ConcurrentHashMap<Contextual<T>, CreationalContext<T>>();
            viewMap.put(CREATIONAL_MAP_NAME, creationalContextMap);
        }
        if ((instance = componentInstanceMap.get(component)) != null) {
            return (T)instance;
        }
        if (creationalContext == null) {
            return null;
        }
        ConcurrentHashMap concurrentHashMap = componentInstanceMap;
        synchronized (concurrentHashMap) {
            Object i = componentInstanceMap.get(component);
            if (i != null) {
                return (T)i;
            }
            instance = component.create(creationalContext);
            if (instance != null) {
                componentInstanceMap.put(component, instance);
                creationalContextMap.put(component, creationalContext);
            }
        }
        return (T)instance;
    }

    public Class<? extends Annotation> getScope() {
        return ViewScoped.class;
    }

    public boolean isActive() {
        return JSFUtil.getViewRoot() != null;
    }

    private void checkActive() {
        if (!this.isActive()) {
            throw new ContextNotActiveException("WebBeans context with scope annotation @ViewScoped is not active with respect to the current thread");
        }
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof UIViewRoot;
    }

    public void processEvent(SystemEvent event) {
        if (event instanceof PreDestroyViewMapEvent) {
            Map viewMap = ((UIViewRoot)event.getSource()).getViewMap();
            ConcurrentHashMap componentInstanceMap = (ConcurrentHashMap)viewMap.get(COMPONENT_MAP_NAME);
            ConcurrentHashMap creationalContextMap = (ConcurrentHashMap)viewMap.get(CREATIONAL_MAP_NAME);
            if (componentInstanceMap != null) {
                for (Map.Entry componentEntry : componentInstanceMap.entrySet()) {
                    Contextual contextual = (Contextual)componentEntry.getKey();
                    Object instance = componentEntry.getValue();
                    CreationalContext creational = (CreationalContext)creationalContextMap.get(contextual);
                    contextual.destroy(instance, creational);
                }
            }
        }
    }
}

