/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.el;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import java.util.HashMap;
import java.util.Map;

public final class ELContextStore {
    private static ThreadLocal<ELContextStore> contextStores = new ThreadLocal();
    private Map<Bean<?>, CreationalStore<?>> dependentObjects = new HashMap();
    private Map<String, Bean<?>> beanNameToDependentBeanMapping = new HashMap();
    private Map<String, Object> normalScopedObjects = new HashMap<String, Object>();

    public static ELContextStore getInstance(boolean createIfNotExist) {
        ELContextStore store = contextStores.get();
        if (store == null && createIfNotExist) {
            store = new ELContextStore();
            contextStores.set(store);
        }
        return store;
    }

    public Object findBeanByName(String name) {
        Object cachedBean = this.normalScopedObjects.get(name);
        if (cachedBean != null) {
            return cachedBean;
        }
        Bean<?> dependentBean = this.beanNameToDependentBeanMapping.get(name);
        if (dependentBean == null) {
            return null;
        }
        CreationalStore<?> cs = this.dependentObjects.get(dependentBean);
        if (cs != null) {
            return cs.getObject();
        }
        return null;
    }

    private ELContextStore() {
    }

    public void addDependent(Bean<?> bean, Object dependent, CreationalContext<?> creationalContext) {
        this.dependentObjects.put(bean, new CreationalStore<Object>(dependent, creationalContext));
        this.beanNameToDependentBeanMapping.put(bean.getName(), bean);
    }

    public Object getDependent(Bean<?> bean) {
        CreationalStore<?> sc = this.dependentObjects.get(bean);
        return sc != null ? sc.getObject() : null;
    }

    public void addNormalScoped(String beanName, Object contextualInstance) {
        this.normalScopedObjects.put(beanName, contextualInstance);
    }

    public void destroyDependents() {
        if (this.dependentObjects.size() > 0) {
            for (Map.Entry<Bean<?>, CreationalStore<?>> storeEntry : this.dependentObjects.entrySet()) {
                CreationalStore<?> store = storeEntry.getValue();
                Bean<?> contextual = storeEntry.getKey();
                contextual.destroy(store.getObject(), store.getCreational());
            }
            this.dependentObjects.clear();
        }
        this.beanNameToDependentBeanMapping.clear();
    }

    public void destroyELContextStore() {
        this.normalScopedObjects.clear();
        contextStores.set(null);
        contextStores.remove();
    }

    private static class CreationalStore<T> {
        private T object;
        private CreationalContext<T> creational;

        public CreationalStore(T object, CreationalContext<T> creational) {
            this.object = object;
            this.creational = creational;
        }

        public T getObject() {
            return this.object;
        }

        public CreationalContext<T> getCreational() {
            return this.creational;
        }
    }
}

