/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.configurator;

import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.enterprise.inject.spi.configurator.BeanAttributesConfigurator;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import org.apache.webbeans.annotation.AnyLiteral;
import org.apache.webbeans.component.BeanAttributesImpl;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.util.GenericsUtil;

public class BeanAttributesConfiguratorImpl<T>
implements BeanAttributesConfigurator<T> {
    private final WebBeansContext webBeansContext;
    private Set<Type> types;
    private Set<Annotation> qualifiers;
    private Class<? extends Annotation> scope;
    private String name;
    private Set<Class<? extends Annotation>> stereotypes;
    private boolean alternative;

    public BeanAttributesConfiguratorImpl(WebBeansContext webBeansContext, BeanAttributes<T> originalBeanAttribute) {
        this.webBeansContext = webBeansContext;
        this.types = new HashSet<Type>(originalBeanAttribute.getTypes());
        this.qualifiers = new HashSet<Annotation>(originalBeanAttribute.getQualifiers());
        this.scope = originalBeanAttribute.getScope();
        this.name = originalBeanAttribute.getName();
        this.stereotypes = new HashSet<Class<? extends Annotation>>(originalBeanAttribute.getStereotypes());
        this.alternative = originalBeanAttribute.isAlternative();
    }

    public BeanAttributesConfigurator<T> addType(Type type) {
        this.types.add(type);
        return this;
    }

    public BeanAttributesConfigurator<T> addType(TypeLiteral typeLiteral) {
        this.types.add(typeLiteral.getType());
        return this;
    }

    public BeanAttributesConfigurator<T> addTypes(Type ... types) {
        for (Type type : types) {
            this.types.add(type);
        }
        return this;
    }

    public BeanAttributesConfigurator<T> addTypes(Set set) {
        this.types.addAll(set);
        return this;
    }

    public BeanAttributesConfigurator<T> addTransitiveTypeClosure(Type type) {
        Set<Type> typeClosure = GenericsUtil.getTypeClosure(type, type);
        this.types.addAll(typeClosure);
        return this;
    }

    public BeanAttributesConfigurator<T> types(Type ... types) {
        this.types.clear();
        this.addTypes(types);
        return this;
    }

    public BeanAttributesConfigurator<T> types(Set<Type> set) {
        this.types.clear();
        this.addTypes(set);
        return this;
    }

    public BeanAttributesConfigurator<T> scope(Class<? extends Annotation> scope) {
        this.scope = scope;
        return this;
    }

    public BeanAttributesConfigurator<T> addQualifier(Annotation qualifier) {
        this.qualifiers.add(qualifier);
        return this;
    }

    public BeanAttributesConfigurator<T> addQualifiers(Annotation ... qualifiers) {
        for (Annotation qualifier : qualifiers) {
            this.addQualifiers(qualifier);
        }
        return this;
    }

    public BeanAttributesConfigurator<T> addQualifiers(Set<Annotation> qualifiers) {
        this.qualifiers.addAll(qualifiers);
        return this;
    }

    public BeanAttributesConfigurator<T> qualifiers(Annotation ... qualifiers) {
        this.qualifiers.clear();
        for (Annotation qualifier : qualifiers) {
            this.addQualifier(qualifier);
        }
        return this;
    }

    public BeanAttributesConfigurator<T> qualifiers(Set<Annotation> qualifiers) {
        this.qualifiers.clear();
        this.addQualifiers(qualifiers);
        return this;
    }

    public BeanAttributesConfigurator<T> addStereotype(Class<? extends Annotation> stereotype) {
        this.stereotypes.add(stereotype);
        return this;
    }

    public BeanAttributesConfigurator<T> addStereotypes(Set<Class<? extends Annotation>> stereotypes) {
        this.stereotypes.addAll(stereotypes);
        return this;
    }

    public BeanAttributesConfigurator<T> stereotypes(Set<Class<? extends Annotation>> stereotypes) {
        this.stereotypes.clear();
        this.addStereotypes(stereotypes);
        return this;
    }

    public BeanAttributesConfigurator<T> name(String name) {
        this.name = name;
        return this;
    }

    public BeanAttributesConfigurator<T> alternative(boolean value) {
        this.alternative = value;
        return this;
    }

    public BeanAttributes<T> getBeanAttributes() {
        this.qualifiers.add((Annotation)((Object)AnyLiteral.INSTANCE));
        return new BeanAttributesImpl(this.types, this.qualifiers, this.scope, this.name, this.stereotypes, this.alternative);
    }
}

