/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.inject.instance;

import jakarta.enterprise.context.spi.AlterableContext;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.util.TypeLiteral;
import jakarta.inject.Provider;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.intercept.NormalScopedBeanInterceptorHandler;
import org.apache.webbeans.proxy.OwbNormalScopeProxy;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.InjectionExceptionUtil;
import org.apache.webbeans.util.OwbCustomObjectInputStream;
import org.apache.webbeans.util.WebBeansUtil;

public class InstanceImpl<T>
implements Instance<T>,
Serializable {
    private static final long serialVersionUID = -8401944412490389024L;
    private Type injectionClazz;
    private InjectionPoint injectionPoint;
    private Set<Annotation> qualifierAnnotations = new HashSet<Annotation>();
    private WebBeansContext webBeansContext;
    private Map<Object, CreationalContextImpl<?>> creationalContexts;
    private boolean strictValidation;

    public InstanceImpl(Type injectionClazz, InjectionPoint injectionPoint, WebBeansContext webBeansContext, Annotation ... qualifiers) {
        this.injectionClazz = injectionClazz;
        this.injectionPoint = injectionPoint;
        this.webBeansContext = webBeansContext;
        this.strictValidation = webBeansContext.getOpenWebBeansConfiguration().strictDynamicValidation();
        if (this.strictValidation) {
            webBeansContext.getAnnotationManager().checkQualifierConditions(qualifiers);
        }
        for (Annotation ann : qualifiers) {
            this.qualifierAnnotations.add(ann);
        }
    }

    public Instance.Handle<T> getHandle() {
        return new HandleImpl(this.getBean());
    }

    public Iterable<? extends Instance.Handle<T>> handles() {
        return this.resolveBeans().stream().map(bean -> new HandleImpl((Bean<?>)bean)).collect(Collectors.toList());
    }

    public T get() {
        Bean<?> bean = this.getBean();
        return this.create(bean);
    }

    private Bean<?> getBean() {
        Set beans = this.resolveBeans();
        Bean bean = this.webBeansContext.getBeanManagerImpl().resolve(beans);
        if (bean == null) {
            Annotation[] anns = new Annotation[this.qualifierAnnotations.size()];
            anns = this.qualifierAnnotations.toArray(anns);
            InjectionExceptionUtil.throwUnsatisfiedResolutionException(ClassUtil.getClazz(this.injectionClazz), this.injectionPoint, anns);
        }
        return bean;
    }

    private Set<Bean<?>> resolveBeans() {
        Annotation[] anns = new Annotation[this.qualifierAnnotations.size()];
        anns = this.qualifierAnnotations.toArray(anns);
        InjectionResolver injectionResolver = this.webBeansContext.getBeanManagerImpl().getInjectionResolver();
        Bean injectionPointBean = this.injectionPoint != null ? this.injectionPoint.getBean() : null;
        Class injectionPointClass = null;
        if (injectionPointBean != null) {
            injectionPointClass = injectionPointBean.getBeanClass();
        }
        Set beans = injectionResolver.implResolveByType(false, this.injectionClazz, injectionPointClass, anns);
        return injectionResolver.resolveAll(beans);
    }

    public boolean isAmbiguous() {
        Set<Bean<?>> beans = this.resolveBeans();
        return beans.size() > 1;
    }

    public boolean isUnsatisfied() {
        Set<Bean<?>> beans = this.resolveBeans();
        return beans.isEmpty();
    }

    public Instance<T> select(Annotation ... qualifiers) {
        if (this.strictValidation) {
            this.webBeansContext.getAnnotationManager().checkQualifierConditions(qualifiers);
        }
        Annotation[] newQualifiersArray = qualifiers.length == 0 ? this.qualifierAnnotations.toArray(new Annotation[0]) : this.concatenateQualifiers(qualifiers);
        return new InstanceImpl<T>(this.injectionClazz, this.injectionPoint == null ? null : new InstanceInjectionPoint(this.injectionPoint, newQualifiersArray), this.webBeansContext, newQualifiersArray);
    }

    public <U extends T> Instance<U> select(Class<U> subtype, Annotation ... qualifiers) {
        Type sub;
        if (this.strictValidation) {
            this.webBeansContext.getAnnotationManager().checkQualifierConditions(qualifiers);
        }
        if ((sub = subtype) == null) {
            sub = this.injectionClazz;
        }
        Annotation[] effectiveQualifiers = qualifiers != null && qualifiers.length > 0 ? this.concatenateQualifiers(qualifiers) : this.qualifierAnnotations.toArray(new Annotation[0]);
        return new InstanceImpl<T>(sub, this.injectionPoint, this.webBeansContext, effectiveQualifiers);
    }

    public <U extends T> Instance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        return this.select(subtype.getRawType(), qualifiers);
    }

    public Iterator<T> iterator() {
        final Iterator<Bean<?>> beans = this.resolveBeans().iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return beans.hasNext();
            }

            @Override
            public T next() {
                return InstanceImpl.this.create((Bean)beans.next());
            }
        };
    }

    private Annotation[] concatenateQualifiers(Annotation[] additionalQualifiers) {
        return (Annotation[])Stream.concat(this.qualifierAnnotations.stream().filter(it -> it.annotationType() != Any.class).filter(it -> it != DefaultLiteral.INSTANCE), Stream.of(additionalQualifiers)).toArray(Annotation[]::new);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void destroy(T instance) {
        if (instance == null) {
            throw new NullPointerException("instance is null, can't be destroyed");
        }
        if (instance instanceof OwbNormalScopeProxy) {
            OwbNormalScopeProxy proxy = (OwbNormalScopeProxy)instance;
            Provider provider = this.webBeansContext.getNormalScopeProxyFactory().getInstanceProvider(proxy);
            NormalScopedBeanInterceptorHandler handler = (NormalScopedBeanInterceptorHandler)provider;
            Bean<?> bean = handler.getBean();
            Class beanScope = bean.getScope();
            Context currentContext = this.webBeansContext.getBeanManagerImpl().getContext(beanScope);
            if (!(currentContext instanceof AlterableContext)) throw new UnsupportedOperationException("Not AlterableContext so you can't call destroy youself");
            AlterableContext alterableContext = (AlterableContext)currentContext;
            alterableContext.destroy(bean);
            return;
        } else {
            CreationalContextImpl<?> creationalContext = this.creationalContexts.remove(instance);
            if (creationalContext == null) {
                throw new IllegalArgumentException("instance " + instance + " not produced with this Instance<?>");
            }
            creationalContext.destroyDependent(instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T create(Bean<?> bean) {
        BeanManagerImpl beanManager = this.webBeansContext.getBeanManagerImpl();
        CreationalContext creationalContext = beanManager.createCreationalContext((Contextual)bean);
        creationalContext.putInjectionPoint(this.injectionPoint);
        try {
            Object reference = beanManager.getReference(bean, this.injectionClazz, creationalContext);
            if (this.creationalContexts == null) {
                this.creationalContexts = new IdentityHashMap();
            }
            this.creationalContexts.put(reference, (CreationalContextImpl<?>)creationalContext);
            Object object = reference;
            return (T)object;
        }
        finally {
            creationalContext.removeInjectionPoint();
        }
    }

    private void writeObject(ObjectOutputStream op) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(op);
        oos.writeObject(this.injectionClazz);
        oos.writeObject(this.qualifierAnnotations);
        oos.writeObject(this.injectionPoint);
        oos.flush();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.webBeansContext = WebBeansContext.currentInstance();
        OwbCustomObjectInputStream inputStream = new OwbCustomObjectInputStream(in, WebBeansUtil.getCurrentClassLoader());
        this.injectionClazz = (Type)inputStream.readObject();
        this.qualifierAnnotations = (Set)inputStream.readObject();
        this.injectionPoint = (InjectionPoint)inputStream.readObject();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Instance<");
        builder.append(ClassUtil.getClazz(this.injectionClazz).getName());
        builder.append("> injectionPointClazz=").append(this.injectionPoint);
        builder.append(",with qualifier annotations {");
        int i = 0;
        for (Annotation qualifier : this.qualifierAnnotations) {
            if (i != 0) {
                builder.append(",");
            }
            builder.append(qualifier.toString());
            ++i;
        }
        builder.append("}");
        return builder.toString();
    }

    public void release() {
        if (this.creationalContexts != null) {
            for (CreationalContextImpl<?> creationalContext : this.creationalContexts.values()) {
                creationalContext.release();
            }
        }
    }

    public class HandleImpl<X>
    implements Instance.Handle<X> {
        private final Bean<X> bean;
        private boolean destroyed = false;
        private X contextualReference = null;

        public HandleImpl(Bean<?> bean) {
            this.bean = bean;
        }

        public X get() {
            if (this.destroyed) {
                throw new IllegalStateException("Contextual Reference already destroyed");
            }
            if (this.contextualReference == null) {
                this.contextualReference = InstanceImpl.this.create(this.bean);
            }
            return this.contextualReference;
        }

        public Bean<X> getBean() {
            return this.bean;
        }

        public void destroy() {
            if (!this.destroyed && this.contextualReference != null) {
                InstanceImpl.this.destroy(this.contextualReference);
                this.destroyed = true;
            }
        }

        public void close() {
            this.destroy();
        }
    }

    private static class InstanceInjectionPoint
    implements InjectionPoint,
    Serializable {
        private InjectionPoint delegate;
        private Set<Annotation> qualifiers;

        protected InstanceInjectionPoint(InjectionPoint injectionPoint, Annotation[] newQualifiersArray) {
            this.delegate = injectionPoint;
            this.qualifiers = Collections.unmodifiableSet(new HashSet<Annotation>(Arrays.asList(newQualifiersArray)));
        }

        public Type getType() {
            return this.delegate.getType();
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public Bean<?> getBean() {
            return this.delegate.getBean();
        }

        public Member getMember() {
            return this.delegate.getMember();
        }

        public Annotated getAnnotated() {
            return this.delegate.getAnnotated();
        }

        public boolean isDelegate() {
            return this.delegate.isDelegate();
        }

        public boolean isTransient() {
            return this.delegate.isTransient();
        }

        private void readObject(ObjectInputStream inp) throws IOException, ClassNotFoundException {
            OwbCustomObjectInputStream owbCustomObjectInputStream = new OwbCustomObjectInputStream(inp, WebBeansUtil.getCurrentClassLoader());
            this.qualifiers = (Set)Set.class.cast(owbCustomObjectInputStream.readObject());
            this.delegate = (InjectionPoint)InjectionPoint.class.cast(owbCustomObjectInputStream.readObject());
        }

        private void writeObject(ObjectOutputStream op) throws IOException {
            ObjectOutputStream out = new ObjectOutputStream(op);
            out.writeObject(this.qualifiers);
            out.writeObject(this.delegate);
        }
    }
}

