/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.configurator;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.configurator.AnnotatedConstructorConfigurator;
import javax.enterprise.inject.spi.configurator.AnnotatedParameterConfigurator;
import org.apache.webbeans.configurator.AnnotatedParameterConfiguratorImpl;
import org.apache.webbeans.portable.AnnotatedConstructorImpl;

public class AnnotatedConstructorConfiguratorImpl<T>
implements AnnotatedConstructorConfigurator<T> {
    private final AnnotatedConstructorImpl<T> annotatedConstructor;
    private final List<AnnotatedParameterConfigurator<T>> annotatedParameterConfigurators;

    public AnnotatedConstructorConfiguratorImpl(AnnotatedConstructorImpl<T> annotatedConstructor) {
        this.annotatedConstructor = annotatedConstructor;
        this.annotatedParameterConfigurators = annotatedConstructor.getParameters().stream().map(AnnotatedParameterConfiguratorImpl::new).collect(Collectors.toList());
    }

    public AnnotatedConstructor<T> getAnnotated() {
        return this.annotatedConstructor;
    }

    public AnnotatedConstructorConfigurator<T> add(Annotation annotation) {
        this.annotatedConstructor.addAnnotation(annotation);
        return this;
    }

    public AnnotatedConstructorConfigurator<T> remove(Predicate predicate) {
        this.annotatedConstructor.getAnnotations().removeIf(predicate);
        return this;
    }

    public AnnotatedConstructorConfigurator<T> removeAll() {
        this.annotatedConstructor.getAnnotations().clear();
        return this;
    }

    public List<AnnotatedParameterConfigurator<T>> params() {
        return this.annotatedParameterConfigurators;
    }
}

