/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable.events;

import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.configurator.AnnotatedTypeConfiguratorImpl;
import org.apache.webbeans.portable.events.AfterObserver;
import org.apache.webbeans.portable.events.EventBase;

public class ProcessAnnotatedTypeImpl<X>
extends EventBase
implements ProcessAnnotatedType<X>,
AfterObserver {
    private final WebBeansContext webBeansContext;
    private AnnotatedType<X> annotatedType;
    private boolean veto;
    private boolean modifiedAnnotatedType;
    private AnnotatedTypeConfiguratorImpl configurator;

    public ProcessAnnotatedTypeImpl(WebBeansContext webBeansContext, AnnotatedType<X> annotatedType) {
        this.webBeansContext = webBeansContext;
        this.annotatedType = annotatedType;
    }

    public AnnotatedType<X> getAnnotatedType() {
        this.checkState();
        if (this.configurator == null) {
            return this.annotatedType;
        }
        return this.configurator.getNewAnnotatedType();
    }

    public void setAnnotatedType(AnnotatedType<X> type) {
        this.checkState();
        if (this.configurator != null) {
            throw new IllegalStateException("You can't call setAnnotatedType() and configureAnnotatedType()");
        }
        this.annotatedType = type;
        this.modifiedAnnotatedType = true;
    }

    public boolean isModifiedAnnotatedType() {
        return this.modifiedAnnotatedType || this.configurator != null;
    }

    public void veto() {
        this.checkState();
        this.veto = true;
    }

    public AnnotatedTypeConfigurator<X> configureAnnotatedType() {
        this.checkState();
        if (this.modifiedAnnotatedType) {
            throw new IllegalStateException("You can't call setAnnotatedType() and configureAnnotatedType()");
        }
        if (this.configurator == null) {
            this.configurator = new AnnotatedTypeConfiguratorImpl<X>(this.webBeansContext, this.annotatedType);
        }
        return this.configurator;
    }

    public boolean isVeto() {
        return this.veto;
    }

    @Override
    public void afterObserver() {
        if (this.configurator != null) {
            this.annotatedType = this.configurator.getNewAnnotatedType();
            this.configurator = null;
        } else if (this.modifiedAnnotatedType) {
            this.modifiedAnnotatedType = false;
        }
    }
}

