/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.util.WebBeansUtil;

public final class PropertyLoader {
    public static final int CONFIGURATION_ORDINAL_DEFAULT_VALUE = 100;
    public static final String CONFIGURATION_ORDINAL_PROPERTY_NAME = "configuration.ordinal";
    private static final Logger logger = WebBeansLoggerFacade.getLogger(PropertyLoader.class);

    private PropertyLoader() {
    }

    public static synchronized Properties getProperties(String propertyFileName) {
        try {
            List<Properties> allProperties = PropertyLoader.loadAllProperties(propertyFileName);
            if (allProperties == null) {
                return null;
            }
            List<Properties> sortedProperties = PropertyLoader.sortProperties(allProperties);
            Properties properties = PropertyLoader.mergeProperties(sortedProperties);
            return properties;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error while loading the propertyFile " + propertyFileName, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Properties> loadAllProperties(String propertyFileName) throws IOException {
        ClassLoader cl = WebBeansUtil.getCurrentClassLoader();
        Enumeration<URL> propertyUrls = cl.getResources(propertyFileName);
        if (propertyUrls == null || !propertyUrls.hasMoreElements()) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("could not find any property files with name " + propertyFileName);
            }
            return null;
        }
        ArrayList<Properties> properties = new ArrayList<Properties>();
        while (propertyUrls.hasMoreElements()) {
            URL propertyUrl = propertyUrls.nextElement();
            InputStream is = null;
            try {
                is = propertyUrl.openStream();
                Properties prop = new Properties();
                prop.load(is);
                properties.add(prop);
                int ordinal = PropertyLoader.getConfigurationOrdinal(prop);
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine("loading properties with ordinal " + ordinal + " from file " + propertyUrl.getFile());
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        return properties;
    }

    private static List<Properties> sortProperties(List<Properties> allProperties) {
        ArrayList<Properties> sortedProperties = new ArrayList<Properties>();
        for (Properties p : allProperties) {
            int listConfigOrder;
            int i;
            int configOrder = PropertyLoader.getConfigurationOrdinal(p);
            for (i = 0; i < sortedProperties.size() && (listConfigOrder = PropertyLoader.getConfigurationOrdinal((Properties)sortedProperties.get(i))) <= configOrder; ++i) {
            }
            sortedProperties.add(i, p);
        }
        return sortedProperties;
    }

    private static int getConfigurationOrdinal(Properties p) {
        int configOrder = 100;
        String configOrderString = p.getProperty(CONFIGURATION_ORDINAL_PROPERTY_NAME);
        if (configOrderString != null && configOrderString.length() > 0) {
            try {
                configOrder = Integer.parseInt(configOrderString);
            }
            catch (NumberFormatException nfe) {
                logger.severe("configuration.ordinal must be an integer value!");
                throw nfe;
            }
        }
        return configOrder;
    }

    private static Properties mergeProperties(List<Properties> sortedProperties) {
        Properties mergedProperties = new Properties();
        for (Properties p : sortedProperties) {
            mergedProperties.putAll((Map<?, ?>)p);
        }
        return mergedProperties;
    }
}

