/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.xml;

import java.util.ArrayList;
import java.util.List;
import org.apache.webbeans.spi.BeanArchiveService;

public class DefaultBeanArchiveInformation
implements BeanArchiveService.BeanArchiveInformation {
    private String version;
    private BeanArchiveService.BeanDiscoveryMode beanDiscoveryMode;
    private List<String> interceptors = new ArrayList<String>();
    private List<String> decorators = new ArrayList<String>();
    private List<String> alternativeClasses = new ArrayList<String>();
    private List<String> alternativeStereotypes = new ArrayList<String>();
    private List<String> excludedClasses = null;
    private List<String> excludedPackages = null;

    public BeanArchiveService.BeanDiscoveryMode getBeanDiscoveryMode() {
        return this.beanDiscoveryMode;
    }

    public boolean isClassExcluded(String clazz) {
        boolean isExcluded = this.isPackageExcluded(clazz);
        if (!isExcluded && this.excludedClasses != null) {
            for (String excludedClass : this.excludedClasses) {
                int lastDotPosition;
                if (!clazz.startsWith(excludedClass) || clazz.length() > excludedClass.length() && (lastDotPosition = clazz.lastIndexOf(46)) > excludedClass.length()) continue;
                isExcluded = true;
                break;
            }
        }
        return isExcluded;
    }

    public boolean isPackageExcluded(String packageName) {
        if (this.excludedPackages != null) {
            for (String excludedPackage : this.excludedPackages) {
                if (!packageName.startsWith(excludedPackage)) continue;
                return true;
            }
        }
        return false;
    }

    public String getVersion() {
        return this.version;
    }

    public List<String> getInterceptors() {
        return this.interceptors;
    }

    public List<String> getDecorators() {
        return this.decorators;
    }

    public List<String> getAlternativeClasses() {
        return this.alternativeClasses;
    }

    public List<String> getAlternativeStereotypes() {
        return this.alternativeStereotypes;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setBeanDiscoveryMode(BeanArchiveService.BeanDiscoveryMode beanDiscoveryMode) {
        this.beanDiscoveryMode = beanDiscoveryMode;
    }

    public void setInterceptors(List<String> interceptors) {
        this.interceptors = interceptors;
    }

    public void setDecorators(List<String> decorators) {
        this.decorators = decorators;
    }

    public void addClassExclude(String classOrPath) {
        if (this.excludedClasses == null) {
            this.excludedClasses = new ArrayList<String>();
        }
        this.excludedClasses.add(classOrPath);
    }

    public void addPackageExclude(String packageName) {
        if (this.excludedPackages == null) {
            this.excludedPackages = new ArrayList<String>();
        }
        this.excludedPackages.add(packageName);
    }

    public List<String> getExcludedClasses() {
        return this.excludedClasses;
    }

    public void setExcludedClasses(List<String> excludedClasses) {
        this.excludedClasses = excludedClasses;
    }

    public List<String> getExcludedPackages() {
        return this.excludedPackages;
    }

    public void setExcludedPackages(List<String> excludedPackages) {
        this.excludedPackages = excludedPackages;
    }
}

