/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import org.apache.webbeans.annotation.AnnotationManager;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.util.Asserts;

public final class InterceptorUtil {
    private final WebBeansContext webBeansContext;

    public InterceptorUtil(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public List<Class> getReverseClassHierarchy(Class clazz) {
        ArrayList<Class> hierarchy = new ArrayList<Class>();
        while (clazz != null && clazz != Object.class) {
            hierarchy.add(0, clazz);
            clazz = clazz.getSuperclass();
        }
        return hierarchy;
    }

    public List<AnnotatedMethod<?>> getLifecycleMethods(AnnotatedType<?> annotatedType, Class<? extends Annotation> annotation, boolean parentFirst) {
        ArrayList lifecycleMethods = new ArrayList();
        List<Class> classes = this.getReverseClassHierarchy(annotatedType.getJavaClass());
        for (Class clazz : classes) {
            for (AnnotatedMethod annotatedMethod : annotatedType.getMethods()) {
                if (annotatedMethod.getDeclaringType().getJavaClass() != clazz || !annotatedMethod.isAnnotationPresent(annotation)) continue;
                if (parentFirst) {
                    lifecycleMethods.add(annotatedMethod);
                    continue;
                }
                lifecycleMethods.add(0, annotatedMethod);
            }
        }
        return lifecycleMethods;
    }

    public void checkSimpleWebBeansInterceptorConditions(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz);
        Annotation[] anns = clazz.getDeclaredAnnotations();
        boolean hasClassInterceptors = false;
        AnnotationManager annotationManager = this.webBeansContext.getAnnotationManager();
        if (annotationManager.getInterceptorBindingMetaAnnotations(anns).length > 0) {
            hasClassInterceptors = true;
        } else {
            Annotation[] stereoTypes = annotationManager.getStereotypeMetaAnnotations(clazz.getDeclaredAnnotations());
            for (Annotation stero : stereoTypes) {
                if (!annotationManager.hasInterceptorBindingMetaAnnotation(stero.annotationType().getDeclaredAnnotations())) continue;
                hasClassInterceptors = true;
                break;
            }
        }
        if (Modifier.isFinal(clazz.getModifiers()) && hasClassInterceptors) {
            throw new WebBeansConfigurationException("Final Simple class with name : " + clazz.getName() + " can not define any InterceptorBindings");
        }
        Method[] methods = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredMethods(clazz);
        for (Method method : methods) {
            int modifiers = method.getModifiers();
            if (method.isSynthetic() || method.isBridge() || Modifier.isStatic(modifiers) || Modifier.isPrivate(modifiers) || !Modifier.isFinal(modifiers)) continue;
            if (hasClassInterceptors) {
                throw new WebBeansConfigurationException("Simple web bean class : " + clazz.getName() + " can not define non-static, non-private final methods. " + "Because it is annotated with at least one @InterceptorBinding");
            }
            if (!annotationManager.hasInterceptorBindingMetaAnnotation(method.getDeclaredAnnotations())) continue;
            throw new WebBeansConfigurationException("Method : " + method.getName() + "in simple web bean class : " + clazz.getName() + " can not be defined as non-static, non-private and final. " + "Because it is annotated with at least one @InterceptorBinding");
        }
    }
}

