/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.spi.Decorator;
import org.apache.webbeans.intercept.InterceptorResolutionService;
import org.apache.webbeans.proxy.InterceptorHandler;
import org.apache.webbeans.util.ExceptionUtil;

public class DecoratorHandler
implements InterceptorHandler {
    private InterceptorResolutionService.BeanInterceptorInfo interceptorInfo;
    private List<Decorator<?>> decorators;
    private Map<Decorator<?>, ?> instances;
    private int index;
    private Object target;

    public DecoratorHandler(InterceptorResolutionService.BeanInterceptorInfo interceptorInfo, Map<Decorator<?>, ?> instances, int index, Object target) {
        this.interceptorInfo = interceptorInfo;
        this.decorators = interceptorInfo.getDecorators();
        this.instances = instances;
        this.index = index;
        this.target = target;
    }

    @Override
    public Object invoke(Method method, Object[] args) {
        InterceptorResolutionService.BusinessMethodInterceptorInfo methodInterceptorInfo = this.interceptorInfo.getBusinessMethodsInfo().get(method);
        LinkedHashMap<Decorator<?>, Method> methodDecorators = methodInterceptorInfo.getMethodDecorators();
        if (methodDecorators != null) {
            for (int i = this.index; i < this.decorators.size(); ++i) {
                Decorator<?> decorator = this.decorators.get(i);
                Method decoratingMethod = methodDecorators.get(decorator);
                if (decoratingMethod == null) continue;
                try {
                    if (!decoratingMethod.isAccessible()) {
                        decoratingMethod.setAccessible(true);
                    }
                    return decoratingMethod.invoke(this.instances.get(decorator), args);
                }
                catch (InvocationTargetException e) {
                    return ExceptionUtil.throwAsRuntimeException(e.getTargetException());
                }
                catch (Exception e) {
                    return ExceptionUtil.throwAsRuntimeException(e);
                }
            }
        }
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(this.target, args);
        }
        catch (InvocationTargetException e) {
            return ExceptionUtil.throwAsRuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            return ExceptionUtil.throwAsRuntimeException(e);
        }
    }
}

